/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.mixin;

import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apothic_attributes.api.AttributeChangedValueEvent;
import dev.shadowsoffire.apothic_attributes.mixin.AttributeInstanceAccessor;
import dev.shadowsoffire.apothic_attributes.util.IAttributeManager;
import dev.shadowsoffire.apothic_attributes.util.IEntityOwned;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AttributeMap.class}, remap=false)
public class AttributeMapMixin
implements IEntityOwned,
IAttributeManager {
    protected LivingEntity owner;
    private boolean areAttributesUpdating;
    private Map<Attribute, Pair<AttributeInstance, Double>> updatingAttributes = new HashMap<Attribute, Pair<AttributeInstance, Double>>();

    @Override
    public LivingEntity getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(LivingEntity owner) {
        if (this.owner != null) {
            throw new UnsupportedOperationException("Cannot set the owner when it is already set.");
        }
        if (owner == null) {
            throw new UnsupportedOperationException("Cannot set the owner to null.");
        }
        this.owner = owner;
    }

    @Override
    public boolean areAttributesUpdating() {
        return this.areAttributesUpdating;
    }

    @Override
    public void setAttributesUpdating(boolean updating) {
        this.areAttributesUpdating = updating;
        if (this.areAttributesUpdating()) {
            this.updatingAttributes.clear();
        } else {
            if (!this.getOwner().level().isClientSide) {
                this.updatingAttributes.forEach((attr, pair) -> NeoForge.EVENT_BUS.post((Event)new AttributeChangedValueEvent(this.getOwner(), (AttributeInstance)pair.getFirst(), (Double)pair.getSecond(), ((AttributeInstance)pair.getFirst()).getValue())));
            }
            this.updatingAttributes.clear();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onAttributeModified(Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;)V"}, require=1)
    public void apoth_attrModifiedEvent(AttributeInstance inst, CallbackInfo ci) {
        if (this.owner == null) {
            throw new RuntimeException("An AttributeMap object was modified without a set owner!");
        }
        if (!this.areAttributesUpdating() && !this.owner.level().isClientSide) {
            double newValue;
            double oldValue = ((AttributeInstanceAccessor)inst).getCachedValue();
            if (oldValue != (newValue = inst.getValue())) {
                NeoForge.EVENT_BUS.post((Event)new AttributeChangedValueEvent(this.getOwner(), inst, oldValue, newValue));
            }
        } else if (this.areAttributesUpdating()) {
            this.updatingAttributes.putIfAbsent(inst.getAttribute(), (Pair<AttributeInstance, Double>)Pair.of((Object)inst, (Object)((AttributeInstanceAccessor)inst).getCachedValue()));
        }
    }
}

