/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.mixin;

import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.IFormattableAttribute;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PotionUtils.class}, remap=false)
public class PotionUtilsMixin {
    @Redirect(method={"addPotionTooltip(Ljava/util/List;Ljava/util/List;FF)V"}, at=@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z", ordinal=1), require=1)
    private static boolean apothic_attributes_potionTooltips(List<Pair<Attribute, AttributeModifier>> list, List<MobEffectInstance> effects, List<Component> tooltips, float durationFactor) {
        if (!list.isEmpty()) {
            tooltips.add(CommonComponents.EMPTY);
            tooltips.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair<Attribute, AttributeModifier> pair : list) {
                tooltips.add((Component)IFormattableAttribute.toComponent((Attribute)pair.getFirst(), (AttributeModifier)pair.getSecond(), ApothicAttributes.getTooltipFlag()));
            }
        }
        return true;
    }
}

