/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.util;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.systems.mixes.JsonMix;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MiscDatagen
implements DataProvider {
    private final Path outputDir;
    private CachedOutput cachedOutput;
    private List<CompletableFuture<?>> futures = new ArrayList();

    public MiscDatagen(Path outputDir) {
        this.outputDir = outputDir;
        Object2IntOpenHashMap map = (Object2IntOpenHashMap)DataProvider.FIXED_ORDER_FIELDS;
        map.put((Object)"mix_type", 0);
    }

    public void genPotionRecipes() {
        this.addMix(Potions.AWKWARD, Items.SHULKER_SHELL, ALObjects.Potions.RESISTANCE.get());
        this.addMix(ALObjects.Potions.RESISTANCE.get(), Items.REDSTONE, ALObjects.Potions.LONG_RESISTANCE.get());
        this.addMix(ALObjects.Potions.RESISTANCE.get(), Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_RESISTANCE.get());
        this.addMix(ALObjects.Potions.RESISTANCE.get(), Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.SUNDERING.get());
        this.addMix(ALObjects.Potions.LONG_RESISTANCE.get(), Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.LONG_SUNDERING.get());
        this.addMix(ALObjects.Potions.STRONG_RESISTANCE.get(), Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.STRONG_SUNDERING.get());
        this.addMix(ALObjects.Potions.SUNDERING.get(), Items.REDSTONE, ALObjects.Potions.LONG_SUNDERING.get());
        this.addMix(ALObjects.Potions.SUNDERING.get(), Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_SUNDERING.get());
        this.addMix(Potions.AWKWARD, Items.GOLDEN_APPLE, ALObjects.Potions.ABSORPTION.get());
        this.addMix(ALObjects.Potions.ABSORPTION.get(), Items.REDSTONE, ALObjects.Potions.LONG_ABSORPTION.get());
        this.addMix(ALObjects.Potions.ABSORPTION.get(), Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_ABSORPTION.get());
        this.addMix(Potions.AWKWARD, Items.MUSHROOM_STEW, ALObjects.Potions.HASTE.get());
        this.addMix(ALObjects.Potions.HASTE.get(), Items.REDSTONE, ALObjects.Potions.LONG_HASTE.get());
        this.addMix(ALObjects.Potions.HASTE.get(), Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_HASTE.get());
        this.addMix(ALObjects.Potions.HASTE.get(), Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.FATIGUE.get());
        this.addMix(ALObjects.Potions.LONG_HASTE.get(), Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.LONG_FATIGUE.get());
        this.addMix(ALObjects.Potions.STRONG_HASTE.get(), Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.STRONG_FATIGUE.get());
        this.addMix(ALObjects.Potions.FATIGUE.get(), Items.REDSTONE, ALObjects.Potions.LONG_FATIGUE.get());
        this.addMix(ALObjects.Potions.FATIGUE.get(), Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_FATIGUE.get());
        this.addMix(Potions.AWKWARD, Items.WITHER_SKELETON_SKULL, ALObjects.Potions.WITHER.get());
        this.addMix(ALObjects.Potions.WITHER.get(), Items.REDSTONE, ALObjects.Potions.LONG_WITHER.get());
        this.addMix(ALObjects.Potions.WITHER.get(), Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_WITHER.get());
        this.addMix(Potions.AWKWARD, Items.EXPERIENCE_BOTTLE, ALObjects.Potions.KNOWLEDGE.get());
        this.addMix(ALObjects.Potions.KNOWLEDGE.get(), Items.REDSTONE, ALObjects.Potions.LONG_KNOWLEDGE.get());
        this.addMix(ALObjects.Potions.KNOWLEDGE.get(), Items.EXPERIENCE_BOTTLE, ALObjects.Potions.STRONG_KNOWLEDGE.get());
        this.addMix(Potions.AWKWARD, Items.SWEET_BERRIES, ALObjects.Potions.VITALITY.get());
        this.addMix(ALObjects.Potions.VITALITY.get(), Items.REDSTONE, ALObjects.Potions.LONG_VITALITY.get());
        this.addMix(ALObjects.Potions.VITALITY.get(), Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_VITALITY.get());
        this.addMix(ALObjects.Potions.VITALITY.get(), Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.GRIEVOUS.get());
        this.addMix(ALObjects.Potions.LONG_VITALITY.get(), Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.LONG_GRIEVOUS.get());
        this.addMix(ALObjects.Potions.STRONG_VITALITY.get(), Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.STRONG_GRIEVOUS.get());
        this.addMix(ALObjects.Potions.GRIEVOUS.get(), Items.REDSTONE, ALObjects.Potions.LONG_GRIEVOUS.get());
        this.addMix(ALObjects.Potions.GRIEVOUS.get(), Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_GRIEVOUS.get());
        this.addMix(Potions.SLOW_FALLING, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.LEVITATION.get());
        this.addMix(ALObjects.Potions.LEVITATION.get(), Items.POPPED_CHORUS_FRUIT, ALObjects.Potions.FLYING.get());
        this.addMix(ALObjects.Potions.FLYING.get(), Items.REDSTONE, ALObjects.Potions.LONG_FLYING.get());
        this.addMix(ALObjects.Potions.LONG_FLYING.get(), Items.REDSTONE, ALObjects.Potions.EXTRA_LONG_FLYING.get());
    }

    private void addMix(Potion input, Item ingredient, Potion output) {
        ResourceLocation inKey = BuiltInRegistries.POTION.getKey((Object)input);
        ResourceLocation outKey = BuiltInRegistries.POTION.getKey((Object)output);
        this.write(new JsonMix((Object)input, Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (Object)output, JsonMix.Type.POTION), "brewing_mixes", outKey.getPath() + "_from_" + inKey.getPath());
    }

    private <T extends CodecProvider<T>> void write(T object, String type, String path) {
        this.futures.add(DataProvider.saveStable((CachedOutput)this.cachedOutput, (Codec)object.getCodec(), object, (Path)this.outputDir.resolve(type + "/" + path + ".json")));
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        this.cachedOutput = pOutput;
        this.genPotionRecipes();
        return CompletableFuture.allOf((CompletableFuture[])this.futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "apothic_attributes";
    }
}

