/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft;

import com.mojang.brigadier.CommandDispatcher;
import me.desht.pneumaticcraft.CapabilitySetup;
import me.desht.pneumaticcraft.ForcedChunks;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.ClientSetup;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.amadron.AmadronEventListener;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.commands.ModCommands;
import me.desht.pneumaticcraft.common.config.ConfigHolder;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigHandler;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.common.dispenser.DroneDispenseBehavior;
import me.desht.pneumaticcraft.common.drone.DroneSpecialVariableHandler;
import me.desht.pneumaticcraft.common.event.MiscEventHandler;
import me.desht.pneumaticcraft.common.event.PneumaticArmorHandler;
import me.desht.pneumaticcraft.common.event.UniversalSensorHandler;
import me.desht.pneumaticcraft.common.fluid.FluidSetup;
import me.desht.pneumaticcraft.common.hacking.HackEventListener;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import me.desht.pneumaticcraft.common.item.GPSAreaToolItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.BlockTrackLootable;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.registry.ModAttachmentTypes;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModConditionSerializers;
import me.desht.pneumaticcraft.common.registry.ModCreativeModeTab;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModHarvestHandlers;
import me.desht.pneumaticcraft.common.registry.ModHoeHandlers;
import me.desht.pneumaticcraft.common.registry.ModIngredientTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModLootFunctions;
import me.desht.pneumaticcraft.common.registry.ModLootModifiers;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.registry.ModParticleTypes;
import me.desht.pneumaticcraft.common.registry.ModPlacementModifierTypes;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.registry.ModVillagers;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.upgrades.UpgradesDBSetup;
import me.desht.pneumaticcraft.common.util.ItemLaunching;
import me.desht.pneumaticcraft.common.util.Reflections;
import me.desht.pneumaticcraft.common.util.playerfilter.PlayerMatcherTypes;
import me.desht.pneumaticcraft.common.villages.VillageStructures;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;

@Mod(value="pneumaticcraft")
public class PneumaticCraftRepressurized {
    public PneumaticCraftRepressurized(IEventBus modBus) {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        PneumaticRegistry.init(PneumaticCraftAPIHandler.getInstance());
        ConfigHolder.init(modBus);
        AuxConfigHandler.preInit();
        if (FMLEnvironment.dist.isClient()) {
            ClientSetup.onModConstruction(modBus);
        }
        ThirdPartyManager.instance().preInit(modBus);
        Reflections.init();
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::newRegistries);
        modBus.addListener(ForcedChunks.INSTANCE::registerTicketController);
        modBus.addListener(CapabilitySetup::registerCaps);
        this.registerAllDeferredRegistryObjects(modBus);
        forgeBus.addListener(this::serverStarted);
        forgeBus.addListener(this::serverStopping);
        forgeBus.addListener(this::addReloadListeners);
        forgeBus.addListener(this::registerCommands);
        forgeBus.register((Object)new MiscEventHandler());
        forgeBus.register((Object)new AmadronEventListener());
        forgeBus.register((Object)new PneumaticArmorHandler());
        forgeBus.register((Object)new UniversalSensorHandler());
        forgeBus.register((Object)new DroneSpecialVariableHandler());
        forgeBus.register(GPSAreaToolItem.EventHandler.class);
        forgeBus.register((Object)HackEventListener.getInstance());
        forgeBus.addListener(VillageStructures::addMechanicHouse);
    }

    private void newRegistries(NewRegistryEvent event) {
        event.register(ModHoeHandlers.HOE_HANDLER_REGISTRY);
        event.register(ModHarvestHandlers.HARVEST_HANDLER_REGISTRY);
        event.register(ModProgWidgets.PROG_WIDGETS_REGISTRY);
    }

    private void registerAllDeferredRegistryObjects(IEventBus modBus) {
        ModBlocks.BLOCKS.register(modBus);
        ModItems.ITEMS.register(modBus);
        ModFluids.FLUIDS.register(modBus);
        ModFluids.FLUID_TYPES.register(modBus);
        ModSounds.SOUNDS.register(modBus);
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.register(modBus);
        ModEntityTypes.ENTITY_TYPES.register(modBus);
        ModMenuTypes.MENU_TYPES.register(modBus);
        ModParticleTypes.PARTICLES.register(modBus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(modBus);
        ModConditionSerializers.CONDITIONS.register(modBus);
        ModIngredientTypes.INGREDIENT_TYPES.register(modBus);
        ModRecipeTypes.RECIPE_TYPES.register(modBus);
        ModVillagers.POI.register(modBus);
        ModVillagers.PROFESSIONS.register(modBus);
        ModLootModifiers.LOOT_MODIFIERS.register(modBus);
        ModCommands.COMMAND_ARGUMENT_TYPES.register(modBus);
        ModLootFunctions.LOOT_FUNCTIONS.register(modBus);
        ModPlacementModifierTypes.PLACEMENT_MODIFIERS.register(modBus);
        ModCriterionTriggers.CRITERION_TRIGGERS.register(modBus);
        ModAttachmentTypes.ATTACHMENT_TYPES.register(modBus);
        ModHarvestHandlers.HARVEST_HANDLERS_DEFERRED.register(modBus);
        ModHoeHandlers.HOE_HANDLERS_DEFERRED.register(modBus);
        ModProgWidgets.PROG_WIDGETS_DEFERRED.register(modBus);
        ModCreativeModeTab.TABS.register(modBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Log.info("PneumaticCraft: Repressurized is loading!", new Object[0]);
        ThirdPartyManager.instance().init();
        FluidSetup.init();
        CommonUpgradeHandlers.init();
        HackManager.addDefaultEntries();
        SensorHandler.getInstance().init();
        ModNameCache.init();
        HeatBehaviourManager.getInstance().registerDefaultBehaviours();
        PlayerMatcherTypes.registerDefaultMatchers();
        BlockTrackLootable.INSTANCE.addDefaultEntries();
        ItemLaunching.registerDefaultBehaviours();
        event.enqueueWork(() -> {
            ArmorUpgradeRegistry.getInstance().freeze();
            UpgradesDBSetup.init();
            DroneDispenseBehavior.registerDrones();
            ThirdPartyManager.instance().postInit();
        });
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)PneumaticCraftRecipeType.getCacheReloadListener());
    }

    private void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void serverStarted(ServerStartedEvent event) {
        AuxConfigHandler.postInit(IAuxConfig.Sidedness.SERVER);
    }

    private void serverStopping(ServerStoppingEvent event) {
        AmadronOfferManager.getInstance().saveAll();
        AuxConfigHandler.clearPerWorldConfigs();
    }
}

