/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidIngredient
extends Ingredient {
    private List<FluidEntry> fluids;
    private ItemStack[] cachedStacks;
    private final Value[] fluidValues;
    public static final Codec<FluidIngredient> FLUID_CODEC = FluidIngredient.codec(true);
    public static final Codec<FluidIngredient> FLUID_CODEC_NON_EMPTY = FluidIngredient.codec(false);
    public static final FluidIngredient EMPTY = FluidIngredient.empty();

    private static FluidIngredient empty() {
        FluidIngredient ingr = new FluidIngredient(new Value[0]);
        ingr.fluids = List.of();
        ingr.cachedStacks = new ItemStack[0];
        return ingr;
    }

    private FluidIngredient(Value[] fluidValues) {
        super(Stream.empty(), PneumaticRegistry.getInstance().getCustomIngredientTypes().fluidType());
        this.fluidValues = fluidValues;
    }

    private FluidIngredient(Stream<Value> fluidValues) {
        this((Value[])fluidValues.toArray(Value[]::new));
    }

    public static FluidIngredient of(int amount, Fluid ... fluids) {
        return new FluidIngredient(Arrays.stream(fluids).map(f -> new FluidValue(new FluidStack(f, amount), true)));
    }

    public static FluidIngredient of(int amount, TagKey<Fluid> tag) {
        return new FluidIngredient(Stream.of(new FluidTagValue(tag, amount, true)));
    }

    public static FluidIngredient ofFluidStream(Stream<FluidIngredient> fluidIngredientStream) {
        return new FluidIngredient(fluidIngredientStream.flatMap(fluidIngredient -> Arrays.stream(fluidIngredient.fluidValues)));
    }

    protected List<FluidEntry> getFluidEntryList() {
        if (this.fluids == null) {
            this.fluids = Arrays.stream(this.fluidValues).flatMap(val -> val.getFluids().stream()).distinct().toList();
        }
        return this.fluids;
    }

    public void fluidToNetwork(FriendlyByteBuf buf) {
        buf.writeInt(this.getAmount());
        buf.writeCollection(this.getFluidStacks().stream().map(stack -> BuiltInRegistries.FLUID.getId((Object)stack.getFluid())).toList(), FriendlyByteBuf::writeInt);
    }

    public static FluidIngredient fluidFromNetwork(FriendlyByteBuf buf) {
        int amount = buf.readInt();
        Fluid[] fluids = (Fluid[])buf.readList(FriendlyByteBuf::readInt).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).byId(arg_0)).toArray(Fluid[]::new);
        return FluidIngredient.of(amount, fluids);
    }

    public boolean isEmpty() {
        return this.getFluidEntryList().isEmpty() || this.getFluidEntryList().stream().allMatch(entry -> entry.fluidStack.isEmpty() || entry.fluidStack.getFluid() == Fluids.EMPTY);
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.hasCraftingRemainingItem() && FluidUtil.getFluidContained((ItemStack)stack).map(this::testFluid).orElse(false) != false;
    }

    public ItemStack[] getItems() {
        if (this.cachedStacks == null) {
            ArrayList<ItemStack> tankList = new ArrayList<ItemStack>();
            for (FluidEntry entry : this.getFluidEntryList()) {
                FluidStack fluidStack = new FluidStack(entry.fluidStack(), 1000);
                ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)fluidStack);
                if (!bucket.isEmpty()) {
                    tankList.add(bucket);
                }
                Stream.of("small", "medium", "large", "huge").map(tankName -> (Block)BuiltInRegistries.BLOCK.get(PneumaticRegistry.RL(tankName + "_tank"))).filter(tankBlock -> tankBlock != Blocks.AIR).forEach(tankBlock -> this.maybeAddTank((List<ItemStack>)tankList, (Block)tankBlock, fluidStack));
            }
            this.cachedStacks = tankList.toArray(new ItemStack[0]);
        }
        return this.cachedStacks;
    }

    private void maybeAddTank(List<ItemStack> l, Block tankBlock, FluidStack stack) {
        ItemStack tank = new ItemStack((ItemLike)tankBlock);
        IFluidHandlerItem handler = (IFluidHandlerItem)tank.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler != null) {
            handler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            l.add(handler.getContainer());
        }
    }

    public boolean testFluid(FluidStack toMatch) {
        return this.getFluidEntryList().stream().anyMatch(entry -> toMatch.getFluid() == entry.fluidStack().getFluid() && toMatch.getAmount() >= entry.fluidStack().getAmount() && this.matchNBT(toMatch, entry.fluidStack, entry.strictNbt));
    }

    public boolean testFluid(Fluid fluid) {
        return fluid == Fluids.EMPTY ? this.getFluidEntryList().isEmpty() : this.getFluidEntryList().stream().anyMatch(entry -> entry.fluidStack().getFluid() == fluid);
    }

    private boolean matchNBT(FluidStack toTest, FluidStack stack, boolean strictNbt) {
        if (!toTest.hasTag()) {
            return !strictNbt || !stack.hasTag();
        }
        if (strictNbt) {
            return NbtUtils.compareNbt((Tag)stack.getTag(), (Tag)toTest.getTag(), (boolean)true);
        }
        CompoundTag nbt = stack.getTag();
        return nbt != null && nbt.getAllKeys().stream().allMatch(key -> NbtUtils.compareNbt((Tag)nbt.get(key), (Tag)toTest.getTag().get(key), (boolean)true));
    }

    public int getAmount() {
        return this.getFluidEntryList().isEmpty() ? 0 : this.getFluidEntryList().get(0).fluidStack().getAmount();
    }

    public List<FluidStack> getFluidStacks() {
        return this.getFluidEntryList().stream().map(entry -> new FluidStack(entry.fluidStack(), this.getAmount())).toList();
    }

    private static Codec<FluidIngredient> codec(boolean allowEmpty) {
        Codec codec = Codec.list(Value.CODEC).comapFlatMap(values -> !allowEmpty && values.isEmpty() ? DataResult.error(() -> "Fluid array cannot be empty, at least one fluid must be defined") : DataResult.success((Object)values.toArray(new Value[0])), List::of);
        return ExtraCodecs.either((Codec)codec, Value.CODEC).flatComapMap(either -> (FluidIngredient)((Object)((Object)either.map(FluidIngredient::new, fluidValue -> new FluidIngredient(new Value[]{fluidValue})))), fluidIngredient -> {
            if (fluidIngredient.fluidValues.length == 1) {
                return DataResult.success((Object)Either.right((Object)fluidIngredient.fluidValues[0]));
            }
            return fluidIngredient.fluidValues.length == 0 && !allowEmpty ? DataResult.error(() -> "Fluid array cannot be empty, at least one fluid must be defined") : DataResult.success((Object)Either.left((Object)fluidIngredient.fluidValues));
        });
    }

    public static interface Value {
        public static final Codec<Value> CODEC = ExtraCodecs.xor(FluidValue.CODEC, FluidTagValue.CODEC).xmap(either -> (Value)either.map(fluidValue -> fluidValue, fluidTagValue -> fluidTagValue), value -> {
            if (value instanceof FluidTagValue) {
                FluidTagValue fluidTagValue = (FluidTagValue)value;
                return Either.right((Object)fluidTagValue);
            }
            if (value instanceof FluidValue) {
                FluidValue fluidValue = (FluidValue)value;
                return Either.left((Object)fluidValue);
            }
            throw new UnsupportedOperationException("This is neither an fluid value nor a tag value.");
        });

        public Collection<FluidEntry> getFluids();
    }

    public record FluidTagValue(TagKey<Fluid> tag, int amount, boolean strictNbt) implements Value
    {
        static final Codec<FluidTagValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("tag").forGetter(val -> val.tag), (App)Codec.INT.optionalFieldOf("amount", (Object)1000).forGetter(val -> val.amount), (App)Codec.BOOL.optionalFieldOf("strict", (Object)true).forGetter(FluidTagValue::strictNbt)).apply((Applicative)instance, FluidTagValue::new));

        @Override
        public Collection<FluidEntry> getFluids() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.FLUID.getTagOrEmpty(this.tag)) {
                list.add(new FluidEntry(new FluidStack(holder, this.amount), this.strictNbt));
            }
            if (list.isEmpty()) {
                list.add(new FluidEntry(new FluidStack(Fluids.EMPTY, 0), true));
            }
            return list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof FluidTagValue)) return false;
            FluidTagValue tagValue = (FluidTagValue)o;
            if (!tagValue.tag.location().equals((Object)this.tag.location())) return false;
            return true;
        }
    }

    public record FluidEntry(FluidStack fluidStack, boolean strictNbt) {
    }

    public record FluidValue(FluidStack fluidStack, BiFunction<FluidStack, FluidStack, Boolean> comparator, boolean strictNbt) implements Value
    {
        static final Codec<FluidValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(FluidValue::fluidStack), (App)Codec.BOOL.optionalFieldOf("strict", (Object)true).forGetter(FluidValue::strictNbt)).apply((Applicative)instance, FluidValue::new));

        public FluidValue(FluidStack fluidStack, boolean strictNbt) {
            this(fluidStack, (f1, f2) -> f1.isFluidEqual(f2) && f1.getAmount() == f2.getAmount(), strictNbt);
        }

        @Override
        public Collection<FluidEntry> getFluids() {
            return List.of(new FluidEntry(this.fluidStack, this.strictNbt));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof FluidValue)) return false;
            FluidValue val = (FluidValue)o;
            if (this.comparator().apply(this.fluidStack, val.fluidStack) == false) return false;
            return true;
        }
    }
}

