/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class StackedIngredient
extends Ingredient {
    public static final StackedIngredient EMPTY = new StackedIngredient(new Value[0]);
    public static final Codec<StackedIngredient> CODEC = StackedIngredient.codec(true);
    public static final Codec<StackedIngredient> CODEC_NONEMPTY = StackedIngredient.codec(false);
    public final Value[] stackedValues;
    @Nullable
    private ItemStack[] itemStacks;

    private StackedIngredient(Stream<? extends Value> values) {
        this(values, PneumaticRegistry.getInstance().getCustomIngredientTypes().stackedItemType());
    }

    private StackedIngredient(Value[] values) {
        this(values, PneumaticRegistry.getInstance().getCustomIngredientTypes().stackedItemType());
    }

    protected StackedIngredient(Stream<? extends Value> values, Supplier<? extends IngredientType<?>> type) {
        super(Stream.of(new Ingredient.Value[0]), type);
        this.stackedValues = (Value[])values.toArray(Value[]::new);
    }

    private StackedIngredient(Value[] values, Supplier<? extends IngredientType<?>> type) {
        super(Stream.of(values), type);
        this.stackedValues = values;
    }

    public static StackedIngredient fromTag(int count, TagKey<Item> tag) {
        return StackedIngredient.fromItemListStream(Stream.of(new StackedTagValue(tag, count)));
    }

    public static StackedIngredient fromStacks(ItemStack ... stacks) {
        return StackedIngredient.fromItemListStream(Arrays.stream(stacks).map(StackedItemValue::new));
    }

    public static StackedIngredient fromItems(int count, ItemLike ... itemsIn) {
        return StackedIngredient.fromItemListStream(Arrays.stream(itemsIn).map(itemProvider -> new StackedItemValue(new ItemStack(itemProvider, count))));
    }

    public static StackedIngredient fromIngredient(int count, Ingredient wrappedIngredient) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        for (ItemStack stack : wrappedIngredient.getItems()) {
            l.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)count));
        }
        return StackedIngredient.fromStacks(l.toArray(new ItemStack[0]));
    }

    private static StackedIngredient fromItemListStream(Stream<? extends Value> stream) {
        StackedIngredient ingredient = new StackedIngredient(stream);
        return ingredient.isEmpty() ? EMPTY : ingredient;
    }

    public boolean test(@Nullable ItemStack checkingStack) {
        if (checkingStack == null || checkingStack.isEmpty()) {
            return super.test(checkingStack);
        }
        return Arrays.stream(this.getItems()).anyMatch(stack -> stack.getItem() == checkingStack.getItem() && stack.getCount() <= checkingStack.getCount());
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.stackedValues).flatMap(value -> value.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    public boolean isEmpty() {
        return this.stackedValues.length == 0 || Arrays.stream(this.getItems()).allMatch(ItemStack::isEmpty);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof StackedIngredient)) return false;
        StackedIngredient ingredient = (StackedIngredient)((Object)o);
        if (!Arrays.equals(this.stackedValues, ingredient.stackedValues)) return false;
        return true;
    }

    public static StackedIngredient fromNetwork(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        if (size == -1) {
            return (StackedIngredient)((Object)buf.readWithCodecTrusted((DynamicOps)NbtOps.INSTANCE, CODEC));
        }
        return new StackedIngredient(Stream.generate(() -> new StackedItemValue(buf.readItem())).limit(size));
    }

    private static Codec<StackedIngredient> codec(boolean allowEmpty) {
        Codec codec = Codec.list(Value.CODEC).comapFlatMap(values -> !allowEmpty && values.isEmpty() ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)values.toArray(new Value[0])), List::of);
        return ExtraCodecs.either((Codec)codec, Value.CODEC).flatComapMap(either -> (StackedIngredient)((Object)((Object)either.map(StackedIngredient::new, value -> new StackedIngredient(new Value[]{value})))), ingredient -> {
            if (ingredient.stackedValues.length == 1) {
                return DataResult.success((Object)Either.right((Object)ingredient.stackedValues[0]));
            }
            return ingredient.stackedValues.length == 0 && !allowEmpty ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)Either.left((Object)ingredient.stackedValues));
        });
    }

    public static interface Value
    extends Ingredient.Value {
        public static final Codec<Value> CODEC = ExtraCodecs.xor(StackedItemValue.CODEC, StackedTagValue.CODEC).xmap(either -> (Value)either.map(itemValue -> itemValue, tagValue -> tagValue), val -> {
            if (val instanceof StackedTagValue) {
                StackedTagValue tagValue = (StackedTagValue)val;
                return Either.right((Object)tagValue);
            }
            if (val instanceof StackedItemValue) {
                StackedItemValue itemValue = (StackedItemValue)val;
                return Either.left((Object)itemValue);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });
    }

    public static class StackedTagValue
    implements Value {
        static final Codec<StackedTagValue> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(val -> val.tagKey), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("count").forGetter(val -> val.count)).apply((Applicative)builder, StackedTagValue::new));
        private final TagKey<Item> tagKey;
        private final int count;

        public StackedTagValue(TagKey<Item> tagIn, int count) {
            this.tagKey = tagIn;
            this.count = count;
        }

        public Collection<ItemStack> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.tagKey)) {
                list.add(new ItemStack(holder, this.count));
            }
            if (list.isEmpty()) {
                list.add(new ItemStack((ItemLike)Blocks.BARRIER).setHoverName((Component)Component.literal((String)("Empty Tag: " + this.tagKey.location()))));
            }
            return list;
        }
    }

    public record StackedItemValue(ItemStack itemStack, BiFunction<ItemStack, ItemStack, Boolean> comparator) implements Value
    {
        static final Codec<StackedItemValue> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("item").forGetter(val -> val.itemStack)).apply((Applicative)builder, StackedItemValue::new));

        public StackedItemValue(ItemStack itemStack) {
            this(itemStack, StackedItemValue::areStacksEqual);
        }

        private static boolean areStacksEqual(ItemStack left, ItemStack right) {
            return left.getItem().equals(right.getItem()) && left.getCount() == right.getCount();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof StackedItemValue)) return false;
            StackedItemValue s = (StackedItemValue)o;
            if (this.comparator.apply(s.itemStack, this.itemStack) == false) return false;
            return true;
        }

        public Collection<ItemStack> getItems() {
            return Collections.singletonList(this.itemStack);
        }
    }
}

