/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.recipe;

import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class ThermoPlantRecipe
extends PneumaticCraftRecipe {
    public abstract boolean matches(FluidStack var1, ItemStack var2);

    public abstract TemperatureRange getOperatingTemperature();

    public abstract float getRequiredPressure();

    public double heatUsed(double ambientTemperature) {
        TemperatureRange range = this.getOperatingTemperature();
        if (range.isAny()) {
            return 0.0;
        }
        double used = (double)range.getMin() > ambientTemperature ? ((double)range.getMin() - ambientTemperature) / 10.0 : ((double)range.getMax() < ambientTemperature ? (ambientTemperature - (double)range.getMax()) / 10.0 : (this.isExothermic() ? ((double)range.getMax() - ambientTemperature) / 10.0 : (ambientTemperature - (double)range.getMin()) / 10.0));
        return this.isExothermic() ? -used : used;
    }

    public int airUsed() {
        return (int)(50.0f * this.getRequiredPressure());
    }

    public abstract Optional<Ingredient> getInputItem();

    public abstract Optional<FluidIngredient> getInputFluid();

    public abstract FluidStack getOutputFluid();

    public abstract ItemStack getOutputItem();

    public abstract float getRecipeSpeed();

    public abstract float getAirUseMultiplier();

    public abstract boolean isExothermic();

    public final int getInputFluidAmount() {
        return this.getInputFluid().map(FluidIngredient::getAmount).orElse(0);
    }

    public final boolean testFluid(FluidStack fluid) {
        return this.getInputFluid().map(i -> i.testFluid(fluid)).orElse(false);
    }

    public final boolean testItem(ItemStack stack) {
        return this.getInputItem().map(i -> i.test(stack)).orElse(false);
    }
}

