/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.semiblock;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.EntityCapability;

public interface ISemiBlock {
    public ResourceLocation getSemiblockId();

    public Component getSemiblockDisplayName();

    public Level getWorld();

    public BlockPos getBlockPos();

    public BlockEntity getCachedTileEntity();

    public CompoundTag serializeNBT(CompoundTag var1);

    public void tick();

    public boolean isValid();

    public NonNullList<ItemStack> getDrops();

    public boolean canPlace(Direction var1);

    default public void onPlaced(Player player, ItemStack stack, Direction facing) {
    }

    default public boolean onRightClickWithConfigurator(Player player, Direction side) {
        return false;
    }

    public boolean canCoexist(ISemiBlock var1);

    public int getTrackingId();

    public void killedByEntity(Entity var1);

    default public void addTooltip(Consumer<Component> consumer, Player player, CompoundTag tag, boolean extended) {
    }

    public void writeToBuf(FriendlyByteBuf var1);

    public void readFromBuf(FriendlyByteBuf var1);

    default public int getColor() {
        return -8355712;
    }

    public <T> Optional<T> getSemiblockCapability(EntityCapability<T, Direction> var1, Direction var2);

    public <T> Optional<T> getSemiblockCapability(EntityCapability<T, Void> var1);

    public static ISemiBlock byTrackingId(Level world, int id) {
        Entity e = world.getEntity(id);
        return e instanceof ISemiBlock ? (ISemiBlock)e : null;
    }
}

