/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.model.CamoModel;
import me.desht.pneumaticcraft.client.model.custom.CamouflageModel;
import me.desht.pneumaticcraft.client.model.custom.FluidItemModel;
import me.desht.pneumaticcraft.client.model.custom.RenderedItemModel;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.registries.DeferredHolder;

@Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModClientEventHandler {
    @SubscribeEvent
    public static void onModelBaking(ModelEvent.ModifyBakingResult event) {
        for (DeferredHolder block : ModBlocks.BLOCKS.getEntries()) {
            if (!(block.get() instanceof AbstractCamouflageBlock)) continue;
            for (BlockState state : ((Block)block.get()).getStateDefinition().getPossibleStates()) {
                ModelResourceLocation loc = BlockModelShaper.stateToModelLocation((BlockState)state);
                BakedModel model = (BakedModel)event.getModels().get(loc);
                if (model == null) continue;
                event.getModels().put(loc, new CamoModel(model));
            }
        }
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelEvent.RegisterGeometryLoaders event) {
        event.register(PneumaticRegistry.RL("camouflaged"), (IGeometryLoader)CamouflageModel.Loader.INSTANCE);
        event.register(PneumaticRegistry.RL("fluid_container_item"), (IGeometryLoader)FluidItemModel.Loader.INSTANCE);
        event.register(PneumaticRegistry.RL("rendered_item"), (IGeometryLoader)RenderedItemModel.Loader.INSTANCE);
    }
}

