/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.IGuiDrone;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.FluidUtil;

@Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipEventHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof BucketItem) {
            TooltipEventHandler.handleFluidContainerTooltip(event);
        } else if (PneumaticCraftUtils.getRegistryName(stack.getItem()).orElseThrow().getNamespace().equals("pneumaticcraft")) {
            TooltipEventHandler.addStandardTooltip(stack, event.getToolTip(), event.getFlags());
        }
        if (stack.getItem() instanceof IProgrammable) {
            TooltipEventHandler.handleProgrammableTooltip(event);
        }
    }

    private static void addStandardTooltip(ItemStack stack, List<Component> curInfo, TooltipFlag flagIn) {
        String key;
        TooltipEventHandler.addPressureTooltip(stack, curInfo);
        UpgradableItemUtils.addUpgradeInformation(stack, curInfo, flagIn);
        Item item = stack.getItem();
        if (item instanceof IInventoryItem) {
            IInventoryItem item2 = (IInventoryItem)item;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            item2.getStacksInItem(stack, stacks);
            if (item2.getInventoryHeader() != null && !stacks.isEmpty()) {
                curInfo.add(item2.getInventoryHeader());
            }
            PneumaticCraftUtils.summariseItemStacks(curInfo, stacks, Component.literal((String)item2.getTooltipPrefix(stack)));
        }
        if (I18n.exists((String)(key = ICustomTooltipName.getTranslationKey(stack, true)))) {
            if (ClientUtils.hasShiftDown()) {
                String translatedInfo = ChatFormatting.AQUA + I18n.get((String)key, (Object[])new Object[0]);
                curInfo.addAll(PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(translatedInfo)));
                if (!ThirdPartyManager.instance().getDocsProvider().isInstalled()) {
                    curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.installDocsProvider", new Object[0]));
                }
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.sneakForInfo", new Object[0]).withStyle(ChatFormatting.AQUA));
            }
        }
    }

    private static void addPressureTooltip(ItemStack stack, List<Component> textList) {
        PNCCapabilities.getAirHandler(stack).ifPresent(airHandler -> {
            float f = airHandler.getPressure() / airHandler.maxPressure();
            ChatFormatting color = f < 0.1f ? ChatFormatting.RED : (f < 0.5f ? ChatFormatting.GOLD : ChatFormatting.DARK_GREEN);
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 1)).withStyle(color));
        });
    }

    private static void handleProgrammableTooltip(ItemTooltipEvent event) {
        IProgrammable programmable = (IProgrammable)event.getItemStack().getItem();
        if (programmable.canProgram(event.getItemStack()) && programmable.showProgramTooltip()) {
            boolean hasInvalidPrograms = false;
            ArrayList<Object> addedEntries = new ArrayList<Object>();
            List<IProgWidget> widgets = ProgrammerBlockEntity.getProgWidgets(event.getItemStack());
            Map<ResourceLocation, Integer> widgetMap = TooltipEventHandler.getPuzzleSummary(widgets);
            for (Map.Entry<ResourceLocation, Integer> entry : widgetMap.entrySet()) {
                ChatFormatting[] prefix = new ChatFormatting[]{};
                ProgWidgetType widgetType = (ProgWidgetType)ModProgWidgets.PROG_WIDGETS_REGISTRY.get(entry.getKey());
                if (widgetType == null) continue;
                Screen curScreen = Minecraft.getInstance().screen;
                if (curScreen instanceof IGuiDrone && !((IGuiDrone)curScreen).getDrone().isProgramApplicable(widgetType)) {
                    prefix = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC};
                    hasInvalidPrograms = true;
                }
                addedEntries.add(Component.literal((String)("\u2022 " + entry.getValue() + " x ")).append((Component)PneumaticCraftUtils.xlate(widgetType.getTranslationKey(), new Object[0])).withStyle(prefix));
            }
            if (hasInvalidPrograms) {
                event.getToolTip().add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.invalidPieces", new Object[0]).withStyle(ChatFormatting.RED));
            }
            addedEntries.sort(Comparator.comparing(Component::getString));
            event.getToolTip().addAll(addedEntries);
            if (ClientUtils.hasShiftDown() && !widgets.isEmpty()) {
                event.getToolTip().add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.requiredPieces", widgets.size()).withStyle(ChatFormatting.GREEN));
            }
        }
    }

    private static void handleFluidContainerTooltip(ItemTooltipEvent event) {
        FluidUtil.getFluidContained((ItemStack)event.getItemStack()).ifPresent(fluidStack -> {
            String key = ICustomTooltipName.getTranslationKey(event.getItemStack(), true);
            if (I18n.exists((String)key)) {
                if (Screen.hasShiftDown()) {
                    String translatedInfo = ChatFormatting.AQUA + I18n.get((String)key, (Object[])new Object[0]);
                    event.getToolTip().addAll(PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(translatedInfo)));
                } else {
                    event.getToolTip().add(PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.sneakForInfo", new Object[0]).withStyle(ChatFormatting.AQUA));
                }
            }
        });
    }

    private static Map<ResourceLocation, Integer> getPuzzleSummary(List<IProgWidget> widgets) {
        HashMap<ResourceLocation, Integer> map = new HashMap<ResourceLocation, Integer>();
        for (IProgWidget widget : widgets) {
            map.put(widget.getTypeID(), map.getOrDefault(widget.getTypeID(), 0) + 1);
        }
        return map;
    }

    @SubscribeEvent
    public static void gatherComponents(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof MicromissilesItem && stack.hasTag() && MicromissilesItem.getFireMode(stack) == MicromissilesItem.FireMode.SMART) {
            event.getTooltipElements().add(Either.right((Object)new MicromissilesItem.Tooltip(stack)));
        }
    }
}

