/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractCreativeAdjusterScreen<C extends AbstractPneumaticCraftMenu<T>, T extends AbstractPneumaticCraftBlockEntity>
extends AbstractPneumaticCraftContainerScreen<C, T> {
    private WidgetButtonExtended down2;
    private WidgetButtonExtended down1;
    private WidgetButtonExtended up1;
    private WidgetButtonExtended up2;

    public AbstractCreativeAdjusterScreen(C container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        int y = this.height / 2 - 5;
        int x = this.width / 2;
        float small = this.getAdjustments().small();
        float big = this.getAdjustments().big();
        this.down2 = (WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(x - 90, y, 30, 20, "").withTag(() -> this.makeTag(-big)));
        this.down1 = (WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(x - 58, y, 30, 20, "").withTag(() -> this.makeTag(-small)));
        this.up1 = (WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(x + 28, y, 30, 20, "").withTag(() -> this.makeTag(small)));
        this.up2 = (WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(x + 60, y, 30, 20, "").withTag(() -> this.makeTag(big)));
    }

    @Override
    public void containerTick() {
        super.containerTick();
        float small = this.getAdjustments().small();
        float small2 = small * this.getShiftMultiplier();
        float big = this.getAdjustments().big();
        float big2 = big * this.getShiftMultiplier();
        this.setText(this.down2, this.formatAdjustment(-big), this.formatAdjustment(-big2));
        this.setText(this.down1, this.formatAdjustment(-small), this.formatAdjustment(-small2));
        this.setText(this.up1, this.formatAdjustment(small), this.formatAdjustment(small2));
        this.setText(this.up2, this.formatAdjustment(big), this.formatAdjustment(big2));
    }

    protected abstract float getShiftMultiplier();

    protected abstract Component formatStringDesc();

    protected abstract Adjustments getAdjustments();

    @Override
    protected PointXY getGaugeLocation() {
        return null;
    }

    @Override
    protected boolean shouldAddPressureTab() {
        return false;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        graphics.drawCenteredString(this.font, this.formatStringDesc(), this.width / 2 - this.leftPos, this.height / 2 - this.topPos, 0xFFFFFF);
        graphics.drawCenteredString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.holdShiftFastAdjust", new Object[0]), this.width / 2 - this.leftPos, this.height / 2 - this.topPos + 20, 0x808080);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return null;
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    @Override
    protected int getTitleColor() {
        return 0xFF00FF;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    private void setText(WidgetButtonExtended b, String unshifted, String shifted) {
        b.setMessage((Component)Component.literal((String)(ClientUtils.hasShiftDown() ? shifted : unshifted)));
    }

    protected String formatAdjustment(float adj) {
        return String.format("%+.1f", Float.valueOf(adj));
    }

    private String makeTag(float f) {
        return this.formatAdjustment(AbstractCreativeAdjusterScreen.hasShiftDown() ? f * this.getShiftMultiplier() : f);
    }

    record Adjustments(float small, float big) {
    }
}

