/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAmadronOffer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderUpdate;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AmadronScreen
extends AbstractPneumaticCraftContainerScreen<AmadronMenu, AbstractPneumaticCraftBlockEntity> {
    private static final int ROWS = 4;
    public static final int OFFERS_PER_PAGE = 8;
    private WidgetTextField searchBar;
    private WidgetVerticalScrollbar scrollbar;
    private WidgetLabel pageLabel;
    private int page = 0;
    private final List<WidgetAmadronOfferAdjustable> offerWidgets = new ArrayList<WidgetAmadronOfferAdjustable>();
    private boolean needsRefreshing;
    private boolean hadProblem = false;
    private WidgetButtonExtended orderButton;
    private WidgetButtonExtended addTradeButton;
    private WidgetAnimatedStat customTradesTab;
    private boolean needTooltipUpdate = true;
    private int problemTimer = 0;

    public AmadronScreen(AmadronMenu container, Inventory inv, Component displayString) {
        super(container, inv, (Component)Component.literal((String)""));
        this.imageWidth = 176;
        this.imageHeight = 202;
    }

    @Override
    public void init() {
        super.init();
        MutableComponent amadron = PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.title", new Object[0]);
        this.addLabel((Component)amadron, this.leftPos + this.imageWidth / 2 - this.font.width((FormattedText)amadron) / 2, this.topPos + 5, 0xFFFFFF).setDropShadow(true);
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.search", new Object[0]), this.leftPos + 76 - this.font.width(I18n.get((String)"pneumaticcraft.gui.search", (Object[])new Object[0])), this.topPos + 41, 0xFFFFFF);
        this.addInfoTab((Component)PneumaticCraftUtils.xlate("gui.tooltip.item.pneumaticcraft.amadron_tablet", new Object[0]));
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.ghostSlotInteraction.title", new Object[0]), Textures.GUI_MOUSE_LOCATION, -16733441, true).setText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.ghostSlotInteraction", new Object[0]));
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.disclaimer.title", new Object[0]), new ItemStack((ItemLike)Items.WRITABLE_BOOK), -16776961, true).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.disclaimer", new Object[0]));
        this.customTradesTab = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.customTrades", new Object[0]), new ItemStack((ItemLike)Items.DIAMOND), -3117056, false);
        this.customTradesTab.setMinimumExpandedDimensions(80, 50);
        Objects.requireNonNull(this.font);
        this.searchBar = new WidgetTextField(this.font, this.leftPos + 79, this.topPos + 39, 73, 9 + 3);
        this.searchBar.setResponder(s -> this.sendDelayed(8));
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        this.setFocused((GuiEventListener)this.searchBar);
        this.scrollbar = new WidgetVerticalScrollbar(this.leftPos + 156, this.topPos + 54, 142).setStates(1).setListening(true);
        this.addRenderableWidget((GuiEventListener)this.scrollbar);
        this.orderButton = new WidgetButtonExtended(this.leftPos + 52, this.topPos + 16, 72, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.order", new Object[0])).withTag("order");
        this.addRenderableWidget((GuiEventListener)this.orderButton);
        this.updateOrderButtonTooltip();
        this.addTradeButton = new WidgetButtonExtended(16, 26, 20, 20).withTag("addPlayerTrade").setRenderStacks(new ItemStack((ItemLike)Items.EMERALD));
        this.addTradeButton.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade", new Object[0]).append("\n").append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade.tooltip", new Object[0]))));
        this.customTradesTab.addSubWidget((AbstractWidget)this.addTradeButton);
        this.pageLabel = new WidgetLabel(this.leftPos + 158, this.topPos + 49, (Component)Component.literal((String)""));
        this.addRenderableWidget((GuiEventListener)this.pageLabel);
        this.pageLabel.setScale(0.5f);
        this.pageLabel.setColor(-2039584);
        this.needsRefreshing = true;
    }

    public static void basketUpdated() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AmadronScreen) {
            AmadronScreen g = (AmadronScreen)screen;
            g.needTooltipUpdate = true;
        }
    }

    @Override
    protected void doDelayedAction() {
        this.needsRefreshing = true;
        this.scrollbar.setCurrentState(0);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        return this.scrollbar.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    protected OptionalInt getBackgroundTint() {
        return OptionalInt.of(-16347604);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AMADRON;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (this.needsRefreshing || this.page != this.scrollbar.getState()) {
            this.setPage(this.scrollbar.getState());
        }
        for (WidgetAmadronOfferAdjustable offerWidget : this.offerWidgets) {
            offerWidget.setAffordable(((AmadronMenu)this.menu).affordableOffers[offerWidget.index]);
            offerWidget.setShoppingAmount(((AmadronMenu)this.menu).getShoppingBasketUnits(offerWidget.getOffer().getOfferId()));
        }
        if (!this.hadProblem && ((AmadronMenu)this.menu).problemState != AmadronMenu.EnumProblemState.NO_PROBLEMS) {
            this.problemTab.openStat();
        }
        this.hadProblem = ((AmadronMenu)this.menu).problemState != AmadronMenu.EnumProblemState.NO_PROBLEMS;
        this.addTradeButton.active = ((AmadronMenu)this.menu).currentPlayerOffers < ((AmadronMenu)this.menu).maxPlayerOffers;
        MutableComponent text = PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade.tooltip.offerCount", ((AmadronMenu)this.menu).currentPlayerOffers, ((AmadronMenu)this.menu).maxPlayerOffers == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(((AmadronMenu)this.menu).maxPlayerOffers));
        this.customTradesTab.setText((Component)text);
        boolean bl = this.orderButton.active = !((AmadronMenu)this.menu).isBasketEmpty() && ((AmadronMenu)this.menu).problemState == AmadronMenu.EnumProblemState.NO_PROBLEMS;
        if (this.needTooltipUpdate) {
            this.updateOrderButtonTooltip();
            this.needTooltipUpdate = false;
        }
        if (this.problemTimer == 0 && ((AmadronMenu)this.menu).problemState != AmadronMenu.EnumProblemState.NO_PROBLEMS) {
            this.problemTimer = 70;
        } else if (this.problemTimer > 0 && --this.problemTimer <= 0) {
            ((AmadronMenu)this.menu).problemState = AmadronMenu.EnumProblemState.NO_PROBLEMS;
        }
    }

    private void updateOrderButtonTooltip() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.order.tooltip", new Object[0]));
        if (!((AmadronMenu)this.menu).isBasketEmpty()) {
            builder.add((Object)Component.empty());
            builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.basket", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE}));
            for (AmadronOffer offer : AmadronOfferManager.getInstance().getActiveOffers()) {
                int nOrders = ((AmadronMenu)this.menu).getShoppingBasketUnits(offer.getOfferId());
                if (nOrders <= 0) continue;
                String in = offer.getInput().getAmount() * nOrders + " x " + offer.getInput().getName();
                String out = offer.getOutput().getAmount() * nOrders + " x " + offer.getOutput().getName();
                builder.add((Object)Component.literal((String)("\u2022 " + ChatFormatting.YELLOW + out)));
                builder.add((Object)Component.literal((String)(ChatFormatting.GOLD + "   for " + ChatFormatting.YELLOW + in)));
            }
        }
        Component c = PneumaticCraftUtils.combineComponents((List<Component>)builder.build());
        this.orderButton.setTooltip(Tooltip.create((Component)c));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.searchBar.isMouseOver(mouseX, mouseY)) {
            this.searchBar.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return this.searchBar.keyPressed(keyCode, scanCode, modifiers) || this.searchBar.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void setPage(int page) {
        this.page = page;
        this.updateVisibleOffers();
        int nPages = (((AmadronMenu)this.menu).activeOffers.size() - 1) / 8 + 1;
        this.pageLabel.setMessage((Component)Component.literal((String)(page + 1 + "/" + nPages)));
    }

    private void updateVisibleOffers() {
        AmadronOffer offer;
        int i;
        this.needsRefreshing = false;
        ArrayList<AmadronOffer> visibleOffers = new ArrayList<AmadronOffer>();
        int skippedOffers = 0;
        int applicableOffers = 0;
        for (i = 0; i < ((AmadronMenu)this.menu).activeOffers.size(); ++i) {
            offer = ((AmadronMenu)this.menu).activeOffers.get(i);
            if (!offer.passesQuery(this.searchBar.getValue())) continue;
            ++applicableOffers;
            if (skippedOffers < this.page * 8) {
                ++skippedOffers;
                continue;
            }
            if (visibleOffers.size() >= 8) continue;
            visibleOffers.add(offer);
        }
        this.scrollbar.setStates(Math.max(1, (applicableOffers + 8 - 1) / 8 - 1));
        this.offerWidgets.forEach(this::removeWidget);
        this.offerWidgets.clear();
        for (i = 0; i < visibleOffers.size(); ++i) {
            offer = (AmadronOffer)visibleOffers.get(i);
            int idx = ((AmadronMenu)this.menu).activeOffers.indexOf(offer);
            if (idx < 0) continue;
            WidgetAmadronOfferAdjustable widget = new WidgetAmadronOfferAdjustable(this.leftPos + 6 + 73 * (i % 2), this.topPos + 55 + 35 * (i / 2), offer, idx);
            this.addRenderableWidget((GuiEventListener)widget);
            this.offerWidgets.add(widget);
        }
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((AmadronMenu)this.menu).problemState != AmadronMenu.EnumProblemState.NO_PROBLEMS) {
            curInfo.addAll(GuiUtils.xlateAndSplit(((AmadronMenu)this.menu).problemState.getTranslationKey(), new Object[0]));
        }
    }

    @Override
    public void onGuiUpdate() {
        this.needTooltipUpdate = true;
    }

    static class WidgetAmadronOfferAdjustable
    extends WidgetAmadronOffer {
        private final int index;

        WidgetAmadronOfferAdjustable(int x, int y, AmadronOffer offer, int index) {
            super(x, y, offer);
            this.index = index;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
                return true;
            }
            if (this.clicked(mouseX, mouseY) && this.getOffer().isUsableByPlayer(ClientUtils.getClientPlayer())) {
                NetworkHandler.sendToServer(new PacketAmadronOrderUpdate(this.getOffer().getOfferId(), mouseButton, Screen.hasShiftDown()));
                return true;
            }
            return false;
        }
    }
}

