/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.ChargingStationMenu;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class ChargingStationScreen
extends AbstractPneumaticCraftContainerScreen<ChargingStationMenu, ChargingStationBlockEntity> {
    private static final int PARTICLE_COUNT = 10;
    private WidgetButtonExtended guiSelectButton;
    private WidgetButtonExtended upgradeOnlyButton;
    private float renderAirProgress;
    private static final Component UPGRADE_ONLY_ON = Component.literal((String)"\u2b06").withStyle(ChatFormatting.AQUA);
    private static final Component UPGRADE_ONLY_OFF = Component.literal((String)"\u2b06").withStyle(ChatFormatting.GRAY);

    public ChargingStationScreen(ChargingStationMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 182;
    }

    @Override
    public void init() {
        super.init();
        this.guiSelectButton = new WidgetButtonExtended(this.leftPos + 90, this.topPos + 22, 18, 19, (Component)Component.empty()).withTag("open_upgrades");
        this.guiSelectButton.setRenderedIcon(Textures.GUI_UPGRADES_LOCATION);
        this.guiSelectButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.guiSelectButton);
        this.upgradeOnlyButton = new WidgetButtonExtended(this.leftPos + 129, this.topPos + 80, 14, 14, "U").withTag("toggle_upgrade_only");
        this.addRenderableWidget((GuiEventListener)this.upgradeOnlyButton);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_CHARGING_STATION;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.renderBg(graphics, partialTicks, x, y);
        if (((ChargingStationBlockEntity)this.te).upgradeOnly) {
            graphics.blit(this.getGuiTexture(), this.leftPos + 102, this.topPos + 76, 177, 0, 13, 16);
        } else {
            this.renderAir(graphics, partialTicks);
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        ItemStack stack = ((ChargingStationBlockEntity)this.te).getItemHandler().getStackInSlot(0);
        boolean wasVisible = this.guiSelectButton.visible;
        this.guiSelectButton.visible = stack.getItem() instanceof IChargeableContainerProvider;
        if (this.guiSelectButton.visible && !wasVisible) {
            this.guiSelectButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.charging_station.manageUpgrades", stack.getHoverName()));
        }
        if (!((ChargingStationBlockEntity)this.te).upgradeOnly) {
            if (((ChargingStationBlockEntity)this.te).charging) {
                this.renderAirProgress += 0.001f * Math.min(25.0f, ((ChargingStationBlockEntity)this.te).getSpeedMultiplierFromUpgrades());
                if (this.renderAirProgress > 1.0f) {
                    this.renderAirProgress = 0.0f;
                }
            } else if (((ChargingStationBlockEntity)this.te).discharging) {
                this.renderAirProgress -= 0.001f * Math.min(25.0f, ((ChargingStationBlockEntity)this.te).getSpeedMultiplierFromUpgrades());
                if (this.renderAirProgress < 0.0f) {
                    this.renderAirProgress = 1.0f;
                }
            }
        }
        this.upgradeOnlyButton.setMessage(((ChargingStationBlockEntity)this.te).upgradeOnly ? UPGRADE_ONLY_ON : UPGRADE_ONLY_OFF);
    }

    @Override
    protected PointXY getGaugeLocation() {
        return new PointXY(this.leftPos + this.imageWidth * 3 / 4 + 10, this.topPos + this.imageHeight / 4 + 10);
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((ChargingStationBlockEntity)this.te).charging || ((ChargingStationBlockEntity)this.te).discharging) {
            String key = ((ChargingStationBlockEntity)this.te).charging ? "pneumaticcraft.gui.tooltip.charging" : "pneumaticcraft.gui.tooltip.discharging";
            String amount = PneumaticCraftUtils.roundNumberTo(10.0f * ((ChargingStationBlockEntity)this.te).getSpeedMultiplierFromUpgrades(), 1);
            pressureStatText.add((Component)PneumaticCraftUtils.xlate(key, amount).withStyle(ChatFormatting.BLACK));
        } else {
            pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.charging", 0).withStyle(ChatFormatting.BLACK));
        }
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        ItemStack chargeStack = ((ChargingStationBlockEntity)this.te).getItemHandler().getStackInSlot(0);
        if (!chargeStack.isEmpty() && PNCCapabilities.getAirHandler(chargeStack).isEmpty()) {
            textList.add((Component)Component.literal((String)(ChatFormatting.RED + "Non-pneumatic item in the charge slot!?")));
        }
    }

    @Override
    protected void addWarnings(List<Component> curInfo) {
        super.addWarnings(curInfo);
        ItemStack chargeStack = ((ChargingStationBlockEntity)this.te).getItemHandler().getStackInSlot(0);
        if (chargeStack.isEmpty()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.charging_station.no_item", new Object[0]));
        } else if (!((ChargingStationBlockEntity)this.te).upgradeOnly) {
            PNCCapabilities.getAirHandler(chargeStack).ifPresent(h -> {
                String name = chargeStack.getHoverName().getString();
                if (h.getPressure() > ((ChargingStationBlockEntity)this.te).getPressure() + 0.01f && h.getPressure() <= 0.0f) {
                    curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.charging_station.item_empty", name));
                } else if (h.getPressure() < ((ChargingStationBlockEntity)this.te).getPressure() - 0.01f && h.getPressure() >= h.maxPressure()) {
                    curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.charging_station.item_full", name));
                } else if (!((ChargingStationBlockEntity)this.te).charging && !((ChargingStationBlockEntity)this.te).discharging) {
                    curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.charging_station.pressure_equal", name));
                }
            });
        }
    }

    private void renderAir(GuiGraphics graphics, float partialTicks) {
        RenderSystem.lineWidth((float)2.0f);
        for (int i = 0; i < 10; ++i) {
            this.renderAirParticle(graphics, this.renderAirProgress % 0.1f + (float)i / 10.0f);
        }
    }

    private void renderAirParticle(GuiGraphics graphics, float particleProgress) {
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        float x = (float)xStart + 117.0f;
        float y = (float)yStart + 56.5f;
        if (particleProgress < 0.5f) {
            y += particleProgress * 56.0f;
        } else if (particleProgress < 0.7f) {
            y += 28.0f;
            x -= (particleProgress - 0.5f) * 90.0f;
        } else {
            y += 28.0f;
            x -= 18.0f;
            y -= (particleProgress - 0.7f) * 70.0f;
        }
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f posMat = graphics.pose().last().pose();
        bufferbuilder.vertex(posMat, x - 1.0f, y + 1.0f, 0.0f).color(0.7f, 0.8f, 0.9f, 1.0f).endVertex();
        bufferbuilder.vertex(posMat, x + 1.0f, y + 1.0f, 0.0f).color(0.6f, 0.7f, 0.7f, 1.0f).endVertex();
        bufferbuilder.vertex(posMat, x + 1.0f, y - 1.0f, 0.0f).color(0.7f, 0.8f, 0.9f, 1.0f).endVertex();
        bufferbuilder.vertex(posMat, x - 1.0f, y - 1.0f, 0.0f).color(0.8f, 0.9f, 0.9f, 1.0f).endVertex();
        Tesselator.getInstance().end();
    }
}

