/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.Objects;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketChangeGPSToolCoordinate;
import me.desht.pneumaticcraft.common.network.PacketTeleportCommand;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class GPSToolScreen
extends AbstractPneumaticCraftScreen {
    private static final int TEXTFIELD_WIDTH = 60;
    private static final Pattern VAR_PATTERN = Pattern.compile("^\\w*$", 2);
    protected final WidgetTextFieldNumber[] textFields = new WidgetTextFieldNumber[3];
    protected WidgetTextField variableField;
    protected WidgetButtonExtended varTypeButton;
    protected WidgetButtonExtended teleportButton;
    protected final InteractionHand hand;
    private final BlockPos oldGPSLoc;
    private String oldVarName;
    protected boolean playerGlobal;

    protected GPSToolScreen(Component title, InteractionHand hand, BlockPos gpsLoc, String oldVarName) {
        super(title);
        this.xSize = 183;
        this.ySize = 202;
        this.hand = hand;
        this.oldGPSLoc = gpsLoc;
        this.oldVarName = oldVarName;
    }

    public static void showGUI(ItemStack stack, InteractionHand handIn, BlockPos pos) {
        Minecraft.getInstance().setScreen((Screen)new GPSToolScreen(stack.getHoverName(), handIn, pos != null ? pos : BlockPos.ZERO, GPSToolItem.getVariable(stack)));
    }

    @Override
    public void init() {
        int i;
        super.init();
        int[] oldText = new int[3];
        if (this.textFields[0] == null) {
            oldText[0] = this.oldGPSLoc.getX();
            oldText[1] = this.oldGPSLoc.getY();
            oldText[2] = this.oldGPSLoc.getZ();
        } else {
            for (int i2 = 0; i2 < 3; ++i2) {
                oldText[i2] = this.textFields[i2].getIntValue();
            }
        }
        int xMiddle = this.width / 2;
        int yMiddle = this.height / 2;
        for (i = 0; i < 3; ++i) {
            int min = i == 1 ? ClientUtils.getClientLevel().getMinBuildHeight() : Integer.MIN_VALUE;
            int max = i == 1 ? ClientUtils.getClientLevel().getMaxBuildHeight() : Integer.MAX_VALUE;
            Objects.requireNonNull(this.font);
            this.textFields[i] = new WidgetTextFieldNumber(this.font, xMiddle - 30, yMiddle - 15 + i * 22, 60, 9 + 2).setValue(oldText[i]).setRange(min, max).setAdjustments(1.0, 10.0);
            this.addRenderableWidget((GuiEventListener)this.textFields[i]);
        }
        for (i = 0; i < 3; ++i) {
            int idx = i;
            this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(xMiddle - 52 - 30, yMiddle - 20 + i * 22, 25, 20, (Component)Component.literal((String)"-10"), b -> this.updateTextField(idx, -10)));
            this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(xMiddle - 25 - 30, yMiddle - 20 + i * 22, 22, 20, (Component)Component.literal((String)"-1"), b -> this.updateTextField(idx, -1)));
            this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(xMiddle + 3 + 30, yMiddle - 20 + i * 22, 22, 20, (Component)Component.literal((String)"+1"), b -> this.updateTextField(idx, 1)));
            this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(xMiddle + 27 + 30, yMiddle - 20 + i * 22, 25, 20, (Component)Component.literal((String)"+10"), b -> this.updateTextField(idx, 10)));
        }
        if (this.variableField != null) {
            this.oldVarName = this.variableField.getValue();
        }
        Objects.requireNonNull(this.font);
        this.variableField = new WidgetTextField(this.font, xMiddle - 50, yMiddle + 60, 100, 9 + 1);
        this.playerGlobal = !this.oldVarName.startsWith("%");
        this.oldVarName = GlobalVariableHelper.stripVarPrefix(this.oldVarName);
        this.variableField.setFilter(s -> VAR_PATTERN.matcher((CharSequence)s).matches());
        this.variableField.setValue(this.oldVarName);
        this.addRenderableWidget((GuiEventListener)this.variableField);
        this.varTypeButton = new WidgetButtonExtended(this.variableField.getX() - 13, yMiddle + 58, 12, 14, this.playerGlobal ? "#" : "%", b -> this.toggleVarType()).setTooltipKey("pneumaticcraft.gui.remote.varType.tooltip");
        this.addRenderableWidget((GuiEventListener)this.varTypeButton);
        if (ClientUtils.getClientPlayer().hasPermissions(2)) {
            BlockPos pos = this.getBlockPos();
            this.teleportButton = new WidgetButtonExtended(xMiddle - 50, this.variableField.getY() + this.variableField.getHeight() + 5, 100, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.gps_tool.teleport", new Object[0]), p -> {
                NetworkHandler.sendToServer(new PacketTeleportCommand(this.getBlockPos()));
                if (!ClientUtils.hasShiftDown()) {
                    this.onClose();
                }
            }).setTooltipText((Component)Component.literal((String)String.format("/tp %d %d %d", pos.getX(), pos.getY(), pos.getZ())).withStyle(ChatFormatting.YELLOW));
            this.addRenderableWidget((GuiEventListener)this.teleportButton);
        }
        MutableComponent mutableComponent = PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.variable", new Object[0]).append(":");
        int n = this.variableField.getX();
        int n2 = this.variableField.getY();
        Objects.requireNonNull(this.font);
        this.addLabel((Component)mutableComponent, n, n2 - 9 - 2).setColor(0xFFFFFF);
    }

    protected BlockPos getBlockPos() {
        return new BlockPos(this.textFields[0].getIntValue(), this.textFields[1].getIntValue(), this.textFields[2].getIntValue());
    }

    protected void toggleVarType() {
        this.playerGlobal = !this.playerGlobal;
        this.varTypeButton.setMessage((Component)Component.literal((String)GlobalVariableHelper.getVarPrefix(this.playerGlobal)));
    }

    private void updateTextField(int idx, int amount) {
        this.textFields[idx].setValue(this.textFields[idx].getIntValue() + amount);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        int xMiddle = this.width / 2;
        int yMiddle = this.height / 2;
        int stringX = xMiddle - 60 - 30;
        graphics.drawCenteredString(this.font, this.getTitle(), xMiddle, yMiddle - 58, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, "X:", stringX, yMiddle - 10 - 9 / 2, -1, false);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, "Y:", stringX, yMiddle + 4 + 9 / 2, -1, false);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, "Z:", stringX, yMiddle + 34 - 9 / 2, -1, false);
    }

    public void removed() {
        this.syncToServer();
        super.removed();
    }

    protected void syncToServer() {
        String varName = GlobalVariableHelper.getPrefixedVar(GlobalVariableHelper.stripVarPrefix(this.variableField.getValue()), this.playerGlobal);
        NetworkHandler.sendToServer(new PacketChangeGPSToolCoordinate(this.getBlockPos(), this.hand, varName, this.getIndex()));
    }

    protected int getIndex() {
        return 0;
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }
}

