/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.InventorySearcherMenu;
import me.desht.pneumaticcraft.common.item.GPSAreaToolItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class InventorySearcherScreen
extends AbstractContainerScreen<InventorySearcherMenu> {
    private final ItemStackHandler inventory = new ItemStackHandler(1);
    private final Screen parentScreen;
    private Predicate<ItemStack> stackPredicate = itemStack -> true;
    private WidgetLabel label;
    private int clickedMouseButton;

    public InventorySearcherScreen(InventorySearcherMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        inv.player.containerMenu = container;
        this.imageHeight = 176;
        this.parentScreen = Minecraft.getInstance().screen;
        container.init((IItemHandler)this.inventory);
    }

    protected void init() {
        super.init();
        this.label = new WidgetLabel(this.leftPos + 105, this.topPos + 28, (Component)Component.empty(), -12566400);
        this.addRenderableWidget((GuiEventListener)this.label);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        if (this.parentScreen != null) {
            ClientUtils.closeContainerGui(this.parentScreen);
        } else {
            super.onClose();
        }
    }

    public void setStackPredicate(Predicate<ItemStack> predicate) {
        this.stackPredicate = predicate;
    }

    @Nonnull
    public ItemStack getSearchStack() {
        return this.inventory.getStackInSlot(0);
    }

    public void setSearchStack(@Nonnull ItemStack stack) {
        if (!stack.isEmpty() && this.stackPredicate.test(stack)) {
            this.inventory.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType clickType) {
        if (slot != null) {
            if (slot.index == 36) {
                this.clickedMouseButton = 0;
                slot.set(ItemStack.EMPTY);
            } else {
                this.clickedMouseButton = mouseButton;
                this.setSearchStack(slot.getItem());
            }
        }
    }

    public void containerTick() {
        super.containerTick();
        if (this.inventory.getStackInSlot(0).getItem() instanceof IPositionProvider) {
            this.label.setMessage((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.getBlockPos())));
        } else {
            this.label.setMessage((Component)Component.empty());
        }
    }

    public BlockPos getBlockPos() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.getItem() instanceof IPositionProvider) {
            List<BlockPos> posList = ((IPositionProvider)stack.getItem()).getRawStoredPositions(ClientUtils.getClientPlayer(), stack);
            int posIdx = this.getPosIdx(stack);
            if (!posList.isEmpty()) {
                return posList.get(Math.min(posIdx, posList.size() - 1));
            }
        }
        return null;
    }

    private int getPosIdx(ItemStack stack) {
        if (stack.getItem() instanceof GPSAreaToolItem) {
            return switch (this.clickedMouseButton) {
                case 0 -> 1;
                case 1 -> 0;
                default -> 1;
            };
        }
        return this.clickedMouseButton;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        graphics.blit(Textures.GUI_INVENTORY_SEARCHER, xStart, yStart, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.getTitle(), this.width / 2, 5, 0x404040, false);
        for (int i = 0; i < ((InventorySearcherMenu)this.menu).slots.size() - 1; ++i) {
            Slot slot = (Slot)((InventorySearcherMenu)this.menu).slots.get(i);
            if (this.stackPredicate.test(slot.getItem())) continue;
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            graphics.fillGradient(slot.x, slot.y, slot.x + 16, slot.y + 16, -1071636448, -1071636448);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    public void render(GuiGraphics graphics, int par1, int par2, float par3) {
        super.render(graphics, par1, par2, par3);
        if (this.hoveredSlot != null && this.stackPredicate.test(this.hoveredSlot.getItem())) {
            this.renderTooltip(graphics, par1, par2);
        }
    }
}

