/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.ItemSearcherMenu;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.StringUtils;

public class ItemSearcherScreen
extends AbstractContainerScreen<ItemSearcherMenu> {
    private static final ResourceLocation GUI_TEXTURE = Textures.GUI_ITEM_SEARCHER;
    private static final ResourceLocation SCROLL_TEXTURE = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final int SEARCH_SLOT = 48;
    private static List<SearchEntry> cachedSearchEntries;
    private final ItemStackHandler inventory = new ItemStackHandler(49);
    private final Screen parentScreen;
    private double currentScroll;
    private boolean isScrolling;
    private EditBox searchField;
    private Rect2i scrollArea;
    private String lastSearch = "";
    private int updateCounter = 0;

    public ItemSearcherScreen(ItemSearcherMenu container, Inventory playerInventory, Component displayString) {
        super((AbstractContainerMenu)container, playerInventory, displayString);
        this.imageHeight = 176;
        this.parentScreen = Minecraft.getInstance().screen;
        container.init(this);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    @Nonnull
    public ItemStack getSearchStack() {
        return this.inventory.getStackInSlot(48);
    }

    public void setSearchStack(@Nonnull ItemStack stack) {
        this.inventory.setStackInSlot(48, stack);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            if (slot.index == 48) {
                slot.set(ItemStack.EMPTY);
            } else {
                this.inventory.setStackInSlot(48, slot.getItem());
            }
        }
    }

    public void init() {
        super.init();
        Objects.requireNonNull(this.font);
        this.searchField = new WidgetTextField(this.font, this.leftPos + 8, this.topPos + 35, 89, 9 + 3);
        this.searchField.setMaxLength(15);
        this.searchField.setBordered(true);
        this.searchField.setVisible(true);
        this.searchField.setTextColor(0xFFFFFF);
        this.searchField.setResponder(s -> this.textFieldResponder());
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.setFocused((GuiEventListener)this.searchField);
        this.scrollArea = new Rect2i(this.leftPos + 156, this.topPos + 48, 14, 112);
        this.updateCreativeSearch();
    }

    private void textFieldResponder() {
        if (!this.searchField.getValue().equals(this.lastSearch)) {
            this.updateCounter = 5;
        }
        this.lastSearch = this.searchField.getValue();
    }

    public void onClose() {
        if (this.parentScreen != null) {
            ClientUtils.closeContainerGui(this.parentScreen);
        } else {
            super.onClose();
        }
    }

    public void containerTick() {
        super.containerTick();
        if (this.updateCounter > 0 && --this.updateCounter == 0) {
            this.updateCreativeSearch();
        }
        if (this.parentScreen instanceof ArmorMainScreen && this.minecraft.player.getItemBySlot(EquipmentSlot.HEAD).getItem() != ModItems.PNEUMATIC_HELMET.get()) {
            this.onClose();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
        }
        return !this.searchField.keyPressed(keyCode, scanCode, modifiers) && this.searchField.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void getAllEnchantedBooks(Enchantment enchantment, NonNullList<ItemStack> list) {
        for (int i = enchantment.getMinLevel(); i <= enchantment.getMaxLevel(); ++i) {
            list.add((Object)EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, i)));
        }
    }

    private Stream<SearchEntry> getSearchEntries() {
        if (cachedSearchEntries == null) {
            cachedSearchEntries = CreativeModeTabs.searchTab().getDisplayItems().stream().map(x$0 -> new SearchEntry((ItemStack)x$0)).toList();
        }
        return cachedSearchEntries.stream();
    }

    private void updateCreativeSearch() {
        ((ItemSearcherMenu)this.menu).itemList.clear();
        String s = this.searchField.getValue().toLowerCase();
        List<ItemStack> applicableEntries = this.getSearchEntries().filter(entry -> entry.test(s)).map(entry -> entry.stack).toList();
        ((ItemSearcherMenu)this.menu).itemList.addAll(applicableEntries);
        this.currentScroll = 0.0;
        ((ItemSearcherMenu)this.menu).scrollTo(0.0);
    }

    private boolean needsScrollBars() {
        return ((ItemSearcherMenu)this.menu).hasMoreThan1PageOfItemsInList();
    }

    public boolean mouseScrolled(double x, double y, double dirX, double dirY) {
        if (dirY != 0.0 && this.needsScrollBars()) {
            int j = ((ItemSearcherMenu)this.menu).itemList.size() / 9 - 5 + 1;
            float i = dirY > 0.0 ? 1.0f : -1.0f;
            this.currentScroll = Mth.clamp((double)(this.currentScroll - (double)(i / (float)j)), (double)0.0, (double)1.0);
            ((ItemSearcherMenu)this.menu).scrollTo(this.currentScroll);
            return true;
        }
        return super.mouseScrolled(x, y, dirX, dirY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean bl = this.isScrolling = button == 0 && this.needsScrollBars() && this.scrollArea.contains((int)mouseX, (int)mouseY);
        if (this.isScrolling) {
            this.scrollTo(mouseY);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            this.scrollTo(mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private void scrollTo(double mouseY) {
        this.currentScroll = (mouseY - (double)this.scrollArea.getY()) / (double)this.scrollArea.getHeight();
        this.currentScroll = Mth.clamp((double)this.currentScroll, (double)0.0, (double)1.0);
        ((ItemSearcherMenu)this.menu).scrollTo(this.currentScroll);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.render(graphics, x, y, partialTicks);
        this.renderTooltip(graphics, x, y);
    }

    protected void renderLabels(GuiGraphics graphics, int par1, int par2) {
        graphics.drawString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.search", new Object[0]), 5, 5, 0x404040, false);
        graphics.drawString(this.font, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.filterLabel", new Object[0]), 8, 25, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float par1, int par2, int par3) {
        int xStart = (this.width - this.imageWidth) / 2;
        int yStart = (this.height - this.imageHeight) / 2;
        graphics.blit(GUI_TEXTURE, xStart, yStart, 0, 0, this.imageWidth, this.imageHeight);
        int x = this.scrollArea.getX();
        int y1 = this.scrollArea.getY();
        int y2 = y1 + this.scrollArea.getHeight();
        graphics.blit(Textures.WIDGET_VERTICAL_SCROLLBAR, x, y1 + (int)((double)(y2 - y1 - 17) * this.currentScroll), (float)(this.needsScrollBars() ? 0 : 12), 0.0f, 12, 15, 26, 15);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public class SearchEntry
    implements Predicate<String> {
        public final ItemStack stack;
        private final String tooltip;

        SearchEntry(ItemStack stack) {
            List l;
            this.stack = stack;
            try {
                l = stack.getTooltipLines((Player)((ItemSearcherScreen)ItemSearcherScreen.this).minecraft.player, (TooltipFlag)(((ItemSearcherScreen)ItemSearcherScreen.this).minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL)).stream().map(Component::getString).collect(Collectors.toList());
            }
            catch (Exception ignored) {
                l = Collections.emptyList();
            }
            this.tooltip = StringUtils.join(l, (String)"\n").toLowerCase();
        }

        @Override
        public boolean test(String searchString) {
            return this.tooltip.contains(searchString);
        }
    }
}

