/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateMicromissileSettings;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class MicromissileScreen
extends AbstractPneumaticCraftScreen {
    private static final Rect2i SELECTOR_BOUNDS = new Rect2i(12, 21, 92, 81);
    private static final int MAX_DIST = SELECTOR_BOUNDS.getWidth();
    private static final PointXY TOP_SPEED_PT = new PointXY(46, 1);
    private static final PointXY TURN_SPEED_PT = new PointXY(1, 80);
    private static final PointXY DMG_PT = new PointXY(92, 80);
    private float turnSpeed;
    private float topSpeed;
    private float damage;
    private PointXY point;
    private MicromissilesItem.FireMode fireMode;
    private boolean dragging = false;
    private String entityFilter;
    private int sendTimer = 0;
    private final InteractionHand hand;
    private WidgetTextField textField;
    private WidgetLabel filterLabel;
    private WidgetButtonExtended modeButton;
    private WidgetButtonExtended warningButton;

    private MicromissileScreen(Component title, InteractionHand hand) {
        super(title);
        this.xSize = 183;
        this.ySize = 191;
        ItemStack stack = ClientUtils.getClientPlayer().getItemInHand(hand);
        if (stack.getItem() == ModItems.MICROMISSILES.get() && stack.hasTag()) {
            CompoundTag tag = Objects.requireNonNull(stack.getTag());
            this.topSpeed = tag.getFloat("topSpeed");
            this.turnSpeed = tag.getFloat("turnSpeed");
            this.damage = tag.getFloat("damage");
            this.entityFilter = tag.getString("filter");
            this.point = new PointXY(tag.getInt("px"), tag.getInt("py"));
            this.fireMode = MicromissilesItem.FireMode.fromString(tag.getString("fireMode"));
            this.hand = hand;
        } else {
            this.damage = 0.33333334f;
            this.turnSpeed = 0.33333334f;
            this.topSpeed = 0.33333334f;
            this.point = new PointXY(MAX_DIST / 2, MAX_DIST / 4);
            this.entityFilter = "";
            this.fireMode = MicromissilesItem.FireMode.SMART;
            this.hand = InteractionHand.MAIN_HAND;
        }
    }

    public static void openGui(Component title, InteractionHand handIn) {
        Minecraft.getInstance().setScreen((Screen)new MicromissileScreen(title, handIn));
    }

    @Override
    public void init() {
        super.init();
        MutableComponent labelStr = PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.targetFilter", new Object[0]);
        this.filterLabel = new WidgetLabel(this.guiLeft + 12, this.guiTop + 130, (Component)labelStr);
        this.addRenderableWidget((GuiEventListener)this.filterLabel);
        int textBoxX = this.filterLabel.getX() + this.font.width((FormattedText)labelStr) + 2;
        int textBoxWidth = this.xSize - (textBoxX - this.guiLeft) - 12;
        Objects.requireNonNull(this.font);
        this.textField = new WidgetTextField(this.font, textBoxX, this.guiTop + 128, textBoxWidth, 9 + 3);
        this.textField.setValue(this.entityFilter);
        this.setFocused((GuiEventListener)this.textField);
        this.textField.setResponder(s -> {
            this.entityFilter = s;
            if (this.validateEntityFilter(this.entityFilter)) {
                this.sendTimer = 5;
            }
        });
        this.addRenderableWidget((GuiEventListener)this.textField);
        this.addRenderableWidget((GuiEventListener)new WidgetTooltipArea(this.guiLeft + 42, this.guiTop + 9, 35, 9, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.topSpeed", new Object[0])}));
        this.addRenderableWidget((GuiEventListener)new WidgetTooltipArea(this.guiLeft + 6, this.guiTop + 103, 25, 12, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.turnSpeed", new Object[0])}));
        this.addRenderableWidget((GuiEventListener)new WidgetTooltipArea(this.guiLeft + 96, this.guiTop + 103, 15, 15, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.damage", new Object[0])}));
        MutableComponent saveLabel = PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.saveDefault", new Object[0]);
        int buttonWidth = this.font.width((FormattedText)saveLabel) + 10;
        int buttonX = this.guiLeft + (this.xSize - buttonWidth) / 2;
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(buttonX, this.guiTop + 160, buttonWidth, 20, (Component)saveLabel, b -> this.sendSettingsToServer(true)));
        this.modeButton = new WidgetButtonExtended(this.guiLeft + 123, this.guiTop + 20, 52, 20, (Component)Component.empty(), b -> this.modeSwitch()).setTooltipKey("pneumaticcraft.gui.micromissile.modeTooltip");
        this.addRenderableWidget((GuiEventListener)this.modeButton);
        this.warningButton = new WidgetButtonExtended(this.guiLeft + 162, this.guiTop + 123, 20, 20);
        this.warningButton.setVisible(false);
        this.warningButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE);
        this.addRenderableWidget((GuiEventListener)this.warningButton);
        this.validateEntityFilter(this.entityFilter);
        this.setupWidgets();
    }

    private void modeSwitch() {
        int n = this.fireMode.ordinal() + 1;
        if (n >= MicromissilesItem.FireMode.values().length) {
            n = 0;
        }
        this.fireMode = MicromissilesItem.FireMode.values()[n];
        this.setupWidgets();
        this.sendSettingsToServer(false);
    }

    private void setupWidgets() {
        this.textField.setEditable(this.fireMode == MicromissilesItem.FireMode.SMART);
        this.filterLabel.setColor(this.fireMode == MicromissilesItem.FireMode.SMART ? -12566464 : -5592406);
        this.modeButton.setMessage((Component)PneumaticCraftUtils.xlate(this.fireMode.getTranslationKey(), new Object[0]));
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.render(graphics, x, y, partialTicks);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(graphics, this, this.font, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
        } else if (this.textField.isHoveredOrFocused()) {
            String str = I18n.get((String)"pneumaticcraft.gui.entityFilter.holdF1", (Object[])new Object[0]);
            graphics.drawString(this.font, str, this.guiLeft + (this.xSize - this.font.width(str)) / 2, this.guiTop + this.ySize + 5, 0x808080, false);
        }
    }

    @Override
    protected void drawForeground(GuiGraphics graphics, int x, int y, float partialTicks) {
        if (this.fireMode == MicromissilesItem.FireMode.DUMB) {
            return;
        }
        if (this.point != null) {
            float px = this.point.x();
            float py = this.point.y();
            graphics.pose().pushPose();
            graphics.pose().translate((float)(this.guiLeft + SELECTOR_BOUNDS.getX()), (float)(this.guiTop + SELECTOR_BOUNDS.getY()), 0.0f);
            int size = this.dragging ? 5 : 3;
            RenderSystem.lineWidth((float)2.0f);
            BufferBuilder wr = Tesselator.getInstance().getBuilder();
            Matrix4f posMat = graphics.pose().last().pose();
            wr.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
            wr.vertex(posMat, px - (float)size, py, 0.0f).color(32, 32, 32, 255).endVertex();
            wr.vertex(posMat, px + (float)size, py, 0.0f).color(32, 32, 32, 255).endVertex();
            wr.vertex(posMat, px, py - (float)size, 0.0f).color(32, 32, 32, 255).endVertex();
            wr.vertex(posMat, px, py + (float)size, 0.0f).color(32, 32, 32, 255).endVertex();
            Tesselator.getInstance().end();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth((float)1.0f);
            wr.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
            wr.vertex(posMat, px, py, 0.0f).color(32, 32, 32, 128).endVertex();
            wr.vertex(posMat, (float)SELECTOR_BOUNDS.getWidth() / 2.0f, 0.0f, 0.0f).color(32, 32, 32, 128).endVertex();
            wr.vertex(posMat, px, py, 0.0f).color(32, 32, 32, 128).endVertex();
            wr.vertex(posMat, 0.0f, (float)SELECTOR_BOUNDS.getHeight(), 0.0f).color(32, 32, 32, 128).endVertex();
            wr.vertex(posMat, px, py, 0.0f).color(32, 32, 32, 128).endVertex();
            wr.vertex(posMat, (float)SELECTOR_BOUNDS.getWidth(), (float)SELECTOR_BOUNDS.getHeight(), 0.0f).color(32, 32, 32, 128).endVertex();
            Tesselator.getInstance().end();
            RenderSystem.disableBlend();
            graphics.pose().popPose();
        }
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.guiLeft, (float)this.guiTop, 0.0f);
        graphics.fill(125, 48, 125 + (int)(49.0f * this.topSpeed), 54, -16728064);
        graphics.fill(125, 68, 125 + (int)(49.0f * this.turnSpeed), 74, -16728064);
        graphics.fill(125, 88, 125 + (int)(49.0f * this.damage), 94, -16728064);
        graphics.pose().popPose();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.sendTimer > 0 && --this.sendTimer == 0) {
            this.sendSettingsToServer(false);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_MICROMISSILE;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.trySetPoint((int)mouseX, (int)mouseY)) {
            this.dragging = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging) {
            this.sendSettingsToServer(false);
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (this.dragging) {
            this.trySetPoint((int)mouseX, (int)mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, dx, dy);
    }

    private boolean validateEntityFilter(String filter) {
        try {
            this.warningButton.visible = false;
            this.warningButton.setTooltipText((Component)Component.empty());
            new EntityFilter(filter);
            return true;
        }
        catch (Exception e) {
            this.warningButton.visible = true;
            this.warningButton.setTooltipText((Component)Component.literal((String)e.getMessage()).withStyle(ChatFormatting.GOLD));
            return false;
        }
    }

    private boolean trySetPoint(int mouseX, int mouseY) {
        PointXY p = this.getPoint(mouseX, mouseY);
        if (p != null) {
            double dSpeed = (double)MAX_DIST - p.distance(TOP_SPEED_PT);
            double dTurnSpd = (double)MAX_DIST - p.distance(TURN_SPEED_PT);
            double dDamage = (double)MAX_DIST - p.distance(DMG_PT);
            double total = dSpeed + dTurnSpd + dDamage;
            this.topSpeed = (float)(dSpeed / total);
            this.turnSpeed = (float)(dTurnSpd / total);
            this.damage = (float)(dDamage / total);
            this.point = p;
            return true;
        }
        return false;
    }

    private void sendSettingsToServer(boolean saveDefault) {
        NetworkHandler.sendToServer(new PacketUpdateMicromissileSettings(this.topSpeed, this.turnSpeed, this.damage, this.point, this.entityFilter, this.fireMode, saveDefault, this.hand));
    }

    private PointXY getPoint(int mouseX, int mouseY) {
        Rect2i r = new Rect2i(SELECTOR_BOUNDS.getX() + this.guiLeft, SELECTOR_BOUNDS.getY() + this.guiTop, SELECTOR_BOUNDS.getWidth(), SELECTOR_BOUNDS.getHeight());
        if (!r.contains(mouseX, mouseY)) {
            return null;
        }
        PointXY p = new PointXY(mouseX - r.getX(), mouseY - r.getY());
        return this.isPointInTriangle(p, TOP_SPEED_PT, TURN_SPEED_PT, DMG_PT) ? p : null;
    }

    private boolean isPointInTriangle(PointXY s, PointXY a, PointXY b, PointXY c) {
        int as_x = s.x() - a.x();
        int as_y = s.y() - a.y();
        boolean s_ab = (b.x() - a.x()) * as_y - (b.y() - a.y()) * as_x > 0;
        if ((c.x() - a.x()) * as_y - (c.y() - a.y()) * as_x > 0 == s_ab) {
            return false;
        }
        return (c.x() - b.x()) * (s.y() - b.y()) - (c.y() - b.y()) * (s.x() - b.x()) > 0 == s_ab;
    }
}

