/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.base.CaseFormat;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.JsonToNBTConverter;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import me.desht.pneumaticcraft.common.util.NBTToJsonConverter;
import me.desht.pneumaticcraft.common.util.PastebinHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PastebinScreen
extends AbstractPneumaticCraftScreen {
    private WidgetTextField usernameBox;
    private WidgetTextField passwordBox;
    private WidgetTextField pastebinBox;
    private WidgetCheckBox prettyCB;
    private final CompoundTag pastingNBT;
    private final Screen parentScreen;
    private Component statusMessage = Component.empty();
    private Component lastMessage = Component.empty();
    private int messageTimer;
    private EnumState state = EnumState.NONE;
    CompoundTag outputTag;
    boolean shouldMerge;

    PastebinScreen(Screen parentScreen, CompoundTag tag) {
        super((Component)Component.literal((String)"Pastebin"));
        this.xSize = 183;
        this.ySize = 202;
        this.pastingNBT = tag;
        this.parentScreen = parentScreen;
    }

    @Override
    public void init() {
        super.init();
        if (!PastebinHandler.isLoggedIn()) {
            this.usernameBox = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 30, 80, 10);
            this.addRenderableWidget((GuiEventListener)this.usernameBox);
            this.passwordBox = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 56, 80, 10).setAsPasswordBox();
            this.addRenderableWidget((GuiEventListener)this.passwordBox);
            WidgetButtonExtended loginButton = new WidgetButtonExtended(this.guiLeft + 100, this.guiTop + 30, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.login", new Object[0]), b -> this.login());
            loginButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.loginOptional", new Object[0]));
            this.addRenderableWidget((GuiEventListener)loginButton);
            this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.username", new Object[0]), this.guiLeft + 10, this.guiTop + 20);
            this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.password", new Object[0]), this.guiLeft + 10, this.guiTop + 46);
        } else {
            WidgetButtonExtended logoutButton = new WidgetButtonExtended(this.guiLeft + 60, this.guiTop + 30, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.logout", new Object[0]), b -> this.logout());
            this.addRenderableWidget((GuiEventListener)logoutButton);
        }
        this.pastebinBox = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 130, 160, 10){

            public void setFocused(boolean focused) {
                boolean previousFocus = this.isFocused();
                super.setFocused(focused);
                if (previousFocus != focused && focused) {
                    this.moveCursorToEnd(true);
                    this.setHighlightPos(0);
                }
            }
        };
        this.addRenderableWidget((GuiEventListener)this.pastebinBox);
        WidgetButtonExtended pasteButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 78, 120, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.upload", new Object[0]), b -> this.sendToPastebin());
        this.addRenderableWidget((GuiEventListener)pasteButton);
        WidgetButtonExtended getButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 167, 120, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.get", new Object[0]), b -> this.getFromPastebin());
        this.addRenderableWidget((GuiEventListener)getButton);
        WidgetButtonExtended putInClipBoard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 78, 20, 20, (Component)Component.empty(), b -> this.putToClipboard());
        putInClipBoard.setRenderedIcon(Textures.GUI_COPY_ICON_LOCATION);
        putInClipBoard.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.copyToClipboard", new Object[0]));
        this.addRenderableWidget((GuiEventListener)putInClipBoard);
        WidgetButtonExtended retrieveFromClipboard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 167, 20, 20, (Component)Component.empty(), b -> this.getFromClipboard());
        retrieveFromClipboard.setRenderedIcon(Textures.GUI_PASTE_ICON_LOCATION);
        retrieveFromClipboard.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.loadFromClipboard", new Object[0]));
        this.addRenderableWidget((GuiEventListener)retrieveFromClipboard);
        this.prettyCB = new WidgetCheckBox(0, this.guiTop + 102, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.pretty", new Object[0]), b -> {
            this.shouldMerge = b.checked;
        });
        this.prettyCB.setX(this.guiLeft + (170 - this.prettyCB.getWidth()));
        this.prettyCB.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.pretty.tooltip", new Object[0])));
        this.addRenderableWidget((GuiEventListener)this.prettyCB);
        if (this.parentScreen instanceof ProgrammerScreen) {
            WidgetCheckBox mergeCB = new WidgetCheckBox(0, this.guiTop + 155, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.merge", new Object[0]), b -> {
                this.shouldMerge = b.checked;
            });
            mergeCB.setX(this.guiLeft + (170 - mergeCB.getWidth()));
            mergeCB.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.merge.tooltip", new Object[0])));
            this.addRenderableWidget((GuiEventListener)mergeCB);
        }
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.pastebinLink", new Object[0]), this.guiLeft + 10, this.guiTop + 120);
    }

    private void login() {
        PastebinHandler.login(this.usernameBox.getValue(), this.passwordBox.getValue());
        this.state = EnumState.LOGIN;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.loggingIn", new Object[0]);
    }

    private void logout() {
        PastebinHandler.logout();
        this.state = EnumState.LOGOUT;
    }

    private void sendToPastebin() {
        PastebinHandler.put(new NBTToJsonConverter(this.pastingNBT).convert(this.prettyCB.checked));
        this.state = EnumState.PUTTING;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.uploadingToPastebin", new Object[0]);
    }

    private void getFromPastebin() {
        PastebinHandler.get(this.pastebinBox.getValue());
        this.state = EnumState.GETTING;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.retrievingFromPastebin", new Object[0]);
    }

    private void putToClipboard() {
        this.minecraft.keyboardHandler.setClipboard(new NBTToJsonConverter(this.pastingNBT).convert(this.prettyCB.checked));
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.clipboardSetToContents", new Object[0]);
    }

    private void getFromClipboard() {
        this.readFromString(this.minecraft.keyboardHandler.getClipboard());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.state == EnumState.LOGOUT) {
            this.state = EnumState.NONE;
            this.init(this.minecraft, this.width, this.height);
        }
        if (this.state != EnumState.NONE && PastebinHandler.isDone()) {
            this.statusMessage = Component.empty();
            switch (this.state) {
                case GETTING: {
                    String pastebinText = PastebinHandler.getHandler().contents;
                    if (pastebinText != null) {
                        this.readFromString(pastebinText);
                        break;
                    }
                    this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidPastebin", new Object[0]);
                    break;
                }
                case PUTTING: {
                    if (PastebinHandler.getException() != null) {
                        this.statusMessage = Component.literal((String)PastebinHandler.getException().getMessage());
                        break;
                    }
                    String pastebinText = PastebinHandler.getHandler().getLink;
                    if (pastebinText == null) {
                        pastebinText = "<ERROR>";
                    }
                    if (pastebinText.contains("pastebin.com")) {
                        this.pastebinBox.setValue(pastebinText);
                        this.setTempMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.uploadedToPastebin", new Object[0]));
                        break;
                    }
                    this.statusMessage = Component.literal((String)pastebinText);
                    break;
                }
                case LOGIN: {
                    if (!PastebinHandler.isLoggedIn()) {
                        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidLogin", new Object[0]);
                    }
                    this.init();
                }
            }
            this.state = EnumState.NONE;
        }
        if (this.messageTimer > 0 && --this.messageTimer <= 0) {
            this.lastMessage = Component.empty();
        }
    }

    private void setTempMessage(Component msg) {
        this.lastMessage = msg;
        this.messageTimer = 60;
    }

    private void readFromString(String string) {
        try {
            this.outputTag = new JsonToNBTConverter(string).convert();
            if (this.outputTag.contains("widgets")) {
                this.doLegacyConversion(this.outputTag);
            }
            this.setTempMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.retrievedFromPastebin", new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setTempMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidFormattedPastebin", new Object[0]).withStyle(ChatFormatting.GOLD));
        }
    }

    private void doLegacyConversion(CompoundTag nbt) {
        ListTag l = nbt.getList("widgets", 10);
        int areaConversions = 0;
        for (int i = 0; i < l.size(); ++i) {
            CompoundTag subTag = l.getCompound(i);
            String newName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, subTag.getString("name"));
            subTag.putString("name", "pneumaticcraft:" + newName);
            if (!newName.equals("area")) continue;
            LegacyAreaWidgetConverter.EnumOldAreaType oldType = LegacyAreaWidgetConverter.EnumOldAreaType.values()[subTag.getInt("type")];
            AreaType newType = LegacyAreaWidgetConverter.convertFromLegacyFormat(oldType, subTag.getInt("typeInfo"));
            subTag.putString("type", newType.getName());
            newType.writeToNBT(subTag);
            ++areaConversions;
        }
        nbt.put("pneumaticcraft:progWidgets", (Tag)l);
        nbt.remove("widgets");
        if (areaConversions > 0) {
            Log.info("Pastebin import: converted {} legacy area widgets", areaConversions);
        }
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.renderBackground(graphics, x, y, partialTicks);
        super.render(graphics, x, y, partialTicks);
        if (!this.statusMessage.getString().isEmpty()) {
            graphics.drawString(this.font, this.statusMessage, this.guiLeft + 5, this.guiTop + 5, -256, false);
        } else if (!this.lastMessage.getString().isEmpty()) {
            graphics.drawString(this.font, this.lastMessage, this.guiLeft + 5, this.guiTop + 5, -16711936, false);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_PASTEBIN;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static enum EnumState {
        NONE,
        GETTING,
        PUTTING,
        LOGIN,
        LOGOUT;

    }
}

