/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetEnergy;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.PneumaticDynamoBlockEntity;
import me.desht.pneumaticcraft.common.inventory.PneumaticDynamoMenu;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class PneumaticDynamoScreen
extends AbstractPneumaticCraftContainerScreen<PneumaticDynamoMenu, PneumaticDynamoBlockEntity> {
    private WidgetAnimatedStat inputStat;
    private WidgetTemperature tempWidget;

    public PneumaticDynamoScreen(PneumaticDynamoMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.inputStat = this.addAnimatedStat((Component)Component.literal((String)"Output"), Textures.GUI_BUILDCRAFT_ENERGY, -11184811, false);
        IOHelper.getEnergyStorageForBlock(this.te).ifPresent(storage -> this.addRenderableWidget((GuiEventListener)new WidgetEnergy(this.leftPos + 20, this.topPos + 20, (IEnergyStorage)storage)));
        this.tempWidget = new WidgetTemperature(this.leftPos + 97, this.topPos + 20, TemperatureRange.of(273, 673), 273, 50).setOperatingRange(TemperatureRange.of(323, 625)).setShowOperatingRange(false);
        this.addRenderableWidget((GuiEventListener)this.tempWidget);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_4UPGRADE_SLOTS;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.inputStat.setText(this.getOutputStat());
        this.tempWidget.setTemperature(((PneumaticDynamoBlockEntity)this.te).getHeatExchanger().getTemperatureAsInt());
        this.tempWidget.autoScaleForTemperature();
    }

    private List<Component> getOutputStat() {
        ArrayList<Component> textList = new ArrayList<Component>();
        textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.pneumaticDynamo.maxEnergyProduction", new Object[0]).withStyle(ChatFormatting.GRAY));
        textList.add((Component)Component.literal((String)(((PneumaticDynamoBlockEntity)this.te).getRFRate() + " FE/t")).withStyle(ChatFormatting.BLACK));
        textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.pneumaticDynamo.maxOutputRate", new Object[0]).withStyle(ChatFormatting.GRAY));
        textList.add((Component)Component.literal((String)(((PneumaticDynamoBlockEntity)this.te).getRFRate() * 2 + " FE/t")).withStyle(ChatFormatting.BLACK));
        textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.fluxCompressor.storedEnergy", new Object[0]).withStyle(ChatFormatting.GRAY));
        textList.add((Component)Component.literal((String)(((PneumaticDynamoBlockEntity)this.te).getInfoEnergyStored() + " FE")).withStyle(ChatFormatting.BLACK));
        return textList;
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxUsage", ((PneumaticDynamoBlockEntity)this.te).getAirRate()).withStyle(ChatFormatting.BLACK));
    }

    @Override
    public void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((PneumaticDynamoBlockEntity)this.te).getEfficiency() < 100) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.advancedAirCompressor.efficiency", ((PneumaticDynamoBlockEntity)this.te).getEfficiency() + "%"));
        }
    }

    @Override
    protected PointXY getGaugeLocation() {
        return super.getGaugeLocation().add(10, 0);
    }
}

