/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.InventorySearcherScreen;
import me.desht.pneumaticcraft.client.gui.PastebinScreen;
import me.desht.pneumaticcraft.client.gui.RemoteScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteLayout;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidget;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetButton;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetDropdown;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetLabel;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.WidgetLabelVariable;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.RemoteMenu;
import me.desht.pneumaticcraft.common.item.RemoteItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateRemoteLayout;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RemoteEditorScreen
extends RemoteScreen {
    private InventorySearcherScreen invSearchGui;
    private PastebinScreen pastebinGui;
    private final List<ActionWidget<?>> widgetTray = new ArrayList();
    private ActionWidget<?> draggingWidget;
    private int dragMouseStartX;
    private int dragMouseStartY;
    private int dragWidgetStartX;
    private int dragWidgetStartY;
    private int oldGuiLeft;
    private int oldGuiTop;

    public RemoteEditorScreen(RemoteMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageWidth = 283;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_REMOTE_EDITOR;
    }

    @Override
    public void init() {
        if (this.pastebinGui != null && this.pastebinGui.outputTag != null) {
            tag = this.remote.getOrCreateTag();
            tag.put("actionWidgets", (Tag)this.pastebinGui.outputTag.getList("main", 10));
        } else if (this.remoteLayout != null) {
            tag = this.remote.getOrCreateTag();
            tag.put("actionWidgets", (Tag)this.remoteLayout.toNBT(this.oldGuiLeft, this.oldGuiTop).getList("actionWidgets", 10));
        }
        if (this.invSearchGui != null && this.invSearchGui.getSearchStack().getItem() == ModItems.REMOTE.get()) {
            if (RemoteItem.hasSameSecuritySettings(this.remote, this.invSearchGui.getSearchStack())) {
                this.remoteLayout = new RemoteLayout(this.invSearchGui.getSearchStack(), this.leftPos, this.topPos);
            } else {
                ClientUtils.getClientPlayer().displayClientMessage((Component)Component.literal((String)"pneumaticcraft.gui.remote.differentSecuritySettings"), false);
            }
        }
        super.init();
        this.oldGuiLeft = this.leftPos;
        this.oldGuiTop = this.topPos;
        this.widgetTray.clear();
        this.widgetTray.add(new ActionWidgetCheckBox(new WidgetCheckBox(this.leftPos + 200, this.topPos + 23, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tray.checkbox.name", new Object[0]))));
        this.widgetTray.add(new ActionWidgetLabel(new WidgetLabelVariable(this.leftPos + 200, this.topPos + 38, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tray.label.name", new Object[0]))));
        this.widgetTray.add(new ActionWidgetButton(new WidgetButtonExtended(this.leftPos + 200, this.topPos + 53, 50, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tray.button.name", new Object[0]))));
        Objects.requireNonNull(this.font);
        this.widgetTray.add(new ActionWidgetDropdown(new WidgetComboBox(this.font, this.leftPos + 200, this.topPos + 79, 70, 9 + 3).setFixedOptions(true)));
        for (ActionWidget actionWidget : this.widgetTray) {
            this.addRenderableWidget((GuiEventListener)actionWidget.getWidget());
        }
        WidgetButtonExtended importBtn = new WidgetButtonExtended(this.leftPos - 24, this.topPos, 20, 20, (Component)Component.empty(), b -> this.doImport()).setRenderStacks(new ItemStack((ItemLike)ModItems.REMOTE.get()));
        importBtn.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.importRemoteButton", new Object[0])));
        this.addRenderableWidget((GuiEventListener)importBtn);
        WidgetButtonExtended widgetButtonExtended = new WidgetButtonExtended(this.leftPos - 24, this.topPos + 22, 20, 20, (Component)Component.empty(), b -> this.doPastebin()).setRenderedIcon(Textures.GUI_PASTEBIN_ICON_LOCATION);
        widgetButtonExtended.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.pastebinButton", new Object[0])));
        this.addRenderableWidget((GuiEventListener)widgetButtonExtended);
        WidgetCheckBox snapCheck = new WidgetCheckBox(this.leftPos + 194, this.topPos + 105, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.snapToGrid", new Object[0]), b -> ConfigHelper.setGuiRemoteGridSnap(b.checked));
        snapCheck.checked = (Boolean)ConfigHelper.client().general.guiRemoteGridSnap.get();
        this.addRenderableWidget((GuiEventListener)snapCheck);
        this.addRenderableWidget((GuiEventListener)new WidgetLabel(this.leftPos + 234, this.topPos + 7, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.widgetTray", new Object[0]).withStyle(ChatFormatting.DARK_BLUE)).setAlignment(WidgetLabel.Alignment.CENTRE));
    }

    private void doImport() {
        ClientUtils.openContainerGui(ModMenuTypes.INVENTORY_SEARCHER.get(), (Component)Component.translatable((String)"pneumaticcraft.gui.amadron.addTrade.invSearch"));
        if (this.minecraft.screen instanceof InventorySearcherScreen) {
            this.invSearchGui = (InventorySearcherScreen)this.minecraft.screen;
            this.invSearchGui.setStackPredicate(s -> s.getItem() == ModItems.REMOTE.get());
        }
    }

    private void doPastebin() {
        CompoundTag mainTag = new CompoundTag();
        mainTag.put("main", (Tag)(this.remote.hasTag() ? this.remote.getTag().getList("actionWidgets", 10) : new CompoundTag()));
        this.pastebinGui = new PastebinScreen((Screen)this, mainTag);
        this.minecraft.setScreen((Screen)this.pastebinGui);
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        graphics.blit(this.getGuiTexture(), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 320, 256);
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(-50, 0);
    }

    private boolean isOutsideProgrammingArea(ActionWidget<?> actionWidget) {
        Object w = actionWidget.getWidget();
        return w.getX() < this.leftPos || w.getY() < this.topPos || w.getX() + w.getWidth() > this.leftPos + 183 || w.getY() + w.getHeight() > this.topPos + this.imageHeight;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int x = (int)mouseX;
        int y = (int)mouseY;
        switch (mouseButton) {
            case 0: {
                for (ActionWidget<?> actionWidget : this.widgetTray) {
                    if (!actionWidget.getWidget().isHoveredOrFocused()) continue;
                    this.startDrag(actionWidget.copy(), x, y);
                    this.remoteLayout.addWidget(this.draggingWidget);
                    this.addRenderableWidget((GuiEventListener)this.draggingWidget.getWidget());
                    return true;
                }
                if (this.draggingWidget != null) break;
                for (ActionWidget<?> actionWidget : this.remoteLayout.getActionWidgets()) {
                    if (!actionWidget.getWidget().isHoveredOrFocused()) continue;
                    this.startDrag(actionWidget, x, y);
                    return true;
                }
                break;
            }
            case 1: {
                for (ActionWidget<?> actionWidget : this.remoteLayout.getActionWidgets()) {
                    if (this.isOutsideProgrammingArea(actionWidget) || !actionWidget.getWidget().isHoveredOrFocused()) continue;
                    Screen screen = actionWidget.getGui(this);
                    if (screen != null) {
                        this.minecraft.setScreen(screen);
                    }
                    return true;
                }
                break;
            }
            case 2: {
                for (ActionWidget<?> actionWidget : this.remoteLayout.getActionWidgets()) {
                    if (!actionWidget.getWidget().isHoveredOrFocused()) continue;
                    this.startDrag(actionWidget.copy(), x, y);
                    this.remoteLayout.addWidget(this.draggingWidget);
                    this.addRenderableWidget((GuiEventListener)this.draggingWidget.getWidget());
                    return true;
                }
                break;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void startDrag(ActionWidget<?> widget, int x, int y) {
        this.draggingWidget = widget;
        this.dragMouseStartX = x;
        this.dragMouseStartY = y;
        this.dragWidgetStartX = widget.getWidget().getX();
        this.dragWidgetStartY = widget.getWidget().getY();
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.draggingWidget != null && this.isOutsideProgrammingArea(this.draggingWidget)) {
            this.remoteLayout.getActionWidgets().remove(this.draggingWidget);
            this.removeWidget((AbstractWidget)this.draggingWidget.getWidget());
        }
        this.draggingWidget = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.draggingWidget != null) {
            int x = (int)mouseX;
            int y = (int)mouseY;
            int x1 = x - this.dragMouseStartX + this.dragWidgetStartX;
            int y1 = y - this.dragMouseStartY + this.dragWidgetStartY;
            if (((Boolean)ConfigHelper.client().general.guiRemoteGridSnap.get()).booleanValue()) {
                x1 = x1 / 4 * 4;
                y1 = y1 / 4 * 4;
            }
            this.draggingWidget.setWidgetPos(x1, y1);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    @Override
    public void onGlobalVariableChange(String variable) {
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    @Override
    public void removed() {
        ItemStack stack = ClientUtils.getClientPlayer().getItemInHand(((RemoteMenu)this.menu).getHand());
        if (stack.getItem() == ModItems.REMOTE.get()) {
            CompoundTag nbt = this.remoteLayout.toNBT(this.leftPos, this.topPos);
            stack.getOrCreateTag().put("actionWidgets", (Tag)nbt.getList("actionWidgets", 10));
            NetworkHandler.sendToServer(new PacketUpdateRemoteLayout(this.remoteLayout.toNBT(this.leftPos, this.topPos), ((RemoteMenu)this.menu).getHand()));
        }
        super.removed();
    }
}

