/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRangeToggleButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.render.HackSimulationRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.inventory.SecurityStationMainMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SecurityStationInventoryScreen
extends AbstractPneumaticCraftContainerScreen<SecurityStationMainMenu, SecurityStationBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private WidgetAnimatedStat accessStat;
    private WidgetButtonExtended addUserButton;
    private Button rebootButton;
    private WidgetTextField sharedUserTextField;
    private List<WidgetButtonExtended> sharedUserList;
    private HackSimulationRenderer hackRenderer;
    private HackSimulation hackSimulation;
    private boolean reInitBG;

    public SecurityStationInventoryScreen(SecurityStationMainMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageHeight = 239;
    }

    @Override
    public void init() {
        super.init();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.SECURITY_STATION.get()), -3112960, false);
        this.accessStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.sharedUsers", new Object[0]), new ItemStack((ItemLike)Items.PLAYER_HEAD), -16755456, false);
        this.addUserButton = new WidgetButtonExtended(105, 12, 16, 16, "+", b -> {
            if (!this.sharedUserTextField.getValue().isEmpty()) {
                NetworkHandler.sendToServer(new PacketGuiButton("add:" + this.sharedUserTextField.getValue()));
                this.sharedUserTextField.setValue("");
            }
        });
        this.sharedUserTextField = new WidgetTextField(this.font, 20, 15, 80, 10);
        this.accessStat.addSubWidget((AbstractWidget)this.sharedUserTextField);
        this.accessStat.addSubWidget((AbstractWidget)this.addUserButton);
        this.accessStat.setMinimumExpandedDimensions(125, 40);
        this.rebootButton = new WidgetButtonExtended(this.leftPos + 110, this.topPos + 17, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.reboot", new Object[0])).withTag("reboot");
        this.addRenderableWidget((GuiEventListener)this.rebootButton);
        WidgetButtonExtended testButton = ((WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(this.leftPos + 110, this.topPos + 107, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.test", new Object[0])))).withTag("test");
        if (!((Boolean)ConfigHelper.common().machines.securityStationAllowHacking.get()).booleanValue()) {
            testButton.active = false;
            testButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackDisabled", new Object[0]));
        }
        this.addRenderableWidget((GuiEventListener)new WidgetRangeToggleButton(this.leftPos + 154, this.topPos + 130, (IRangedTE)((Object)this.te)));
        this.updateUserList();
        this.initConnectionRendering();
    }

    private void initConnectionRendering() {
        this.hackRenderer = new HackSimulationRenderer(this.leftPos + 25, this.topPos + 27, 18);
        this.hackSimulation = HackSimulation.dummySimulation();
        this.hackSimulation.wakeUp();
        for (int i = 0; i < ((SecurityStationBlockEntity)this.te).getItemHandler().getSlots(); ++i) {
            this.hackSimulation.addNode(i, ((SecurityStationBlockEntity)this.te).getItemHandler().getStackInSlot(i));
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SECURITY_STATION;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return new PointXY(0, 2);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float opacity, int x, int y) {
        super.renderBg(graphics, opacity, x, y);
        this.hackRenderer.render(graphics, this.hackSimulation, -14540033);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (this.reInitBG) {
            this.initConnectionRendering();
            this.reInitBG = false;
        }
        this.hackSimulation.tick();
        this.statusStat.setText(this.getStatusText());
        this.accessStat.setText(this.getAccessText());
        MutableComponent rebootButtonString = ((SecurityStationBlockEntity)this.te).getRebootTime() > 0 ? (((SecurityStationBlockEntity)this.te).getRebootTime() % 100 < 20 ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.rebooting", new Object[0]) : Component.literal((String)PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((SecurityStationBlockEntity)this.te).getRebootTime(), false))) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.reboot", new Object[0]).withStyle(ChatFormatting.RED);
        this.rebootButton.setMessage((Component)rebootButtonString);
        this.addUserButton.visible = this.accessStat.isDoneExpanding();
        for (WidgetButtonExtended button : this.sharedUserList) {
            button.active = this.accessStat.isDoneExpanding();
        }
        if (this.sharedUserList.size() != ((SecurityStationBlockEntity)this.te).sharedUsers.size()) {
            this.updateUserList();
        }
        this.rebootButton.active = ((SecurityStationBlockEntity)this.te).getRebootTime() == 0;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.sharedUserTextField.isFocused() && !this.sharedUserTextField.getValue().isEmpty()) {
            NetworkHandler.sendToServer(new PacketGuiButton("add:" + this.sharedUserTextField.getValue()));
            this.sharedUserTextField.setValue("");
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void addProblems(List<Component> text) {
        super.addProblems(text);
        if (((SecurityStationBlockEntity)this.te).getRebootTime() > 0) {
            text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.security_station.rebooting", PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((SecurityStationBlockEntity)this.te).getRebootTime(), false)));
        } else if (((SecurityStationBlockEntity)this.te).isHacked()) {
            text.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.security_station.hacked", new Object[0]));
        }
        if (!((SecurityStationBlockEntity)this.te).hasValidNetwork()) {
            text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.security_station.invalidNetwork", new Object[0]).withStyle(ChatFormatting.WHITE));
            SecurityStationBlockEntity.EnumNetworkValidityProblem problem = ((SecurityStationBlockEntity)this.te).checkForNetworkValidity();
            if (problem != SecurityStationBlockEntity.EnumNetworkValidityProblem.NONE) {
                text.addAll(GuiUtils.xlateAndSplit(problem.getTranslationKey(), new Object[0]));
            }
        }
    }

    private List<Component> getStatusText() {
        ArrayList<Component> text = new ArrayList<Component>();
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.protection", new Object[0]).withStyle(ChatFormatting.WHITE));
        if (((SecurityStationBlockEntity)this.te).getRebootTime() > 0) {
            text.add((Component)Component.literal((String)"  ").append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.rebooting", new Object[0])).withStyle(ChatFormatting.DARK_RED));
        } else if (((SecurityStationBlockEntity)this.te).isHacked()) {
            text.add((Component)Component.literal((String)"  ").append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.hackedBy", new Object[0])).withStyle(ChatFormatting.DARK_RED));
            for (GameProfile hacker : ((SecurityStationBlockEntity)this.te).hackedUsers) {
                text.add((Component)Component.literal((String)"  ").append((Component)Symbols.bullet()).append(hacker.getName()).withStyle(ChatFormatting.RED));
            }
        } else if (((SecurityStationBlockEntity)this.te).hasValidNetwork()) {
            text.add((Component)Component.literal((String)"  ").append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.secure", new Object[0])).withStyle(ChatFormatting.GREEN));
        } else {
            text.add((Component)Component.literal((String)"  -").withStyle(ChatFormatting.GRAY));
            return text;
        }
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityLevel", new Object[0]).withStyle(ChatFormatting.WHITE));
        text.add((Component)Component.literal((String)"  ").append((Component)Component.literal((String)("L" + ((SecurityStationBlockEntity)this.te).getSecurityLevel()))).withStyle(ChatFormatting.BLACK));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.detectChance", new Object[0]).withStyle(ChatFormatting.WHITE));
        text.add((Component)Component.literal((String)"  ").append((Component)Component.literal((String)(((SecurityStationBlockEntity)this.te).getDetectionChance() + "%"))).withStyle(ChatFormatting.BLACK));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityRange", new Object[0]).withStyle(ChatFormatting.WHITE));
        text.add((Component)Component.literal((String)"  ").append((Component)Component.literal((String)(((SecurityStationBlockEntity)this.te).getRange() * 2 + 1 + "m\u00b2"))).withStyle(ChatFormatting.BLACK));
        return text;
    }

    private List<Component> getAccessText() {
        ArrayList<Component> textList = new ArrayList<Component>();
        textList.add((Component)Component.empty());
        textList.add((Component)Component.empty());
        boolean first = true;
        List<String> names = ((SecurityStationBlockEntity)this.te).sharedUsers.stream().map(GameProfile::getName).sorted().toList();
        for (String name : names) {
            Object str = first ? name + " \u2654" : name;
            textList.add((Component)Symbols.bullet().append((String)str).withStyle(first ? ChatFormatting.YELLOW : ChatFormatting.WHITE));
            first = false;
        }
        return textList;
    }

    private void updateUserList() {
        if (this.sharedUserList != null) {
            for (WidgetButtonExtended button : this.sharedUserList) {
                this.accessStat.removeSubWidget((AbstractWidget)button);
            }
        }
        this.sharedUserList = new ArrayList<WidgetButtonExtended>();
        int n = 0;
        List<String> names = ((SecurityStationBlockEntity)this.te).sharedUsers.stream().map(GameProfile::getName).sorted().toList();
        for (String name : names) {
            Objects.requireNonNull(this.font);
            WidgetButtonExtended button = new WidgetButtonExtended(24, 30 + n * (9 + 1), this.font.width(name), 8, (Component)Component.empty(), b -> {}).setVisible(false).setInvisibleHoverColor(-2130771968).withTag("remove:" + name);
            button.setInvisibleHoverColor(-2130771968);
            button.setVisible(false);
            this.accessStat.addSubWidget((AbstractWidget)button);
            this.sharedUserList.add(button);
            button.visible = !name.equals(ClientUtils.getClientPlayer().getGameProfile().getName());
            ++n;
        }
    }

    public static void reinitConnectionRendering() {
        if (Minecraft.getInstance().screen instanceof SecurityStationInventoryScreen) {
            ((SecurityStationInventoryScreen)Minecraft.getInstance().screen).reInitBG = true;
        }
    }
}

