/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetList;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.utility.TagWorkbenchBlockEntity;
import me.desht.pneumaticcraft.common.inventory.TagWorkbenchMenu;
import me.desht.pneumaticcraft.common.item.TagFilterItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TagWorkbenchScreen
extends AbstractPneumaticCraftContainerScreen<TagWorkbenchMenu, TagWorkbenchBlockEntity> {
    private static final int AVAILABLE_X = 9;
    private static final int SELECTED_X = 123;
    private static final int LIST_HEIGHT = 126;
    private static final int LIST_WIDTH = 98;
    private static final int LIST_Y = 41;
    private Item lastItem = null;
    private ItemStack lastPaperStack = ItemStack.EMPTY;
    private WidgetButtonExtended addButton;
    private WidgetButtonExtended removeButton;
    private WidgetList<ResourceLocation> availableList;
    private WidgetList<ResourceLocation> selectedList;
    private WidgetButtonExtended writeButton;

    public TagWorkbenchScreen(TagWorkbenchMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.imageWidth = 234;
        this.imageHeight = 256;
    }

    @Override
    public void init() {
        super.init();
        this.writeButton = new WidgetButtonExtended(this.leftPos + 162, this.topPos + 16, 20, 20, (Component)Component.empty(), b -> this.writeTags()).setRenderStacks(new ItemStack((ItemLike)Items.WRITABLE_BOOK)).setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.tag_workbench.write_button", new Object[0]));
        this.addRenderableWidget((GuiEventListener)this.writeButton);
        this.addButton = new WidgetButtonExtended(this.leftPos + 108, this.topPos + 90, 13, 13, "\u25b6", b -> this.addAvailable());
        this.addRenderableWidget((GuiEventListener)this.addButton);
        this.removeButton = new WidgetButtonExtended(this.leftPos + 108, this.topPos + 106, 13, 13, "\u25c0", b -> this.removeSelected());
        this.addRenderableWidget((GuiEventListener)this.removeButton);
        this.availableList = new WidgetList(this.leftPos + 9, this.topPos + 41, 98, 126, this::onSelected);
        this.addRenderableWidget((GuiEventListener)this.availableList);
        this.selectedList = new WidgetList(this.leftPos + 123, this.topPos + 41, 98, 126, this::onSelected);
        this.addRenderableWidget((GuiEventListener)this.selectedList);
    }

    private void writeTags() {
        List l = this.selectedList.getLines().stream().map(ResourceLocation::toString).collect(Collectors.toList());
        NetworkHandler.sendToServer(new PacketGuiButton("write:" + String.join((CharSequence)",", l)));
        this.selectedList.clear();
    }

    private void onSelected(WidgetList<ResourceLocation> w) {
        if (w == this.availableList) {
            this.selectedList.unselectAll();
            if (w.isDoubleClicked()) {
                this.addAvailable();
            }
        } else if (w == this.selectedList) {
            this.availableList.unselectAll();
            if (w.isDoubleClicked()) {
                this.removeSelected();
            }
        }
    }

    private void addAvailable() {
        ResourceLocation rl = this.availableList.getSelectedLine();
        if (rl != null && !this.selectedList.contains(rl)) {
            this.selectedList.add(rl);
        }
    }

    private void removeSelected() {
        ResourceLocation rl = this.selectedList.getSelectedLine();
        if (rl != null) {
            this.selectedList.removeSelected();
        }
    }

    @Override
    public void containerTick() {
        ItemStack stack1;
        super.containerTick();
        ItemStack stack = ((TagWorkbenchMenu)this.menu).getSlot(0).getItem();
        if (stack.getItem() != this.lastItem) {
            this.availableList.clear();
            stack.getItem().builtInRegistryHolder().tags().forEach(tagKey -> this.availableList.add(tagKey.location()));
            this.availableList.unselectAll();
            this.lastItem = stack.getItem();
        }
        if (!ItemStack.matches((ItemStack)(stack1 = ((TagWorkbenchMenu)this.menu).getSlot(1).getItem()), (ItemStack)this.lastPaperStack)) {
            if (stack1.getItem() == ModItems.TAG_FILTER.get()) {
                Set<TagKey<Item>> s = TagFilterItem.getConfiguredTagList(stack1);
                s.addAll(this.selectedList.getLines().stream().map(rl -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl)).toList());
                this.selectedList.clear();
                s.forEach(rl -> this.selectedList.add(rl.location()));
            }
            this.selectedList.unselectAll();
            this.lastPaperStack = stack1.copy();
        }
        this.addButton.active = this.availableList.getSelectedLine() != null;
        this.removeButton.active = this.selectedList.getSelectedLine() != null;
        this.writeButton.active = this.selectedList.size() > 0 && (!((TagWorkbenchMenu)this.menu).getSlot(1).getItem().isEmpty() || !((TagWorkbenchMenu)this.menu).getSlot(2).getItem().isEmpty());
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_TAG_WORKBENCH;
    }
}

