/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.PNCForgeSlider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorColors;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorColoringScreen
extends AbstractPneumaticCraftScreen {
    private boolean needSave = false;
    private final int[][] origColors = new int[4][SelectorType.values().length];
    private final int[][] colors = new int[4][SelectorType.values().length];
    private final List<SelectorButton> selectorButtons = new ArrayList<SelectorButton>();
    private final Map<ColorComponent, RGBSlider> rgbSliders = new EnumMap<ColorComponent, RGBSlider>(ColorComponent.class);
    private WidgetButtonExtended saveButton;
    private WidgetLabel scrollLabel;
    private static EquipmentSlot selectedSlot = EquipmentSlot.HEAD;
    private static SelectorType selectorType = SelectorType.PRIMARY;

    public ArmorColoringScreen() {
        super((Component)Component.literal((String)"Colors"));
        Player player = ClientUtils.getClientPlayer();
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ItemStack stack = player.getItemBySlot(slot);
            int idx = slot.getIndex();
            Item item = stack.getItem();
            if (!(item instanceof PneumaticArmorItem)) continue;
            PneumaticArmorItem armor = (PneumaticArmorItem)item;
            int n = armor.getColor(stack);
            this.colors[idx][0] = n;
            this.origColors[idx][0] = n;
            int n2 = armor.getSecondaryColor(stack);
            this.colors[idx][1] = n2;
            this.origColors[idx][1] = n2;
            int n3 = armor.getEyepieceColor(stack);
            this.colors[idx][2] = n3;
            this.origColors[idx][2] = n3;
        }
    }

    @Override
    public void init() {
        super.init();
        this.xSize = this.width;
        this.ySize = this.height;
        this.selectorButtons.clear();
        for (EquipmentSlot equipmentSlot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (SelectorType type : SelectorType.values()) {
                this.selectorButtons.add(new SelectorButton(this, equipmentSlot, type));
            }
        }
        this.selectorButtons.forEach(x$0 -> {
            SelectorButton cfr_ignored_0 = (SelectorButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
        for (SelectorType selectorType : SelectorType.values()) {
            this.addRenderableWidget((GuiEventListener)new WidgetLabel(87 + selectorType.xOffset, 30, (Component)Component.literal((String)selectorType.label), -1).setAlignment(WidgetLabel.Alignment.CENTRE));
        }
        this.rgbSliders.clear();
        for (ColorComponent colorComponent : ColorComponent.values()) {
            this.rgbSliders.put(colorComponent, new RGBSlider(this, colorComponent, 43, 165 + colorComponent.yOffset, 128, 10, this.getCurrentColor() >> colorComponent.bitShift & 0xFF));
        }
        this.rgbSliders.values().forEach(x$0 -> {
            RGBSlider cfr_ignored_0 = (RGBSlider)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.scrollLabel = new WidgetLabel(107, 210, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.colors.scrollWheel", new Object[0]), -6250336).setAlignment(WidgetLabel.Alignment.CENTRE);
        this.addRenderableWidget((GuiEventListener)this.scrollLabel);
        this.scrollLabel.visible = false;
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(85, 130, 40, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.copy", new Object[0]), b -> this.copyColorsToOtherPieces()).setTooltipKey("pneumaticcraft.armor.gui.misc.colors.copyTooltip"));
        this.saveButton = (WidgetButtonExtended)this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(43, this.height - 30, 40, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.save", new Object[0]), b -> this.saveChanges()));
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(88, this.height - 30, 40, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.reset", new Object[0]), b -> this.resetColors(Screen.hasShiftDown())).setTooltipKey("pneumaticcraft.armor.gui.misc.colors.resetTooltip"));
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(133, this.height - 30, 40, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.cancel", new Object[0]), b -> this.onClose()));
        MutableComponent mutableComponent = PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.colors.showEnchantGlint", new Object[0]);
        int n = this.width - this.font.width((FormattedText)mutableComponent) - 40;
        Objects.requireNonNull(this.font);
        this.addRenderableWidget((GuiEventListener)new WidgetCheckBox(n, this.height - 9 - 10, -1, (Component)mutableComponent, b -> ConfigHelper.setShowEnchantGlint(b.checked)).setChecked((Boolean)ConfigHelper.client().armor.showEnchantGlint.get()));
    }

    private void setCurrentColor(int newCol) {
        this.colors[ArmorColoringScreen.selectedSlot.getIndex()][ArmorColoringScreen.selectorType.ordinal()] = newCol;
    }

    private int getCurrentColor() {
        return this.colors[selectedSlot.getIndex()][selectorType.ordinal()];
    }

    private void saveChanges() {
        ClientUtils.getClientPlayer().playSound((SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), 1.0f, 1.0f);
        NetworkHandler.sendToServer(PacketUpdateArmorColors.create());
        this.needSave = false;
    }

    private void copyColorsToOtherPieces() {
        for (int i = 0; i < this.colors.length; ++i) {
            if (i != selectedSlot.getIndex()) {
                this.colors[i][ArmorColoringScreen.selectorType.ordinal()] = this.getCurrentColor();
            }
            this.updateClientSideArmor(EquipmentSlot.byTypeAndIndex((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i));
        }
    }

    private void resetColors(boolean factorySettings) {
        for (int i = 0; i < this.colors.length; ++i) {
            for (SelectorType type : SelectorType.values()) {
                this.colors[i][type.ordinal()] = factorySettings ? type.defaultColor : this.origColors[i][type.ordinal()];
            }
            this.updateClientSideArmor(EquipmentSlot.byTypeAndIndex((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i));
        }
        this.updateSliders();
        this.needSave = factorySettings;
    }

    private void updateClientSideArmor(EquipmentSlot slot) {
        Player player = ClientUtils.getClientPlayer();
        ItemStack stack = player.getItemBySlot(slot);
        Item item = stack.getItem();
        if (item instanceof PneumaticArmorItem) {
            PneumaticArmorItem armor = (PneumaticArmorItem)item;
            armor.setColor(stack, this.colors[slot.getIndex()][SelectorType.PRIMARY.ordinal()]);
            armor.setSecondaryColor(stack, this.colors[slot.getIndex()][SelectorType.SECONDARY.ordinal()]);
            if (slot == EquipmentSlot.HEAD) {
                armor.setEyepieceColor(stack, this.colors[slot.getIndex()][SelectorType.EYEPIECE.ordinal()]);
            }
        }
        for (EquipmentSlot slot2 : EquipmentSlot.values()) {
            HUDHandler.getInstance().updateOverlayColors(slot2);
        }
        this.selectorButtons.get((3 - slot.getIndex()) * SelectorType.values().length).setRenderStacks(stack);
        this.needSave = true;
    }

    private void updateSliders() {
        for (ColorComponent color : ColorComponent.values()) {
            this.updateSlider(this.rgbSliders.get((Object)color), (this.getCurrentColor() & color.mask) >> color.bitShift);
        }
    }

    private void updateSlider(RGBSlider s, int val) {
        s.setValue(val);
    }

    @Override
    public void tick() {
        super.tick();
        this.selectorButtons.forEach(b -> {
            b.active = selectorType != b.selectorType || selectedSlot != b.slot;
        });
        this.saveButton.active = this.needSave;
        this.scrollLabel.visible = this.rgbSliders.values().stream().anyMatch(AbstractWidget::isHoveredOrFocused);
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        double scaleFactor = Minecraft.getInstance().getWindow().getGuiScale();
        int scale = (int)((double)Minecraft.getInstance().getWindow().getScreenHeight() / (scaleFactor * 3.0));
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(this.width / 2), (int)0, (int)this.width, (int)this.height, (int)scale, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)ClientUtils.getClientPlayer());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        for (RGBSlider slider : this.rgbSliders.values()) {
            if (!slider.isHoveredOrFocused()) continue;
            double val = Math.signum(deltaY);
            if (Screen.hasShiftDown()) {
                val *= 10.0;
            }
            int newVal = Mth.clamp((int)((int)((double)slider.getValueInt() + val)), (int)0, (int)255);
            if (slider.getValueInt() != newVal) {
                this.updateSlider(slider, newVal);
                slider.applyValue();
            }
            return true;
        }
        return false;
    }

    public void onClose() {
        Objects.requireNonNull(this.minecraft).setScreen((Screen)ArmorMainScreen.getInstance());
    }

    public void removed() {
        if (this.needSave) {
            this.resetColors(false);
        }
        super.removed();
    }

    public static enum SelectorType {
        PRIMARY(0, "1", -6908266),
        SECONDARY(22, "2", -4144960),
        EYEPIECE(44, "E", -16733696);

        private final int xOffset;
        private final String label;
        private final int defaultColor;

        private SelectorType(int xOffset, String label, int defaultColor) {
            this.xOffset = xOffset;
            this.label = label;
            this.defaultColor = defaultColor;
        }

        boolean showButton(EquipmentSlot slot) {
            return slot == EquipmentSlot.HEAD || this != EYEPIECE;
        }

        public int getDefaultColor() {
            return this.defaultColor;
        }
    }

    private static enum ColorComponent {
        RED(16, ChatFormatting.RED + "R: ", 0),
        GREEN(8, ChatFormatting.GREEN + "G: ", 15),
        BLUE(0, ChatFormatting.BLUE + "B: ", 30);

        private final int mask;
        private final int bitShift;
        private final String prefix;
        private final int yOffset;

        private ColorComponent(int bitShift, String prefix, int yOffset) {
            this.mask = 255 << bitShift;
            this.bitShift = bitShift;
            this.prefix = prefix;
            this.yOffset = yOffset;
        }
    }

    private static class SelectorButton
    extends WidgetButtonExtended {
        private final ArmorColoringScreen gui;
        private final EquipmentSlot slot;
        private final SelectorType selectorType;

        public SelectorButton(ArmorColoringScreen gui, EquipmentSlot slot, SelectorType selectorType) {
            super(78 + selectorType.xOffset, 41 + (3 - slot.getIndex()) * 22, 18, 18, "", b -> {
                selectedSlot = slot;
                ArmorColoringScreen.selectorType = selectorType;
                gui.updateSliders();
            });
            this.gui = gui;
            this.slot = slot;
            this.selectorType = selectorType;
            this.visible = selectorType.showButton(slot) && PneumaticArmorItem.isPneumaticArmorPiece(ClientUtils.getClientPlayer(), slot);
            this.setHighlightWhenInactive(true);
            if (selectorType == SelectorType.PRIMARY) {
                this.setRenderStacks(ClientUtils.getClientPlayer().getItemBySlot(slot));
                this.setIconPosition(WidgetButtonExtended.IconPosition.LEFT);
            }
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            int x = this.getX();
            int y = this.getY();
            graphics.fill(x + 3, y + 3, x + 14, y + 14, this.gui.colors[this.slot.getIndex()][this.selectorType.ordinal()]);
            graphics.hLine(x + 4, x + 14, y + 14, -14671840);
            graphics.vLine(x + 14, y + 3, y + 14, -14671840);
        }
    }

    private static class RGBSlider
    extends PNCForgeSlider {
        private final ArmorColoringScreen gui;
        private final ColorComponent color;

        public RGBSlider(ArmorColoringScreen gui, ColorComponent color, int xPos, int yPos, int width, int height, double currentVal) {
            super(xPos, yPos, width, height, (Component)Component.literal((String)color.prefix), (Component)Component.empty(), 0.0, 255.0, currentVal, true, null);
            this.gui = gui;
            this.color = color;
        }

        public ColorComponent getColor() {
            return this.color;
        }

        @Override
        protected void applyValue() {
            ColorComponent component = this.getColor();
            this.gui.setCurrentColor(this.gui.getCurrentColor() & ~component.mask | this.getValueInt() << component.bitShift);
            this.gui.updateClientSideArmor(selectedSlot);
            super.applyValue();
        }
    }
}

