/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.ITickableWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.PNCForgeSlider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.CoreComponentsClientHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

public class ArmorStatMoveScreen
extends AbstractPneumaticCraftScreen {
    private final IGuiAnimatedStat movedStat;
    private final IArmorUpgradeClientHandler<?> renderHandler;
    private boolean clicked = false;
    private final List<IGuiAnimatedStat> otherStats = new ArrayList<IGuiAnimatedStat>();
    private final List<Component> helpText = new ArrayList<Component>();
    private final ResourceLocation statID;
    private WidgetCheckBox snapToGrid;
    private PNCForgeSlider gridSlider;
    private static boolean snap = false;
    private static int gridSize = 4;

    public ArmorStatMoveScreen(IArmorUpgradeClientHandler<?> renderHandler) {
        this(renderHandler, renderHandler.getID(), renderHandler.getAnimatedStat());
    }

    public ArmorStatMoveScreen(IArmorUpgradeClientHandler<?> renderHandler, ResourceLocation statID, @Nonnull IGuiAnimatedStat movedStat) {
        super((Component)Component.literal((String)"Move Gui"));
        this.movedStat = movedStat;
        this.renderHandler = renderHandler;
        this.statID = statID;
        movedStat.openStat();
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            List<IArmorUpgradeClientHandler<?>> renderHandlers = ClientArmorRegistry.getInstance().getHandlersForSlot(slot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                IGuiAnimatedStat stat;
                IArmorUpgradeClientHandler<?> upgradeRenderHandler = renderHandlers.get(i);
                if (!commonArmorHandler.isUpgradeInserted(slot, i) || !commonArmorHandler.isUpgradeEnabled(slot, i) || (stat = upgradeRenderHandler.getAnimatedStat()) == null || stat == movedStat) continue;
                this.otherStats.add(stat);
            }
        }
        CoreComponentsClientHandler mainOptions = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.coreComponentsHandler, CoreComponentsClientHandler.class);
        IGuiAnimatedStat testMessageStat = mainOptions.getTestMessageStat();
        if (movedStat != testMessageStat) {
            this.otherStats.add(testMessageStat);
        }
    }

    @Override
    public void init() {
        super.init();
        this.snapToGrid = new WidgetCheckBox(10, this.height * 3 / 5, 0xC0C0C0, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.snapToGrid", new Object[0]));
        this.snapToGrid.setX((this.width - this.snapToGrid.getWidth()) / 2);
        this.snapToGrid.checked = snap;
        this.addRenderableWidget((GuiEventListener)this.snapToGrid);
        this.gridSlider = new PNCForgeSlider(this.snapToGrid.getX(), this.snapToGrid.getY() + 12, this.snapToGrid.getWidth(), 10, (Component)Component.empty(), (Component)Component.empty(), 1.0, 12.0, gridSize, true, null);
        this.addRenderableWidget((GuiEventListener)this.gridSlider);
        MutableComponent msg = Component.translatable((String)"pneumaticcraft.armor.gui.misc.reset");
        this.addRenderableWidget((GuiEventListener)new WidgetButtonExtended(this.gridSlider.getX(), this.gridSlider.getY() + 20, this.font.width((FormattedText)msg) + 20, 20, (Component)msg, b -> this.resetStatPosition()));
    }

    private void resetStatPosition() {
        Window window = Objects.requireNonNull(this.minecraft).getWindow();
        StatPanelLayout defLayout = this.renderHandler.getDefaultStatLayout();
        this.movedStat.setBaseX((int)(defLayout.x() * (float)window.getGuiScaledWidth()));
        this.movedStat.setBaseY((int)(defLayout.y() * (float)window.getGuiScaledHeight()));
        this.movedStat.setLeftSided(defLayout.expandsLeft());
        this.renderHandler.onResolutionChanged();
        this.save();
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.movedStat.getBounds().contains((int)mouseX, (int)mouseY)) {
            if (mouseButton == 2) {
                this.movedStat.setLeftSided(!this.movedStat.isLeftSided());
                if (this.movedStat.isLeftSided() && this.movedStat.getBaseX() < 10) {
                    this.movedStat.setBaseX(10);
                } else if (!this.movedStat.isLeftSided() && this.movedStat.getBaseX() > this.width - 10) {
                    this.movedStat.setBaseX(this.width - 10);
                }
                this.save();
            } else if (mouseButton < 2) {
                this.clicked = true;
                this.reposition(this.movedStat, mouseX, mouseY);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.clicked) {
            if (mouseButton == 0 || mouseButton == 1) {
                this.reposition(this.movedStat, mouseX, mouseY);
            }
            this.save();
            this.clicked = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (this.clicked) {
            this.reposition(this.movedStat, mouseX, mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, dx, dy);
    }

    private void reposition(IGuiAnimatedStat stat, double x, double y) {
        if (snap) {
            x -= x % (double)gridSize;
            y -= y % (double)gridSize;
        }
        stat.setBaseX((int)x);
        stat.setBaseY((int)y);
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)ArmorMainScreen.getInstance());
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        Rect2i bounds = GuiUtils.showPopupHelpScreen(graphics, this, this.font, this.helpText);
        this.snapToGrid.setY(bounds.getY() + bounds.getHeight() + 15);
        this.gridSlider.setY(this.snapToGrid.getY() + 12);
        super.render(graphics, x, y, partialTicks);
        this.movedStat.renderStat(graphics, -1, -1, partialTicks);
        this.otherStats.forEach(stat -> {
            int c = stat.getBackgroundColor();
            stat.setBackgroundColor(0x30606060);
            stat.renderStat(graphics, -1, -1, partialTicks);
            stat.setBackgroundColor(c);
        });
    }

    @Override
    public void tick() {
        super.tick();
        snap = this.snapToGrid.checked;
        gridSize = this.gridSlider.getValueInt();
        this.gridSlider.visible = snap;
        this.movedStat.tickWidget();
        this.otherStats.forEach(ITickableWidget::tickWidget);
        if (this.helpText.isEmpty()) {
            this.helpText.add((Component)PneumaticCraftUtils.xlate(IArmorUpgradeHandler.getStringKey(this.renderHandler.getID()), new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}));
            this.helpText.add((Component)Component.empty());
            this.helpText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.moveStat.move", new Object[0]));
            this.helpText.add((Component)Component.literal((String)"<REPLACEME>"));
        }
        this.helpText.set(3, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.moveStat.expand" + (this.movedStat.isLeftSided() ? "Left" : "Right"), new Object[0]));
    }

    private void save() {
        Window window = Objects.requireNonNull(this.minecraft).getWindow();
        ArmorHUDLayout.INSTANCE.updateLayout(this.statID, (float)this.movedStat.getBaseX() / (float)window.getGuiScaledWidth(), (float)this.movedStat.getBaseY() / (float)window.getGuiScaledHeight(), this.movedStat.isLeftSided(), false);
    }
}

