/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.options;

import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.client.gui.ItemSearcherScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.SearchClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateSearchItem;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SearchOptions
extends IOptionPage.SimpleOptionPage<SearchClientHandler> {
    private static ItemSearcherScreen searchGui;
    private final Player player;

    public SearchOptions(IGuiScreen screen, SearchClientHandler upgradeHandler) {
        super(screen, upgradeHandler);
        this.player = Minecraft.getInstance().player;
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        gui.addWidget(new WidgetButtonExtended(30, 55, 150, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.searchItem", new Object[0]), b -> this.openSearchGui()));
        gui.addWidget(ClientArmorRegistry.getInstance().makeStatMoveButton(30, this.settingsYposition() + 12, (IArmorUpgradeClientHandler<?>)this.getClientUpgradeHandler()));
        if (searchGui != null && !this.player.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            Item oldSearchedItem;
            ItemStack helmetStack = ClientUtils.getWornArmor(EquipmentSlot.HEAD);
            Item newSearchedItem = searchGui.getSearchStack().getItem();
            if (newSearchedItem != (oldSearchedItem = PneumaticArmorItem.getSearchedItem(helmetStack))) {
                PneumaticArmorItem.setSearchedItem(helmetStack, newSearchedItem);
                NetworkHandler.sendToServer(new PacketUpdateSearchItem(newSearchedItem));
            }
        }
    }

    private void openSearchGui() {
        ClientUtils.openContainerGui(ModMenuTypes.ITEM_SEARCHER.get(), (Component)Component.literal((String)"Search"));
        if (Minecraft.getInstance().screen instanceof ItemSearcherScreen) {
            Item searchItem;
            searchGui = (ItemSearcherScreen)Minecraft.getInstance().screen;
            if (!this.player.getItemBySlot(EquipmentSlot.HEAD).isEmpty() && (searchItem = PneumaticArmorItem.getSearchedItem(this.player.getItemBySlot(EquipmentSlot.HEAD))) != null) {
                searchGui.setSearchStack(new ItemStack((ItemLike)searchItem));
            }
        }
    }

    @Override
    public boolean displaySettingsHeader() {
        return true;
    }
}

