/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.InventorySearcherScreen;
import me.desht.pneumaticcraft.client.gui.ItemSearcherScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.AbstractProgWidgetScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRadioButton;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;

public class ProgWidgetItemFilterScreen
extends AbstractProgWidgetScreen<ProgWidgetItemFilter> {
    private ItemSearcherScreen itemSearchGui;
    private InventorySearcherScreen invSearchGui;
    private WidgetCheckBox checkBoxUseDurability;
    private WidgetCheckBox checkBoxUseNBT;
    private WidgetCheckBox checkBoxUseModSimilarity;
    private WidgetCheckBox checkBoxMatchBlock;
    private WidgetComboBox variableField;
    private WidgetRadioButton itemRad;
    private WidgetRadioButton varRad;
    private WidgetButtonExtended itemSearchButton;
    private WidgetButtonExtended invSearchButton;
    private WidgetLabel itemLabel;
    private WidgetLabel variableLabel;
    public int itemX = -1;

    public ProgWidgetItemFilterScreen(ProgWidgetItemFilter widget, ProgrammerScreen guiProgrammer) {
        super(widget, guiProgrammer);
    }

    @Override
    public void init() {
        super.init();
        boolean advancedMode = ConfigHelper.client().general.programmerDifficulty.get() == IProgWidget.WidgetDifficulty.ADVANCED;
        boolean useItemFilter = ((ProgWidgetItemFilter)this.progWidget).getVariable().isEmpty() || !advancedMode;
        this.itemRad = new WidgetRadioButton(this.guiLeft + 8, this.guiTop + 22, 0x404040, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.itemLabel", new Object[0]));
        this.varRad = new WidgetRadioButton(this.guiLeft + 8, this.guiTop + 34, 0x404040, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.variableLabel", new Object[0]));
        WidgetRadioButton.Builder.create().addRadioButton(this.itemRad, useItemFilter).addRadioButton(this.varRad, !useItemFilter).build(x$0 -> {
            WidgetRadioButton cfr_ignored_0 = (WidgetRadioButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.itemRad.visible = this.varRad.visible = advancedMode;
        this.itemLabel = new WidgetLabel(this.guiLeft + 8, this.guiTop + 55, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.itemLabel", new Object[0]).append(":"));
        this.addRenderableWidget((GuiEventListener)this.itemLabel);
        this.itemSearchButton = new WidgetButtonExtended(this.guiLeft + this.itemLabel.getWidth() + 35, this.guiTop + 50, 20, 20, (Component)Component.empty(), b -> this.openSearcher()).setRenderStacks(new ItemStack((ItemLike)Items.COMPASS)).setTooltipKey("pneumaticcraft.gui.misc.searchItem");
        this.addRenderableWidget((GuiEventListener)this.itemSearchButton);
        this.invSearchButton = new WidgetButtonExtended(this.itemSearchButton.getX() + 25, this.guiTop + 50, 20, 20, (Component)Component.empty(), b -> this.openInventorySearcher()).setRenderStacks(new ItemStack((ItemLike)Items.CHEST)).setTooltipKey("pneumaticcraft.gui.misc.searchInventory");
        this.addRenderableWidget((GuiEventListener)this.invSearchButton);
        this.variableLabel = new WidgetLabel(this.guiLeft + 8, this.guiTop + 53, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.variableLabel", new Object[0]).append(":"));
        this.addRenderableWidget((GuiEventListener)this.variableLabel);
        int n = this.guiLeft + 12 + this.variableLabel.getWidth();
        Objects.requireNonNull(this.font);
        this.variableField = new WidgetComboBox(this.font, n, this.guiTop + 52, 80, 9 + 3).setElements(((ProgrammerBlockEntity)this.guiProgrammer.te).getAllVariables());
        this.addRenderableWidget((GuiEventListener)this.variableField);
        this.variableField.setMaxLength(64);
        this.variableField.setValue(((ProgWidgetItemFilter)this.progWidget).getVariable());
        this.checkBoxUseDurability = ((WidgetCheckBox)new WidgetCheckBox(this.guiLeft + 8, this.guiTop + 96, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchDurability", new Object[0]), b -> {
            ((ProgWidgetItemFilter)this.progWidget).useItemDurability = b.checked;
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchDurability.tooltip")).setChecked(((ProgWidgetItemFilter)this.progWidget).useItemDurability);
        this.addRenderableWidget((GuiEventListener)this.checkBoxUseDurability);
        this.checkBoxUseNBT = ((WidgetCheckBox)new WidgetCheckBox(this.guiLeft + 8, this.guiTop + 108, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchNBT", new Object[0]), b -> {
            ((ProgWidgetItemFilter)this.progWidget).useNBT = b.checked;
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchNBT.tooltip")).setChecked(((ProgWidgetItemFilter)this.progWidget).useNBT);
        this.addRenderableWidget((GuiEventListener)this.checkBoxUseNBT);
        this.checkBoxUseModSimilarity = ((WidgetCheckBox)new WidgetCheckBox(this.guiLeft + 8, this.guiTop + 120, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchModId", new Object[0]), b -> {
            ((ProgWidgetItemFilter)this.progWidget).useModSimilarity = b.checked;
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchModId.tooltip")).setChecked(((ProgWidgetItemFilter)this.progWidget).useModSimilarity);
        this.addRenderableWidget((GuiEventListener)this.checkBoxUseModSimilarity);
        this.checkBoxMatchBlock = ((WidgetCheckBox)new WidgetCheckBox(this.guiLeft + 8, this.guiTop + 132, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchBlockstate", new Object[0]), b -> {
            ((ProgWidgetItemFilter)this.progWidget).matchBlock = b.checked;
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchBlockstate.tooltip")).setChecked(((ProgWidgetItemFilter)this.progWidget).matchBlock);
        this.addRenderableWidget((GuiEventListener)this.checkBoxMatchBlock);
        if (this.itemSearchGui != null) {
            ((ProgWidgetItemFilter)this.progWidget).setFilter(this.itemSearchGui.getSearchStack());
        }
        this.itemSearchGui = null;
        if (this.invSearchGui != null) {
            ((ProgWidgetItemFilter)this.progWidget).setFilter(this.invSearchGui.getSearchStack());
        }
        this.invSearchGui = null;
    }

    private void openSearcher() {
        ClientUtils.openContainerGui(ModMenuTypes.ITEM_SEARCHER.get(), (Component)Component.literal((String)"Search"));
        if (this.minecraft.screen instanceof ItemSearcherScreen) {
            this.itemSearchGui = (ItemSearcherScreen)this.minecraft.screen;
            this.itemSearchGui.setSearchStack(((ProgWidgetItemFilter)this.progWidget).getFilter());
        }
    }

    private void openInventorySearcher() {
        ClientUtils.openContainerGui(ModMenuTypes.INVENTORY_SEARCHER.get(), (Component)Component.literal((String)"Search"));
        if (this.minecraft.screen instanceof InventorySearcherScreen) {
            this.invSearchGui = (InventorySearcherScreen)this.minecraft.screen;
            this.invSearchGui.setSearchStack(((ProgWidgetItemFilter)this.progWidget).getFilter());
        }
    }

    public void setFilterStack(ItemStack stack) {
        ((ProgWidgetItemFilter)this.progWidget).setFilter(stack);
    }

    @Override
    public void tick() {
        super.tick();
        this.itemSearchButton.visible = this.itemRad.isChecked();
        this.invSearchButton.visible = this.itemRad.isChecked();
        this.variableLabel.visible = this.varRad.isChecked() && ConfigHelper.client().general.programmerDifficulty.get() == IProgWidget.WidgetDifficulty.ADVANCED;
        this.itemLabel.visible = !this.variableLabel.visible;
        this.variableField.visible = this.varRad.isChecked() && ConfigHelper.client().general.programmerDifficulty.get() == IProgWidget.WidgetDifficulty.ADVANCED;
        this.itemX = this.itemRad.isChecked() ? this.itemLabel.getWidth() + 9 : -1;
        ItemStack filter = ((ProgWidgetItemFilter)this.progWidget).getRawFilter();
        this.checkBoxUseDurability.active = this.varRad.isChecked() || filter.getMaxDamage() > 0 && !this.checkBoxUseModSimilarity.checked;
        this.checkBoxUseNBT.active = this.varRad.isChecked() || !filter.isEmpty() && !this.checkBoxUseModSimilarity.checked && !this.checkBoxMatchBlock.checked;
        this.checkBoxUseModSimilarity.active = this.varRad.isChecked() || !filter.isEmpty() && !this.checkBoxMatchBlock.checked;
        MutableComponent msg = PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchModId", new Object[0]);
        String modName = StringUtils.abbreviate((String)ModNameCache.getModName(filter.getItem()), (int)22);
        this.checkBoxUseModSimilarity.setMessage((Component)(filter.isEmpty() ? msg : msg.append(" (" + modName + ")")));
        this.checkBoxMatchBlock.active = this.varRad.isChecked() || filter.getItem() instanceof BlockItem && !this.checkBoxUseNBT.checked && !this.checkBoxUseModSimilarity.checked;
    }

    @Override
    public void removed() {
        ((ProgWidgetItemFilter)this.progWidget).setVariable(this.variableField.getValue());
        super.removed();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.itemRad.isChecked()) {
            graphics.blit(this.getTexture(), this.guiLeft + this.itemX, this.guiTop + 51, 186, 0, 18, 18);
            if (!((ProgWidgetItemFilter)this.progWidget).getRawFilter().isEmpty()) {
                graphics.renderItem(((ProgWidgetItemFilter)this.progWidget).getRawFilter(), this.guiLeft + this.itemX + 1, this.guiTop + 52);
                if (mouseX >= this.guiLeft + this.itemX && mouseX <= this.guiLeft + this.itemX + 16 && mouseY >= this.guiTop + 51 && mouseY <= this.guiTop + 67) {
                    graphics.renderTooltip(this.font, ((ProgWidgetItemFilter)this.progWidget).getRawFilter(), mouseX, mouseY);
                }
            }
        }
    }
}

