/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.AbstractProgWidgetScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class ProgWidgetLiquidFilterScreen
extends AbstractProgWidgetScreen<ProgWidgetLiquidFilter> {
    private static final int GRID_WIDTH = 8;
    private static final int GRID_HEIGHT = 6;
    private WidgetFluidFilter mainFilter;
    private WidgetVerticalScrollbar scrollbar;
    private WidgetTextField searchField;
    private int lastScroll;
    private final List<WidgetFluidFilter> visibleFluidWidgets = new ArrayList<WidgetFluidFilter>();
    private int textTimer = 0;

    public ProgWidgetLiquidFilterScreen(ProgWidgetLiquidFilter widget, ProgrammerScreen guiProgrammer) {
        super(widget, guiProgrammer);
        this.xSize = 176;
        this.ySize = 166;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_ITEM_SEARCHER;
    }

    @Override
    public void init() {
        super.init();
        this.mainFilter = new WidgetFluidFilter(this.guiLeft + 148, this.guiTop + 12, ((ProgWidgetLiquidFilter)this.progWidget).getFluid(), b -> {
            b.setFluid(Fluids.EMPTY);
            ((ProgWidgetLiquidFilter)this.progWidget).setFluid(Fluids.EMPTY);
        });
        this.addRenderableWidget((GuiEventListener)this.mainFilter);
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 8; ++x) {
                WidgetFluidFilter f = new WidgetFluidFilter(this.guiLeft + 8 + x * 18, this.guiTop + 52 + y * 18, Fluids.EMPTY, b -> {
                    this.mainFilter.setFluid(b.getFluid());
                    ((ProgWidgetLiquidFilter)this.progWidget).setFluid(b.getFluid());
                });
                this.addRenderableWidget((GuiEventListener)f);
                this.visibleFluidWidgets.add(f);
            }
        }
        Objects.requireNonNull(this.font);
        this.searchField = new WidgetTextField(this.font, this.guiLeft + 8, this.guiTop + 34, 90, 9 + 3);
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.setFocused((GuiEventListener)this.searchField);
        this.searchField.setResponder(s -> {
            this.textTimer = 5;
        });
        this.scrollbar = new WidgetVerticalScrollbar(this.guiLeft + 155, this.guiTop + 47, 112);
        this.scrollbar.setListening(true);
        this.addRenderableWidget((GuiEventListener)this.scrollbar);
        this.addValidFluids();
    }

    private void addValidFluids() {
        List<Fluid> fluids = BuiltInRegistries.FLUID.stream().filter(fluid -> this.matchSearch(this.searchField.getValue(), (Fluid)fluid)).sorted(Comparator.comparing(f -> new FluidStack(f, 1).getDisplayName().getString())).toList();
        this.scrollbar.setStates(Math.max(0, (fluids.size() - 48 + 8 - 1) / 8));
        int offset = this.scrollbar.getState() * 8;
        for (int i = 0; i < this.visibleFluidWidgets.size(); ++i) {
            if (i + offset < fluids.size()) {
                this.visibleFluidWidgets.get(i).setFluid(fluids.get(i + offset));
                continue;
            }
            this.visibleFluidWidgets.get(i).setFluid(Fluids.EMPTY);
        }
    }

    private boolean matchSearch(String srch, Fluid fluid) {
        if (fluid == Fluids.EMPTY || !fluid.isSource(fluid.defaultFluidState())) {
            return false;
        }
        String srchL = srch.toLowerCase();
        return srch.isEmpty() || new FluidStack(fluid, 1).getDisplayName().getString().toLowerCase().contains(srchL);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastScroll != this.scrollbar.getState()) {
            this.lastScroll = this.scrollbar.getState();
            this.addValidFluids();
        } else if (this.textTimer > 0 && --this.textTimer == 0) {
            this.addValidFluids();
        }
    }
}

