/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidget;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetButton;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetDropdown;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetLabel;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class RemoteLayout {
    private final List<ActionWidget<?>> actionWidgets = new ArrayList();
    private static final Map<String, Supplier<ActionWidget<?>>> registeredWidgets = new HashMap();

    private static void registerWidget(Supplier<ActionWidget<?>> supplier) {
        ActionWidget<?> widget = supplier.get();
        registeredWidgets.put(widget.getId(), supplier);
    }

    public RemoteLayout(ItemStack remote, int guiLeft, int guiTop) {
        CompoundTag tag = remote.getTag();
        if (tag != null) {
            ListTag tagList = tag.getList("actionWidgets", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag widgetTag = tagList.getCompound(i);
                String id = widgetTag.getString("id");
                Supplier<ActionWidget<?>> sup = registeredWidgets.get(id);
                if (sup == null) continue;
                ActionWidget<?> actionWidget = sup.get();
                actionWidget.readFromNBT(widgetTag, guiLeft, guiTop);
                this.actionWidgets.add(actionWidget);
            }
        }
    }

    public CompoundTag toNBT(int guiLeft, int guiTop) {
        CompoundTag tag = new CompoundTag();
        ListTag tagList = new ListTag();
        for (ActionWidget<?> actionWidget : this.actionWidgets) {
            tagList.add((Object)actionWidget.toNBT(guiLeft, guiTop));
        }
        tag.put("actionWidgets", (Tag)tagList);
        return tag;
    }

    public void addWidget(ActionWidget<?> widget) {
        this.actionWidgets.add(widget);
    }

    public List<ActionWidget<?>> getActionWidgets() {
        return this.actionWidgets;
    }

    public List<AbstractWidget> getWidgets(boolean filterDisabledWidgets) {
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        for (ActionWidget<?> actionWidget : this.actionWidgets) {
            if (filterDisabledWidgets && !actionWidget.isEnabled()) continue;
            widgets.add((AbstractWidget)actionWidget.getWidget());
        }
        return widgets;
    }

    static {
        RemoteLayout.registerWidget(ActionWidgetCheckBox::new);
        RemoteLayout.registerWidget(ActionWidgetLabel::new);
        RemoteLayout.registerWidget(ActionWidgetButton::new);
        RemoteLayout.registerWidget(ActionWidgetDropdown::new);
    }
}

