/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote;

import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.gui.remote.BasicRemoteOptionScreen;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetVariable;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.common.inventory.RemoteMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class RemoteVariableOptionScreen<A extends ActionWidgetVariable<?>>
extends BasicRemoteOptionScreen<A> {
    private boolean playerGlobal;
    private WidgetButtonExtended varTypeButton;
    private WidgetComboBox variableField;

    public RemoteVariableOptionScreen(A actionWidget, RemoteEditorScreen guiRemote) {
        super(actionWidget, guiRemote);
    }

    @Override
    public void init() {
        super.init();
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.variableName", new Object[0]), this.guiLeft + 10, this.guiTop + 70);
        this.playerGlobal = ((ActionWidgetVariable)this.actionWidget).getVariableName().isEmpty() || ((ActionWidgetVariable)this.actionWidget).getVariableName().startsWith("#");
        this.varTypeButton = new WidgetButtonExtended(this.guiLeft + 10, this.guiTop + 78, 12, 14, GlobalVariableHelper.getVarPrefix(this.playerGlobal), b -> this.togglePlayerGlobal()).setTooltipKey("pneumaticcraft.gui.remote.varType.tooltip");
        this.addRenderableWidget((GuiEventListener)this.varTypeButton);
        Objects.requireNonNull(this.font);
        this.variableField = new WidgetComboBox(this.font, this.guiLeft + 23, this.guiTop + 79, 147, 9 + 3);
        this.variableField.setElements(GlobalVariableHelper.extractVarnames(((RemoteMenu)this.guiRemote.getMenu()).variables, this.playerGlobal));
        this.variableField.setValue(GlobalVariableHelper.stripVarPrefix(((ActionWidgetVariable)this.actionWidget).getVariableName()));
        this.variableField.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.variable.tooltip", new Object[0])));
        this.addRenderableWidget((GuiEventListener)this.variableField);
    }

    @Override
    public void removed() {
        ((ActionWidgetVariable)this.actionWidget).setVariableName(GlobalVariableHelper.getPrefixedVar(this.variableField.getValue(), this.playerGlobal));
        super.removed();
    }

    private void togglePlayerGlobal() {
        this.playerGlobal = !this.playerGlobal;
        this.variableField.setElements(GlobalVariableHelper.extractVarnames(((RemoteMenu)this.guiRemote.getMenu()).variables, this.playerGlobal));
        this.varTypeButton.setMessage((Component)Component.literal((String)GlobalVariableHelper.getVarPrefix(this.playerGlobal)));
    }
}

