/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.actionwidget;

import me.desht.pneumaticcraft.client.gui.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.mixin.accessors.TooltipAccess;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class ActionWidget<W extends AbstractWidget> {
    protected W widget;
    private String enableVariable = "";
    private BlockPos enablingValue = BlockPos.ZERO;

    ActionWidget(W widget) {
        this.widget = widget;
    }

    ActionWidget() {
    }

    public void readFromNBT(CompoundTag tag, int guiLeft, int guiTop) {
        this.enableVariable = tag.getString("enableVariable");
        this.enablingValue = tag.contains("enablingX") ? new BlockPos(tag.getInt("enablingX"), tag.getInt("enablingY"), tag.getInt("enablingZ")) : new BlockPos(1, 0, 0);
    }

    public CompoundTag toNBT(int guiLeft, int guiTop) {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", this.getId());
        tag.putString("enableVariable", this.enableVariable);
        tag.putInt("enablingX", this.enablingValue.getX());
        tag.putInt("enablingY", this.enablingValue.getY());
        tag.putInt("enablingZ", this.enablingValue.getZ());
        return tag;
    }

    public ActionWidget<?> copy() {
        try {
            ActionWidget widget = (ActionWidget)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            widget.readFromNBT(this.toNBT(0, 0), 0, 0);
            return widget;
        }
        catch (Exception e) {
            Log.error("Error occurred when trying to copy a {} action widget: {}", this.getId(), e.getMessage());
            return null;
        }
    }

    public W getWidget() {
        return this.widget;
    }

    public abstract void setWidgetPos(int var1, int var2);

    public abstract String getId();

    public Screen getGui(RemoteEditorScreen guiRemote) {
        return null;
    }

    public void setEnableVariable(String varName) {
        this.enableVariable = varName;
    }

    public String getEnableVariable() {
        return this.enableVariable;
    }

    public boolean isEnabled() {
        if (this.enableVariable.isEmpty()) {
            return true;
        }
        BlockPos pos = GlobalVariableHelper.getPos(ClientUtils.getClientPlayer().getUUID(), this.enableVariable, BlockPos.ZERO);
        return pos.equals((Object)this.enablingValue);
    }

    public void setEnablingValue(int x, int y, int z) {
        this.enablingValue = new BlockPos(x, y, z);
    }

    public BlockPos getEnablingValue() {
        return this.enablingValue;
    }

    public void setTooltip(Tooltip tooltip) {
        this.widget.setTooltip(tooltip);
    }

    public Tooltip getTooltip() {
        return this.widget.getTooltip();
    }

    public Component getTooltipMessage() {
        Tooltip tooltip = this.getWidget().getTooltip();
        return tooltip == null ? Component.empty() : ((TooltipAccess)tooltip).getMessage();
    }

    void deserializeTooltip(String val) {
        if (!val.isEmpty()) {
            MutableComponent c = Component.Serializer.fromJson((String)val);
            this.widget.setTooltip(c == null ? null : Tooltip.create((Component)c));
        } else {
            this.widget.setTooltip(null);
        }
    }
}

