/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.actionwidget;

import me.desht.pneumaticcraft.client.gui.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteButtonOptionScreen;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetVariable;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.IActionWidgetLabeled;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class ActionWidgetButton
extends ActionWidgetVariable<WidgetButtonExtended>
implements IActionWidgetLabeled {
    public BlockPos settingCoordinate = BlockPos.ZERO;

    public ActionWidgetButton() {
    }

    public ActionWidgetButton(WidgetButtonExtended widget) {
        super(widget);
    }

    @Override
    public void readFromNBT(CompoundTag tag, int guiLeft, int guiTop) {
        super.readFromNBT(tag, guiLeft, guiTop);
        this.widget = new WidgetButtonExtended(tag.getInt("x") + guiLeft, tag.getInt("y") + guiTop, tag.getInt("width"), tag.getInt("height"), this.deserializeTextComponent(tag.getString("text")), b -> this.onActionPerformed());
        this.settingCoordinate = new BlockPos(tag.getInt("settingX"), tag.getInt("settingY"), tag.getInt("settingZ"));
        this.deserializeTooltip(tag.getString("tooltip"));
    }

    @Override
    public CompoundTag toNBT(int guiLeft, int guiTop) {
        CompoundTag tag = super.toNBT(guiLeft, guiTop);
        tag.putInt("x", ((WidgetButtonExtended)this.widget).getX() - guiLeft);
        tag.putInt("y", ((WidgetButtonExtended)this.widget).getY() - guiTop);
        tag.putInt("width", ((WidgetButtonExtended)this.widget).getWidth());
        tag.putInt("height", ((WidgetButtonExtended)this.widget).getHeight());
        tag.putString("text", Component.Serializer.toJson((Component)((WidgetButtonExtended)this.widget).getMessage()));
        tag.putInt("settingX", this.settingCoordinate.getX());
        tag.putInt("settingY", this.settingCoordinate.getY());
        tag.putInt("settingZ", this.settingCoordinate.getZ());
        tag.putString("tooltip", Component.Serializer.toJson((Component)this.getTooltipMessage()));
        return tag;
    }

    @Override
    public String getId() {
        return "button";
    }

    @Override
    public void setText(Component text) {
        ((WidgetButtonExtended)this.widget).setMessage(text);
    }

    @Override
    public Component getText() {
        return ((WidgetButtonExtended)this.widget).getMessage();
    }

    @Override
    public void onActionPerformed() {
        if (!this.getVariableName().isEmpty()) {
            NetworkHandler.sendToServer(PacketSetGlobalVariable.forPos(this.getVariableName(), this.settingCoordinate));
        }
    }

    @Override
    public void onVariableChange() {
    }

    @Override
    public Screen getGui(RemoteEditorScreen guiRemote) {
        return new RemoteButtonOptionScreen(this, guiRemote);
    }

    @Override
    public void setWidgetPos(int x, int y) {
        ((WidgetButtonExtended)this.widget).setPosition(x, y);
    }

    public void setWidth(int width) {
        ((WidgetButtonExtended)this.widget).setWidth(width);
    }

    public int getWidth() {
        return ((WidgetButtonExtended)this.widget).getWidth();
    }

    public void setHeight(int height) {
        ((WidgetButtonExtended)this.widget).setHeight(height);
    }

    public int getHeight() {
        return ((WidgetButtonExtended)this.widget).getHeight();
    }
}

