/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.actionwidget;

import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetVariable;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.IActionWidgetLabeled;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class ActionWidgetCheckBox
extends ActionWidgetVariable<WidgetCheckBox>
implements IActionWidgetLabeled {
    public ActionWidgetCheckBox() {
    }

    public ActionWidgetCheckBox(WidgetCheckBox widget) {
        super(widget);
    }

    @Override
    public void readFromNBT(CompoundTag tag, int guiLeft, int guiTop) {
        super.readFromNBT(tag, guiLeft, guiTop);
        this.widget = new WidgetCheckBox(tag.getInt("x") + guiLeft, tag.getInt("y") + guiTop, -12566464, this.deserializeTextComponent(tag.getString("text")), b -> this.onActionPerformed());
        this.deserializeTooltip(tag.getString("tooltip"));
    }

    @Override
    public CompoundTag toNBT(int guiLeft, int guiTop) {
        CompoundTag tag = super.toNBT(guiLeft, guiTop);
        tag.putInt("x", ((WidgetCheckBox)this.widget).getX() - guiLeft);
        tag.putInt("y", ((WidgetCheckBox)this.widget).getY() - guiTop);
        tag.putString("text", Component.Serializer.toJson((Component)((WidgetCheckBox)this.widget).getMessage()));
        tag.putString("tooltip", Component.Serializer.toJson((Component)this.getTooltipMessage()));
        return tag;
    }

    @Override
    public String getId() {
        return "checkbox";
    }

    @Override
    public void setText(Component text) {
        ((WidgetCheckBox)this.widget).setMessage(text);
    }

    @Override
    public Component getText() {
        return ((WidgetCheckBox)this.widget).getMessage();
    }

    @Override
    public void onActionPerformed() {
        if (!this.getVariableName().isEmpty()) {
            NetworkHandler.sendToServer(PacketSetGlobalVariable.forBool(this.getVariableName(), ((WidgetCheckBox)this.widget).checked));
        }
    }

    @Override
    public void onVariableChange() {
        ((WidgetCheckBox)this.widget).checked = GlobalVariableHelper.getBool(ClientUtils.getClientPlayer().getUUID(), this.getVariableName());
    }

    @Override
    public void setWidgetPos(int x, int y) {
        ((WidgetCheckBox)this.widget).setPosition(x, y);
    }
}

