/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.actionwidget;

import me.desht.pneumaticcraft.client.gui.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteDropdownOptionScreen;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetVariable;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ActionWidgetDropdown
extends ActionWidgetVariable<WidgetComboBox> {
    private int x;
    private int y;
    private int width;
    private int height;
    private String dropDownElements = "";
    private boolean sorted;

    public ActionWidgetDropdown() {
    }

    public ActionWidgetDropdown(WidgetComboBox widget) {
        super(widget);
        this.x = widget.getX();
        this.y = widget.getY();
        this.width = widget.getWidth();
        this.height = widget.getHeight();
        widget.setValue(I18n.get((String)"pneumaticcraft.gui.remote.tray.dropdown.name", (Object[])new Object[0]));
        widget.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tray.dropdown.tooltip", new Object[0])));
    }

    @Override
    public void readFromNBT(CompoundTag tag, int guiLeft, int guiTop) {
        super.readFromNBT(tag, guiLeft, guiTop);
        this.x = tag.getInt("x") + guiLeft;
        this.y = tag.getInt("y") + guiTop;
        this.width = tag.getInt("width");
        this.height = tag.getInt("height");
        this.dropDownElements = tag.getString("dropDownElements");
        this.sorted = tag.getBoolean("sorted");
        this.updateWidget();
    }

    @Override
    public CompoundTag toNBT(int guiLeft, int guiTop) {
        CompoundTag tag = super.toNBT(guiLeft, guiTop);
        tag.putInt("x", this.x - guiLeft);
        tag.putInt("y", this.y - guiTop);
        tag.putInt("width", this.width);
        tag.putInt("height", this.height);
        tag.putString("dropDownElements", this.dropDownElements);
        tag.putBoolean("sorted", this.sorted);
        return tag;
    }

    @Override
    public String getId() {
        return "dropdown";
    }

    @Override
    public void onKeyTyped() {
        if (!this.getVariableName().isEmpty()) {
            NetworkHandler.sendToServer(PacketSetGlobalVariable.forInt(this.getVariableName(), ((WidgetComboBox)this.widget).getSelectedElementIndex()));
        }
    }

    @Override
    public void onVariableChange() {
        this.updateWidget();
    }

    @Override
    public void setWidgetPos(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateWidget();
    }

    @Override
    public WidgetComboBox getWidget() {
        if (this.widget == null) {
            this.widget = new WidgetComboBox(Minecraft.getInstance().font, this.x, this.y, this.width, this.height, this::onPressed);
            ((WidgetComboBox)this.widget).setElements(this.getDropdownElements());
            ((WidgetComboBox)this.widget).setFixedOptions(true);
            ((WidgetComboBox)this.widget).setShouldSort(this.sorted);
            this.updateWidget();
        }
        return (WidgetComboBox)this.widget;
    }

    private void onPressed(WidgetComboBox comboBox) {
        if (comboBox.getSelectedElementIndex() >= 0 && !this.getVariableName().isEmpty()) {
            NetworkHandler.sendToServer(PacketSetGlobalVariable.forInt(this.getVariableName(), comboBox.getSelectedElementIndex()));
        }
    }

    private String[] getDropdownElements() {
        return this.dropDownElements.split(",");
    }

    private void updateWidget() {
        String[] elements = this.getDropdownElements();
        int idx = GlobalVariableHelper.getInt(ClientUtils.getClientPlayer().getUUID(), this.getVariableName());
        String selectedElement = elements[Mth.clamp((int)idx, (int)0, (int)(elements.length - 1))];
        if (this.widget != null) {
            ((WidgetComboBox)this.widget).setPosition(this.x, this.y);
            ((WidgetComboBox)this.widget).setWidth(this.width);
            ((WidgetComboBox)this.widget).setHeight(this.height);
            ((WidgetComboBox)this.widget).setElements(this.getDropdownElements());
            ((WidgetComboBox)this.widget).setValue(selectedElement);
            ((WidgetComboBox)this.widget).setShouldSort(this.sorted);
        }
    }

    @Override
    public void onActionPerformed() {
    }

    public void setDropDownElements(String dropDownElements) {
        this.dropDownElements = dropDownElements;
        this.updateWidget();
    }

    public String getDropDownElements() {
        return this.dropDownElements;
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateWidget();
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public Screen getGui(RemoteEditorScreen guiRemote) {
        return new RemoteDropdownOptionScreen(this, guiRemote);
    }
}

