/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateAirGrateModule;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AirGrateModule;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AirGrateModuleScreen
extends AbstractTubeModuleScreen<AirGrateModule> {
    private int sendTimer = 0;
    private WidgetButtonExtended warningButton;
    private WidgetButtonExtended rangeButton;
    private EditBox textfield;

    public AirGrateModuleScreen(AirGrateModule module) {
        super(module);
        this.ySize = 57;
    }

    @Override
    public void init() {
        super.init();
        this.addLabel(this.title, this.guiLeft + this.xSize / 2, this.guiTop + 5, WidgetLabel.Alignment.CENTRE);
        WidgetLabel filterLabel = this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.entityFilter", new Object[0]), this.guiLeft + 10, this.guiTop + 21);
        filterLabel.visible = ((AirGrateModule)this.module).isUpgraded();
        WidgetLabel helpLabel = this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.holdF1forHelp", new Object[0]), this.guiLeft + this.xSize / 2, this.guiTop + this.ySize + 5, WidgetLabel.Alignment.CENTRE).setColor(0xC0C0C0);
        helpLabel.visible = ((AirGrateModule)this.module).isUpgraded();
        WidgetButtonExtended advPCB = new WidgetButtonExtended(this.guiLeft + 10, this.guiTop + 21, 20, 20, (Component)Component.empty()).setRenderStacks(new ItemStack((ItemLike)ModItems.MODULE_EXPANSION_CARD.get())).setTooltipKey("pneumaticcraft.gui.redstoneModule.addAdvancedPCB").setVisible(false);
        advPCB.visible = !((AirGrateModule)this.module).isUpgraded();
        this.addRenderableWidget((GuiEventListener)advPCB);
        int tx = 12 + filterLabel.getWidth();
        Objects.requireNonNull(this.font);
        this.textfield = new WidgetTextField(this.font, this.guiLeft + tx, this.guiTop + 19, this.xSize - tx - 10, 9 + 3);
        this.textfield.setValue(((AirGrateModule)this.module).getEntityFilter().toString());
        this.textfield.setResponder(s -> {
            if (this.validateEntityFilter((String)s)) {
                this.sendTimer = 5;
            }
        });
        this.textfield.setVisible(((AirGrateModule)this.module).isUpgraded());
        this.setInitialFocus((GuiEventListener)this.textfield);
        this.addRenderableWidget((GuiEventListener)this.textfield);
        this.warningButton = new WidgetButtonExtended(this.guiLeft + tx, this.guiTop + 30, 20, 20, (Component)Component.empty()).setVisible(false).setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE);
        this.addRenderableWidget((GuiEventListener)this.warningButton);
        this.rangeButton = new WidgetButtonExtended(this.guiLeft + this.xSize - 20, this.guiTop + this.ySize - 20, 16, 16, this.getRangeButtonText(), b -> {
            ((AirGrateModule)this.module).setShowRange(!((AirGrateModule)this.module).isShowRange());
            this.rangeButton.setMessage(this.getRangeButtonText());
        });
        this.addRenderableWidget((GuiEventListener)this.rangeButton);
        this.validateEntityFilter(this.textfield.getValue());
    }

    private Component getRangeButtonText() {
        return Component.literal((String)((((AirGrateModule)this.module).isShowRange() ? ChatFormatting.AQUA : ChatFormatting.DARK_GRAY) + "R"));
    }

    private boolean validateEntityFilter(String filter) {
        try {
            new EntityFilter(filter);
            this.warningButton.visible = false;
            this.warningButton.setTooltipText((Component)Component.empty());
            return true;
        }
        catch (IllegalArgumentException e) {
            this.warningButton.visible = true;
            this.warningButton.setTooltipText((Component)Component.literal((String)e.getMessage()).withStyle(ChatFormatting.GOLD));
            return false;
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (ClientUtils.isKeyDown(290) && ((AirGrateModule)this.module).isUpgraded()) {
            GuiUtils.showPopupHelpScreen(graphics, this, this.font, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
        }
    }

    @Override
    public void tick() {
        EntityFilter filter;
        super.tick();
        if (!this.textfield.isFocused()) {
            this.textfield.setValue(((AirGrateModule)this.module).getEntityFilter().toString());
        }
        this.validateEntityFilter(this.textfield.getValue());
        if (this.sendTimer > 0 && --this.sendTimer == 0 && (filter = EntityFilter.fromString(this.textfield.getValue())) != null) {
            ((AirGrateModule)this.module).setEntityFilter(filter);
            NetworkHandler.sendToServer(PacketUpdateAirGrateModule.create(this.module, this.textfield.getValue()));
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_MODULE_SIMPLE;
    }
}

