/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.client.gui.tubemodule.ThermostatModuleScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetColorSelector;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncThermostatModuleToServer;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.tubemodules.ThermostatModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class SimpleThermostatModuleScreen
extends AbstractTubeModuleScreen<ThermostatModule> {
    private int color;
    private int threshold;
    private WidgetTextFieldNumber thresholdField;

    public SimpleThermostatModuleScreen(ThermostatModule module) {
        super(module);
        this.ySize = 57;
    }

    @Override
    public void init() {
        super.init();
        this.color = ((ThermostatModule)this.module).getColorChannel();
        this.threshold = ((ThermostatModule)this.module).getThreshold();
        this.addLabel(this.getTitle(), this.guiLeft + this.xSize / 2, this.guiTop + 5, WidgetLabel.Alignment.CENTRE);
        int x = this.guiLeft + 10;
        int y = this.guiTop + 24;
        WidgetLabel colorLabel = new WidgetLabel(x, y, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.channel", new Object[0]));
        this.addRenderableWidget((GuiEventListener)colorLabel);
        x = this.guiLeft + 10 + colorLabel.getWidth() + 10;
        WidgetColorSelector colorSelector = new WidgetColorSelector(x, y - 4, w -> {
            this.color = w.getColor().getId();
        }).withInitialColor(DyeColor.byId((int)this.color));
        this.addRenderableWidget((GuiEventListener)colorSelector);
        if (((ThermostatModule)this.module).isUpgraded()) {
            x = this.guiLeft + 10 + colorLabel.getWidth() + 10 + colorSelector.getWidth() + 10;
            WidgetCheckBox advancedMode = new WidgetCheckBox(x, y, -12566464, (Component)Component.literal((String)"Advanced"), b -> {
                ((ThermostatModule)this.module).advancedConfig = b.checked;
                NetworkHandler.sendToServer(PacketUpdatePressureModule.create(this.module));
            }).setChecked(false);
            advancedMode.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.advancedConfig.tooltip", new Object[0])));
            this.addRenderableWidget((GuiEventListener)advancedMode);
        }
        x = this.guiLeft + 10;
        y = this.guiTop + 22 + colorLabel.getHeight() + 10;
        WidgetLabel thresholdLabel = new WidgetLabel(x, y, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.simpleConfig.threshold", new Object[0]));
        this.addRenderableWidget((GuiEventListener)thresholdLabel);
        x = this.guiLeft + 10 + thresholdLabel.getWidth() + 5;
        Objects.requireNonNull(this.font);
        this.thresholdField = new WidgetTextFieldNumber(this.font, x, y - 2, 30, 9 + 3).setDecimals(0);
        this.addRenderableWidget((GuiEventListener)this.thresholdField);
        this.thresholdField.setWidth(40);
        this.setInitialFocus((GuiEventListener)this.thresholdField);
        this.thresholdField.setValue(this.threshold);
        x = this.guiLeft + 10 + thresholdLabel.getWidth() + this.thresholdField.getWidth() + 10;
        this.addRenderableWidget((GuiEventListener)new WidgetLabel(x, y, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.celsius", new Object[0])));
    }

    @Override
    public void tick() {
        super.tick();
        if (((ThermostatModule)this.module).advancedConfig) {
            this.minecraft.setScreen((Screen)new ThermostatModuleScreen((ThermostatModule)this.module));
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_MODULE_SIMPLE;
    }

    public void removed() {
        super.removed();
        ((ThermostatModule)this.module).setColorChannel(this.color);
        ((ThermostatModule)this.module).setThreshold(this.thresholdField.getIntValue());
        NetworkHandler.sendToServer(PacketSyncThermostatModuleToServer.create((ThermostatModule)this.module));
    }
}

