/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.client.gui.tubemodule.SimpleThermostatModuleScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetColorSelector;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncThermostatModuleToServer;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.ThermostatModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import org.joml.Matrix4f;

public class ThermostatModuleScreen
extends AbstractTubeModuleScreen<ThermostatModule> {
    private int color;
    WidgetColorSelector colorSelector;
    private EditBox lowerBoundField;
    private EditBox higherBoundField;
    private int graphLowY;
    private int graphHighY;
    private int graphLeft;
    private int graphRight;
    private Rect2i lowerBoundArea;
    private Rect2i higherBoundArea;
    private boolean grabLower;
    private boolean grabHigher;

    public static AbstractTubeModuleScreen<?> createGUI(AbstractTubeModule module) {
        return module.isUpgraded() ? new ThermostatModuleScreen((ThermostatModule)module) : new SimpleThermostatModuleScreen((ThermostatModule)module);
    }

    public ThermostatModuleScreen(ThermostatModule module) {
        super(module);
        this.ySize = 191;
    }

    @Override
    public void init() {
        super.init();
        this.color = ((ThermostatModule)this.module).getColorChannel();
        this.addLabel(this.getTitle(), this.guiLeft + this.xSize / 2, this.guiTop + 5, WidgetLabel.Alignment.CENTRE);
        int xStart = (this.width - this.xSize) / 2;
        int yStart = (this.height - this.ySize) / 2;
        int x = this.guiLeft + 10;
        int y = this.guiTop + 22;
        WidgetLabel colorLabel = new WidgetLabel(x, y, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.channel", new Object[0]));
        this.addRenderableWidget((GuiEventListener)colorLabel);
        x = this.guiLeft + 10 + colorLabel.getWidth() + 7;
        this.colorSelector = new WidgetColorSelector(x, y - 2, w -> {
            this.color = w.getColor().getId();
            ((ThermostatModule)this.module).setColorChannel(this.color);
            NetworkHandler.sendToServer(PacketSyncThermostatModuleToServer.create((ThermostatModule)this.module));
        }).withInitialColor(DyeColor.byId((int)this.color));
        this.addRenderableWidget((GuiEventListener)this.colorSelector);
        x = this.guiLeft + 10 + colorLabel.getWidth() + 7 + this.colorSelector.getWidth() + 10;
        WidgetCheckBox advancedMode = new WidgetCheckBox(x, y, -12566464, (Component)Component.literal((String)"Advanced"), b -> {
            ((ThermostatModule)this.module).advancedConfig = b.checked;
            NetworkHandler.sendToServer(PacketUpdatePressureModule.create(this.module));
        }).setChecked(true);
        advancedMode.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.advancedConfig.tooltip", new Object[0])));
        this.addRenderableWidget((GuiEventListener)advancedMode);
        this.addLabel((Component)Component.literal((String)"lower"), this.guiLeft + 15, this.guiTop + 33);
        this.addLabel((Component)Component.literal((String)"\u00b0C"), this.guiLeft + 60, this.guiTop + 44);
        this.addLabel((Component)Component.literal((String)"higher"), this.guiLeft + 140, this.guiTop + 33);
        this.addLabel(this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.guiTop + 5);
        this.lowerBoundField = new EditBox(this.font, xStart + 15, yStart + 43, 40, 10, (Component)Component.literal((String)PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).lowerBound, 0)));
        this.lowerBoundField.setResponder(s -> this.updateBoundFromTextfield(0));
        this.addRenderableWidget((GuiEventListener)this.lowerBoundField);
        this.higherBoundField = new EditBox(this.font, xStart + 130, yStart + 43, 40, 10, (Component)Component.literal((String)PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).higherBound, 0)));
        this.higherBoundField.setResponder(s -> this.updateBoundFromTextfield(1));
        this.addRenderableWidget((GuiEventListener)this.higherBoundField);
        this.graphLowY = this.guiTop + 158;
        this.graphHighY = this.guiTop + 98;
        this.graphLeft = this.guiLeft + 22;
        this.graphRight = this.guiLeft + 172;
        this.addRenderableWidget((GuiEventListener)new WidgetTooltipArea(this.graphLeft - 20, this.graphHighY, 25, this.graphLowY - this.graphHighY, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstone", new Object[0])}));
        this.addRenderableWidget((GuiEventListener)new WidgetTooltipArea(this.graphLeft, this.graphLowY - 5, this.graphRight - this.graphLeft, 25, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.temperature", new Object[0])}));
        WidgetAnimatedStat stat = new WidgetAnimatedStat(this, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info", new Object[0]), WidgetAnimatedStat.StatIcon.of(Textures.GUI_INFO_LOCATION), xStart, yStart + 5, -7829249, null, true);
        stat.setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.tubeModule", new Object[0]));
        stat.setBeveled(true);
        this.addRenderableWidget(stat);
        this.higherBoundArea = new Rect2i(this.guiLeft + 11, this.guiTop + 59, 158, 15);
        this.lowerBoundArea = new Rect2i(this.guiLeft + 11, this.guiTop + 73, 158, 15);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_TUBE_MODULE;
    }

    @Override
    public void drawForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int scrollbarLowerBoundX = this.temperatureToX((int)((ThermostatModule)this.module).lowerBound);
        int scrollbarHigherBoundX = this.temperatureToX((int)((ThermostatModule)this.module).higherBound);
        graphics.blit(this.getTexture(), scrollbarLowerBoundX, this.guiTop + 73, 183, 0, 15, 12);
        graphics.blit(this.getTexture(), scrollbarHigherBoundX, this.guiTop + 59, 183, 0, 15, 12);
        this.renderGraph(graphics);
        NetworkHandler.sendToServer(PacketUpdatePressureModule.create(this.module));
        NetworkHandler.sendToServer(PacketSyncThermostatModuleToServer.create((ThermostatModule)this.module));
        graphics.hLine(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - ((ThermostatModule)this.module).getInputLevel()) / 15, -65536);
        String status = I18n.get((String)"pneumaticcraft.gui.tubeModule.simpleConfig.temperature", (Object[])new Object[0]) + " " + PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).getTemperature(), 0) + " \u00b0C";
        graphics.drawString(this.font, status, (float)this.guiLeft + (float)this.xSize / 2.0f - (float)this.font.width(status) / 2.0f, (float)(this.guiTop + 175), -12566464, false);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Matrix4f posMat = graphics.pose().last().pose();
        float temperatureRange = 2273.0f;
        for (int i = 0; i < 16; ++i) {
            float y = (float)this.graphHighY + (float)((this.graphLowY - this.graphHighY) * (15 - i)) / 15.0f;
            float x = (float)this.graphLeft + (float)((this.graphRight - this.graphLeft) * (((ThermostatModule)this.module).getTemperatureForLevel(i) - -273)) / temperatureRange;
            bufferBuilder.vertex(posMat, x, y, 90.0f).color(0.25f + (float)i * 0.05f, 0.0f, 0.0f, 1.0f).endVertex();
        }
        Tesselator.getInstance().end();
        RenderSystem.disableBlend();
    }

    private void renderGraph(GuiGraphics graphics) {
        graphics.vLine(this.graphLeft, this.graphHighY, this.graphLowY, -13619152);
        for (int i = 0; i < 16; ++i) {
            boolean longer;
            boolean bl = longer = i % 5 == 0;
            if (longer) {
                String txt = String.valueOf(i);
                graphics.drawString(this.font, txt, (float)(this.graphLeft - 5 - this.font.width(txt)), (float)this.graphHighY + (float)((this.graphLowY - this.graphHighY) * (15 - i)) / 15.0f - 3.0f, -13619152, false);
                graphics.hLine(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, i == 0 ? -13619152 : 0x33000000);
            }
            graphics.hLine(this.graphLeft - (longer ? 5 : 3), this.graphLeft + 3, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, -13619152);
        }
        int[] temps = new int[]{-273, 0, 1000, 2000};
        int[] adjusts = new int[]{-3, 1, 1, -5};
        for (int i = 0; i < 4; ++i) {
            int offset = (int)((float)(temps[i] - -273) * 0.04399472f);
            String txt = String.valueOf(temps[i]);
            graphics.drawString(this.font, txt, (float)this.graphLeft + (float)((this.graphRight - this.graphLeft) * offset) / 100.0f - (float)this.font.width(txt) / 2.0f + (float)adjusts[i], (float)(this.graphLowY + 6), -13619152, false);
            graphics.vLine(this.graphLeft + (this.graphRight - this.graphLeft) * offset / 100, this.graphHighY, this.graphLowY - 2, 0x33000000);
            graphics.vLine(this.graphLeft + (this.graphRight - this.graphLeft) * offset / 100, this.graphLowY - 5, this.graphLowY + 3, -13619152);
        }
    }

    private void updateBoundFromTextfield(int fieldId) {
        try {
            switch (fieldId) {
                case 0: {
                    float prev = ((ThermostatModule)this.module).lowerBound;
                    ((ThermostatModule)this.module).lowerBound = Mth.clamp((int)Integer.parseInt(this.lowerBoundField.getValue()), (int)-273, (int)2000);
                    if (!Mth.equal((float)((ThermostatModule)this.module).lowerBound, (float)prev)) {
                        NetworkHandler.sendToServer(PacketUpdatePressureModule.create(this.module));
                    }
                    break;
                }
                case 1: {
                    float prev = ((ThermostatModule)this.module).higherBound;
                    ((ThermostatModule)this.module).higherBound = Mth.clamp((int)Integer.parseInt(this.higherBoundField.getValue()), (int)-273, (int)2000);
                    if (!Mth.equal((float)((ThermostatModule)this.module).higherBound, (float)prev)) {
                        NetworkHandler.sendToServer(PacketUpdatePressureModule.create(this.module));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown field id " + fieldId);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private int xToTemperature(double mouseX) {
        float sliderWidth = 146.0f;
        int sliderLeft = this.guiLeft + 11;
        float temperatureRange = 2273.0f;
        float xNormalized = Math.max(0.0f, Math.min(1.0f, ((float)mouseX - (float)sliderLeft) / sliderWidth));
        int temperature = (int)(xNormalized * temperatureRange) + -273;
        return temperature;
    }

    private int temperatureToX(int temperature) {
        float sliderWidth = 146.0f;
        int sliderLeft = this.guiLeft + 11;
        float temperatureRange = 2273.0f;
        float tempNormalized = Math.max(-273.0f, Math.min(2000.0f, ((float)temperature - -273.0f) / temperatureRange));
        int x = (int)(tempNormalized * sliderWidth) + sliderLeft;
        return x;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.colorSelector.isExpanded() && this.lowerBoundArea.contains((int)mouseX, (int)mouseY)) {
            ((ThermostatModule)this.module).lowerBound = this.xToTemperature(mouseX - 7.0);
            this.grabLower = true;
            return true;
        }
        if (!this.colorSelector.isExpanded() && this.higherBoundArea.contains((int)mouseX, (int)mouseY)) {
            ((ThermostatModule)this.module).higherBound = this.xToTemperature(mouseX - 7.0);
            this.grabHigher = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dx, double dy) {
        if (this.grabLower) {
            ((ThermostatModule)this.module).lowerBound = this.xToTemperature(mouseX - 7.0);
            return true;
        }
        if (this.grabHigher) {
            ((ThermostatModule)this.module).higherBound = this.xToTemperature(mouseX - 7.0);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, clickedMouseButton, dx, dy);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        if (this.grabLower) {
            NetworkHandler.sendToServer(PacketUpdatePressureModule.create(this.module));
            this.grabLower = false;
            return true;
        }
        if (this.grabHigher) {
            NetworkHandler.sendToServer(PacketUpdatePressureModule.create(this.module));
            this.grabHigher = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!((ThermostatModule)this.module).advancedConfig) {
            this.minecraft.setScreen((Screen)new SimpleThermostatModuleScreen((ThermostatModule)this.module));
        }
        if (!this.lowerBoundField.isFocused()) {
            this.lowerBoundField.setValue(PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).lowerBound, 0));
        }
        if (!this.higherBoundField.isFocused()) {
            this.higherBoundField.setValue(PneumaticCraftUtils.roundNumberTo(((ThermostatModule)this.module).higherBound, 0));
        }
    }
}

