/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class WidgetAmadronOffer
extends AbstractWidget {
    private final AmadronOffer offer;
    private final List<AbstractWidget> subWidgets = new ArrayList<AbstractWidget>();
    private int shoppingAmount;
    private boolean canBuy;
    private final Rect2i[] tooltipRectangles = new Rect2i[2];
    private boolean renderBackground = true;

    public WidgetAmadronOffer(int x, int y, AmadronOffer offer) {
        super(x, y, 73, 35, (Component)Component.empty());
        this.offer = offer;
        offer.getInput().accept(itemStack -> this.subWidgets.add((AbstractWidget)new WidgetItemStack(x + 6, y + 13, (ItemStack)itemStack)), fluidStack -> this.subWidgets.add(new WidgetFluidStack(x + 6, y + 15, fluidStack.copy(), null)));
        offer.getOutput().accept(itemStack -> this.subWidgets.add((AbstractWidget)new WidgetItemStack(x + 51, y + 13, (ItemStack)itemStack)), fluidStack -> this.subWidgets.add(new WidgetFluidStack(x + 51, y + 15, fluidStack.copy(), null)));
        if (offer.isRemovableBy((Player)Minecraft.getInstance().player)) {
            ArrayList<Component> l = new ArrayList<Component>(GuiUtils.xlateAndSplit("pneumaticcraft.gui.amadron.amadronWidget.sneakRightClickToRemove", new Object[0]));
            l.add((Component)Component.empty());
            WidgetButtonExtended btn = new WidgetButtonExtended(x + 57, y + 1, 11, 11, (Component)Component.literal((String)(ChatFormatting.RED + "x")), b -> NetworkHandler.sendToServer(new PacketGuiButton("remove:" + offer.getOfferId())));
            btn.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.combineComponents(l)));
            this.subWidgets.add((AbstractWidget)btn);
        }
        this.tooltipRectangles[0] = new Rect2i(x + 5, y + 14, 18, 18);
        this.tooltipRectangles[1] = new Rect2i(x + 50, y + 14, 18, 18);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.subWidgets.stream().anyMatch(w -> w.mouseClicked(mouseX, mouseY, button));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Object str;
        Font fr = Minecraft.getInstance().font;
        if (this.renderBackground) {
            graphics.blit(Textures.WIDGET_AMADRON_OFFER, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, 256, 256);
        }
        FormattedCharSequence r = (FormattedCharSequence)fr.split((FormattedText)this.offer.getVendorName(), 73).get(0);
        graphics.drawString(fr, r, this.getX() + 2, this.getY() + 2, -16777216, false);
        if (this.shoppingAmount > 0) {
            str = Integer.toString(this.shoppingAmount);
            graphics.drawString(fr, (String)str, (float)(this.getX() + 36) - (float)fr.width((String)str) / 2.0f, (float)(this.getY() + (this.offer.getStock() >= 0 ? 15 : 20)), -16777216, false);
        }
        if (this.offer.getStock() >= 0) {
            str = ChatFormatting.DARK_BLUE.toString() + this.offer.getStock();
            graphics.drawString(fr, (String)str, (float)(this.getX() + 36) - (float)fr.width((String)str) / 2.0f, (float)(this.getY() + 25), -16777216, false);
        }
        boolean availableHere = this.offer.isUsableByPlayer(ClientUtils.getClientPlayer());
        if (this.offer.isLocationLimited()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            graphics.blit(availableHere ? Textures.GUI_OK_LOCATION : Textures.GUI_BAD_LOCATION, this.getX() + this.width - 15, this.getY() - 1, 0, 0, 16, 16);
            RenderSystem.disableBlend();
        }
        if (!this.canBuy || !availableHere) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -1065336768);
        }
        this.subWidgets.forEach(w -> w.render(graphics, mouseX, mouseY, partialTick));
        if (this.isHovered && Arrays.stream(this.tooltipRectangles).noneMatch(rect -> rect.contains(mouseX, mouseY))) {
            graphics.renderTooltip(Minecraft.getInstance().font, WidgetAmadronOffer.makeTooltip(this.offer, this.shoppingAmount), Optional.empty(), mouseX, mouseY);
        }
    }

    public WidgetAmadronOffer setDrawBackground(boolean drawBackground) {
        this.renderBackground = drawBackground;
        return this;
    }

    public WidgetAmadronOffer setAffordable(boolean canBuy) {
        this.canBuy = canBuy;
        return this;
    }

    public AmadronOffer getOffer() {
        return this.offer;
    }

    public void setShoppingAmount(int amount) {
        this.shoppingAmount = amount;
    }

    public static List<Component> makeTooltip(AmadronOffer offer, int shoppingAmount) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.vendor", offer.getVendorName().copy().withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.selling", Component.literal((String)offer.getOutput().toString()).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.buying", Component.literal((String)offer.getInput().toString()).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.YELLOW));
        if (shoppingAmount >= 0) {
            if (offer.getStock() >= 0) {
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.stock", Component.literal((String)Integer.toString(offer.getStock())).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.AQUA));
            }
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.amadronWidget.inBasket", Component.literal((String)Integer.toString(shoppingAmount)).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.AQUA));
        }
        if (!offer.isUsableByPlayer(ClientUtils.getClientPlayer())) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.playerFilter.unavailable", new Object[0]).withStyle(ChatFormatting.RED));
        }
        offer.addAvailabilityData(ClientUtils.getClientPlayer(), tooltip);
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            tooltip.add((Component)Component.literal((String)offer.getOfferId().toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    private static class WidgetItemStack
    extends WidgetButtonExtended {
        public WidgetItemStack(int startX, int startY, ItemStack stack) {
            super(startX, startY, 16, 16);
            this.setRenderStacks(stack);
            this.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.combineComponents(stack.getTooltipLines((Player)Minecraft.getInstance().player, (TooltipFlag)TooltipFlag.Default.NORMAL))));
            this.setVisible(false);
            this.setRenderStackSize(true);
        }

        protected boolean isValidClickButton(int pButton) {
            return false;
        }
    }
}

