/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.widget.ICanRender3d;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix3f;

public class WidgetAnimatedStat
extends AbstractWidget
implements IGuiAnimatedStat {
    private static final int MIN_WIDTH_HEIGHT = 17;
    private static final int MAX_VISIBLE_LINES = 12;
    private static final int SCROLLBAR_MARGIN_WIDTH = 20;
    private static final int TOP_MARGIN_HEIGHT = 20;
    private IGuiAnimatedStat statAbove;
    private StatIcon statIcon;
    private final Screen gui;
    private final List<Component> textComponents = new ArrayList<Component>();
    private final List<FormattedCharSequence> reorderingProcessors = new ArrayList<FormattedCharSequence>();
    private final List<Boolean> dropShadows = new ArrayList<Boolean>();
    private final List<AbstractWidget> subWidgets = new ArrayList<AbstractWidget>();
    private int effectiveY;
    private int reservedLines = 0;
    private boolean autoLineWrap = true;
    private int prevX;
    private int prevEffectiveY;
    private int prevWidth;
    private int prevHeight;
    private boolean isClicked = false;
    private int minWidth = 17;
    private int minHeight = 17;
    private int minExpandedHeight;
    private int minExpandedWidth;
    private int expandedWidth;
    private int expandedHeight;
    private int backGroundColor;
    private TintColor bgColorHi;
    private TintColor bgColorLo;
    private boolean leftSided;
    private boolean doneExpanding;
    private int curScroll;
    private int lineSpacing = 10;
    private int widgetOffsetLeft = 0;
    private int widgetOffsetRight = 0;
    private boolean bevel = false;
    private WidgetVerticalScrollbar scrollBar = null;
    private boolean needTextRecalc = true;
    private int foregroundColor = -1;
    private int titleColor = -256;
    private List<Component> extraTooltipText = new ArrayList<Component>();

    public WidgetAnimatedStat(Screen gui, Component title, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat statAbove, boolean leftSided) {
        super(xPos, yPos, 17, 17, title);
        this.gui = gui;
        this.statAbove = statAbove;
        this.leftSided = leftSided;
        this.statIcon = StatIcon.NONE;
        this.backGroundColor = backGroundColor;
        this.calculateColorHighlights(this.backGroundColor);
        this.effectiveY = this.getY();
        if (statAbove != null) {
            this.effectiveY += statAbove.getEffectiveY() + statAbove.getStatHeight();
        }
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor) {
        this(gui, (Component)Component.empty(), 0, 0, backgroundColor, null, false);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, ItemStack icon) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(icon);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, ResourceLocation texture) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(texture);
    }

    public WidgetAnimatedStat(Screen gui, Component title, StatIcon icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat statAbove, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, statAbove, leftSided);
        this.statIcon = icon;
    }

    public WidgetAnimatedStat(Screen gui, Component title, StatIcon icon, int backGroundColor, IGuiAnimatedStat statAbove, StatPanelLayout layout) {
        this(gui, title, 0, 0, backGroundColor, statAbove, layout.expandsLeft());
        Window mw = Minecraft.getInstance().getWindow();
        int x = layout.x() == -1.0f ? mw.getGuiScaledWidth() - 2 : (int)((float)mw.getGuiScaledWidth() * layout.x());
        this.setBaseX(x);
        this.setBaseY((int)((float)mw.getGuiScaledHeight() * layout.y()));
        this.statIcon = icon;
    }

    public void setMessage(Component message) {
        super.setMessage(message);
        this.needTextRecalc = true;
    }

    @Override
    public void setParentStat(IGuiAnimatedStat stat) {
        this.statAbove = stat;
    }

    @Override
    public void addSubWidget(AbstractWidget widget) {
        this.subWidgets.add(widget);
    }

    public void removeSubWidget(AbstractWidget widget) {
        this.subWidgets.remove(widget);
    }

    @Override
    public void setSubwidgetRenderOffsets(int left, int right) {
        this.widgetOffsetLeft = left;
        this.widgetOffsetRight = right;
    }

    @Override
    public boolean isLeftSided() {
        return this.leftSided;
    }

    @Override
    public void setLeftSided(boolean leftSided) {
        this.leftSided = leftSided;
    }

    @Override
    public void setAutoLineWrap(boolean wrap) {
        this.autoLineWrap = wrap;
    }

    @Override
    public Component getTitle() {
        return this.getMessage();
    }

    @Override
    public void setTitle(Component title) {
        this.setMessage(title);
    }

    @Override
    public IGuiAnimatedStat setText(List<Component> text) {
        this.textComponents.clear();
        this.textComponents.addAll(text);
        this.needTextRecalc = true;
        return this;
    }

    @Override
    public IGuiAnimatedStat setText(Component text) {
        this.textComponents.clear();
        this.textComponents.add(text);
        this.needTextRecalc = true;
        return this;
    }

    @Override
    public void appendText(List<Component> text) {
        this.textComponents.addAll(text);
        this.needTextRecalc = true;
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
        if (backgroundColor != this.backGroundColor) {
            this.backGroundColor = backgroundColor;
            this.calculateColorHighlights(backgroundColor);
        }
    }

    @Override
    public void setForegroundColor(int foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    @Override
    public void setTitleColor(int titleColor) {
        this.titleColor = titleColor;
    }

    @Override
    public int getBackgroundColor() {
        return this.backGroundColor;
    }

    private void calculateColorHighlights(int color) {
        if (((Boolean)ConfigHelper.client().general.guiBevel.get()).booleanValue()) {
            float fgR = (float)(color >> 16 & 0xFF) / 255.0f;
            float fgG = (float)(color >> 8 & 0xFF) / 255.0f;
            float fgB = (float)(color & 0xFF) / 255.0f;
            float fgA = (float)(color >> 24 & 0xFF) / 255.0f;
            TintColor c = new TintColor(fgR, fgG, fgB, fgA);
            if (this.bevel) {
                this.bgColorHi = c.brighter();
                this.bgColorLo = c.darker();
            } else {
                this.bgColorLo = this.bgColorHi = c.darker().darker();
            }
        } else {
            this.bgColorLo = this.bgColorHi = new TintColor(color).darker().darker();
        }
    }

    @Override
    public void setBeveled(boolean bevel) {
        this.bevel = bevel;
        this.calculateColorHighlights(this.backGroundColor);
    }

    private int getVisibleLines() {
        return 12 - this.reservedLines;
    }

    @Override
    public void setReservedLines(int reservedLines) {
        this.reservedLines = Mth.clamp((int)reservedLines, (int)0, (int)11);
        this.needTextRecalc = true;
    }

    private void recalcText() {
        int n;
        this.reorderingProcessors.clear();
        this.dropShadows.clear();
        Font font = Minecraft.getInstance().font;
        int titleWidth = font.width((FormattedText)this.getMessage());
        if (this.autoLineWrap) {
            int availableWidth = this.calculateAvailableWidth();
            this.reorderingProcessors.addAll(GuiUtils.wrapTextComponentList(this.textComponents, availableWidth, font));
            this.expandedWidth = Math.min(availableWidth, Math.max(titleWidth, this.minExpandedWidth));
        } else {
            this.expandedWidth = titleWidth;
            this.textComponents.forEach(c -> this.reorderingProcessors.add(c.getVisualOrderText()));
        }
        this.reorderingProcessors.forEach(processedLine -> {
            this.expandedWidth = Math.max(this.expandedWidth, font.width(processedLine));
            this.dropShadows.add(this.needsDropShadow((FormattedCharSequence)processedLine));
        });
        this.expandedWidth += 20;
        if (this.reorderingProcessors.isEmpty()) {
            Objects.requireNonNull(font);
            n = 9;
        } else {
            n = 20;
        }
        int topMargin = n;
        int n2 = Math.min(12, this.reorderingProcessors.size() + this.reservedLines);
        Objects.requireNonNull(font);
        this.expandedHeight = Math.max(this.minExpandedHeight, topMargin + n2 * 9) + 3;
        this.addOrRemoveScrollbar();
        this.needTextRecalc = false;
    }

    private int calculateAvailableWidth() {
        int availableWidth;
        Screen screen = this.gui;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            availableWidth = Math.min(Math.max(this.minExpandedWidth, screen2.getXSize()), this.leftSided ? screen2.getGuiLeft() : screen2.width - (screen2.getGuiLeft() + screen2.getXSize()));
        } else {
            screen = this.gui;
            if (screen instanceof AbstractPneumaticCraftScreen) {
                AbstractPneumaticCraftScreen screen3 = (AbstractPneumaticCraftScreen)screen;
                availableWidth = Math.min(Math.max(this.minExpandedWidth, screen3.xSize), this.leftSided ? screen3.guiLeft : screen3.xSize - (screen3.guiLeft + screen3.xSize));
            } else {
                availableWidth = this.leftSided ? this.getX() : Minecraft.getInstance().getWindow().getGuiScaledWidth() - this.getX();
            }
        }
        return Math.max(availableWidth - 5 - 20, 16);
    }

    private boolean needsDropShadow(FormattedCharSequence line) {
        StyleChecker styleChecker = new StyleChecker(this.foregroundColor);
        line.accept((FormattedCharSink)styleChecker);
        return styleChecker.isLightColor();
    }

    private void addOrRemoveScrollbar() {
        if (this.reorderingProcessors.size() > this.getVisibleLines()) {
            int n;
            if (this.subWidgets.contains(this.scrollBar)) {
                return;
            }
            this.curScroll = 0;
            int scrollbarHeight = this.getVisibleLines() * this.lineSpacing - 20;
            if (this.reservedLines > 0) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                n = this.reservedLines * 9;
            } else {
                n = 0;
            }
            int yOffset = n;
            this.scrollBar = new WidgetVerticalScrollbar(this.leftSided ? -16 : 2, 20 + yOffset, scrollbarHeight).setStates(this.reorderingProcessors.size() - this.getVisibleLines()).setListening(true);
            this.addSubWidget(this.scrollBar);
        } else if (this.subWidgets.removeIf(w -> w == this.scrollBar)) {
            this.curScroll = 0;
            this.scrollBar = null;
        }
    }

    @Override
    public void setMinimumContractedDimensions(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.width = minWidth;
        this.height = minHeight;
    }

    @Override
    public void setMinimumExpandedDimensions(int minWidth, int minHeight) {
        if (this.minExpandedWidth != minWidth) {
            this.needTextRecalc = true;
        }
        this.minExpandedWidth = minWidth;
        this.minExpandedHeight = minHeight;
    }

    @Override
    public void tickWidget() {
        if (this.needTextRecalc) {
            this.recalcText();
        }
        this.prevX = this.getX();
        this.prevEffectiveY = this.effectiveY;
        this.prevWidth = this.width;
        this.prevHeight = this.height;
        this.doneExpanding = true;
        int expandX = this.expandedWidth / 4;
        int expandY = this.expandedHeight / 4;
        if (this.isClicked) {
            this.width = Math.min(this.expandedWidth, this.width + expandX);
            this.height = Math.min(this.expandedHeight, this.height + expandY);
            this.doneExpanding = this.width == this.expandedWidth && this.height == this.expandedHeight;
            int scaledWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            int scaledHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            if (this.isLeftSided()) {
                if (this.getX() >= scaledWidth) {
                    this.setX(scaledWidth);
                }
            } else if (this.getX() < 0) {
                this.setX(1);
            }
            if (this.getY() + this.height >= scaledHeight) {
                this.setY(scaledHeight - this.height - 1);
            }
            if (this.doneExpanding && this.scrollBar != null) {
                this.curScroll = this.scrollBar.getState();
            }
        } else {
            this.width = Math.max(this.minWidth, this.width - expandX);
            this.height = Math.max(this.minHeight, this.height - expandY);
            this.doneExpanding = false;
        }
        this.effectiveY = this.getY();
        if (this.statAbove != null) {
            this.effectiveY += this.statAbove.getEffectiveY() + this.statAbove.getStatHeight();
        }
    }

    @Override
    public void renderStat(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.renderWidget(graphics, x, y, partialTicks);
    }

    protected boolean clicked(double mouseX, double mouseY) {
        if (this.leftSided) {
            return this.active && this.visible && mouseX >= (double)this.getX() - (double)this.width && mouseX < (double)this.getX() && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        }
        return super.clicked(mouseX, mouseY);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        int baseX = this.leftSided ? this.getX() - this.width : this.getX();
        this.isHovered = mouseX >= baseX && mouseY >= this.effectiveY && mouseX < baseX + this.width && mouseY < this.effectiveY + this.height;
        float zLevel = 0.0f;
        Font fontRenderer = Minecraft.getInstance().font;
        int renderBaseX = (int)Mth.lerp((float)partialTicks, (float)this.prevX, (float)this.getX());
        int renderAffectedY = (int)Mth.lerp((float)partialTicks, (float)this.prevEffectiveY, (float)this.effectiveY);
        int renderWidth = (int)Mth.lerp((float)partialTicks, (float)this.prevWidth, (float)this.width);
        int renderHeight = (int)Mth.lerp((float)partialTicks, (float)this.prevHeight, (float)this.height);
        int xOff = 1;
        if (this.leftSided) {
            renderWidth *= -1;
            xOff = -1;
        }
        graphics.fill(renderBaseX, renderAffectedY, renderBaseX + renderWidth, renderAffectedY + renderHeight, this.backGroundColor);
        int sideU = this.bgColorHi.getRGB();
        int sideD = this.bgColorLo.getRGB();
        int sideL = this.leftSided ? sideD : sideU;
        int sideR = this.leftSided ? sideU : sideD;
        graphics.fill(renderBaseX, renderAffectedY - 1, renderBaseX + renderWidth, renderAffectedY, sideU);
        graphics.fill(renderBaseX + renderWidth, renderAffectedY, renderBaseX + renderWidth + xOff, renderAffectedY + renderHeight, sideR);
        graphics.fill(renderBaseX, renderAffectedY + renderHeight, renderBaseX + renderWidth, renderAffectedY + renderHeight + 1, sideD);
        graphics.fill(renderBaseX - xOff, renderAffectedY, renderBaseX, renderAffectedY + renderHeight, sideL);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        if (this.doneExpanding) {
            String title;
            int titleYoffset;
            if (this.needTextRecalc) {
                this.recalcText();
            }
            int n = titleYoffset = (title = this.getMessage().getString()).isEmpty() ? 3 : 12;
            if (!title.isEmpty()) {
                graphics.drawString(fontRenderer, title, renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + 2, this.titleColor);
            }
            for (int i = this.curScroll; i < this.reorderingProcessors.size() && i < this.curScroll + this.getVisibleLines(); ++i) {
                FormattedCharSequence line = this.reorderingProcessors.get(i);
                int renderX = renderBaseX + (this.leftSided ? -renderWidth + 2 : 18);
                Objects.requireNonNull(fontRenderer);
                int renderY = renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset + this.reservedLines * 9;
                graphics.drawString(fontRenderer, line, renderX, renderY, this.foregroundColor, this.dropShadows.get(i).booleanValue());
            }
            PoseStack poseStack = RenderSystem.getModelViewStack();
            poseStack.pushPose();
            poseStack.translate((float)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (float)(renderAffectedY + (titleYoffset - 10)), 0.0f);
            RenderSystem.applyModelViewMatrix();
            this.subWidgets.forEach(widget -> widget.render(graphics, mouseX - renderBaseX, mouseY - renderAffectedY, partialTicks));
            poseStack.popPose();
            RenderSystem.applyModelViewMatrix();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render(graphics, renderBaseX, renderAffectedY, this.leftSided);
        }
        graphics.renderTooltip(fontRenderer, this.makeTooltip(mouseX, mouseY), Optional.empty(), mouseX, mouseY);
    }

    private List<Component> makeTooltip(int mouseX, int mouseY) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (this.mouseIsHoveringOverIcon(mouseX, mouseY)) {
            lines.add(this.getMessage());
            lines.addAll(this.getExtraTooltipText());
        }
        return lines;
    }

    @Override
    public void renderStat(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        if (this.needTextRecalc) {
            this.recalcText();
        }
        int renderBaseX = (int)Mth.lerp((float)partialTicks, (float)this.prevX, (float)this.getX());
        int renderEffectiveY = (int)Mth.lerp((float)partialTicks, (float)this.prevEffectiveY, (float)this.effectiveY);
        int renderWidth = (int)Mth.lerp((float)partialTicks, (float)this.prevWidth, (float)this.width);
        int renderHeight = (int)Mth.lerp((float)partialTicks, (float)this.prevHeight, (float)this.height);
        int[] cols = RenderUtils.decomposeColor(this.backGroundColor);
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.UNTEXTURED_QUAD_NO_DEPTH, (posMat, builder) -> {
            int rw = this.leftSided ? -renderWidth : renderWidth;
            builder.vertex(posMat, (float)renderBaseX, (float)renderEffectiveY + (float)renderHeight, 0.0f).color(cols[1], cols[2], cols[3], cols[0]).uv2(0xF000F0).endVertex();
            builder.vertex(posMat, (float)renderBaseX + (float)rw, (float)renderEffectiveY + (float)renderHeight, 0.0f).color(cols[1], cols[2], cols[3], cols[0]).uv2(0xF000F0).endVertex();
            builder.vertex(posMat, (float)renderBaseX + (float)rw, (float)renderEffectiveY, 0.0f).color(cols[1], cols[2], cols[3], cols[0]).uv2(0xF000F0).endVertex();
            builder.vertex(posMat, (float)renderBaseX, (float)renderEffectiveY, 0.0f).color(cols[1], cols[2], cols[3], cols[0]).uv2(0xF000F0).endVertex();
        });
        Matrix3f normal = matrixStack.last().normal();
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getLineLoops(5.0), (posMat, builder) -> {
            int rw = this.leftSided ? -renderWidth : renderWidth;
            float[] c1 = this.leftSided ? this.bgColorLo.getComponents(null) : this.bgColorHi.getComponents(null);
            float[] c2 = this.bgColorHi.getComponents(null);
            float[] c3 = this.leftSided ? this.bgColorHi.getComponents(null) : this.bgColorLo.getComponents(null);
            float[] c4 = this.bgColorLo.getComponents(null);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX, renderEffectiveY, 0.0f, renderBaseX + rw, renderEffectiveY, 0.0f, c1[0], c1[1], c1[2], c1[3], true);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX + rw, renderEffectiveY, 0.0f, renderBaseX + rw, renderEffectiveY + this.height, 0.0f, c2[0], c2[1], c2[2], c2[3], true);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX + rw, renderEffectiveY + this.height, 0.0f, renderBaseX, renderEffectiveY + this.height, 0.0f, c3[0], c3[1], c3[2], c3[3], true);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX, renderEffectiveY + this.height, 0.0f, renderBaseX, renderEffectiveY, 0.0f, c4[0], c4[1], c4[2], c4[3], true);
            RenderUtils.normalLine(builder, posMat, normal, renderBaseX, renderEffectiveY, 0.0f, renderBaseX + rw, renderEffectiveY, 0.0f, c1[0], c1[1], c1[2], c1[3], true);
        });
        if (this.doneExpanding) {
            matrixStack.pushPose();
            int renderX = renderBaseX + (this.leftSided ? -renderWidth + 2 : 18);
            String title = this.getMessage().getString();
            int titleOffsetY = 3;
            if (!title.isEmpty()) {
                RenderUtils.renderString3d((Component)Component.literal((String)title).withStyle(ChatFormatting.UNDERLINE), (float)renderX, (float)(renderEffectiveY + 2), this.titleColor, matrixStack, buffer, false, true);
                titleOffsetY = 12;
            }
            Objects.requireNonNull(Minecraft.getInstance().font);
            int lineHeight = 9;
            for (int i = this.curScroll; i < this.textComponents.size() && i < this.curScroll + this.getVisibleLines(); ++i) {
                int renderY = renderEffectiveY + (i - this.curScroll) * this.lineSpacing + titleOffsetY + this.reservedLines * lineHeight;
                RenderUtils.renderString3d(this.reorderingProcessors.get(i), (float)renderX, (float)renderY, 0xFFFFFF, matrixStack, buffer, false, true);
            }
            matrixStack.pushPose();
            matrixStack.translate((float)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (float)(renderEffectiveY + (titleOffsetY - 10)), 0.0f);
            this.subWidgets.stream().filter(widget -> widget instanceof ICanRender3d).forEach(widget -> ((ICanRender3d)widget).render3d(matrixStack, buffer, partialTicks));
            matrixStack.popPose();
            matrixStack.popPose();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render3d(matrixStack, buffer, renderBaseX, renderEffectiveY);
        }
    }

    private void toggle() {
        boolean bl = this.isClicked = !this.isClicked;
        if (this.isClicked && this.gui instanceof AbstractPneumaticCraftContainerScreen) {
            List<IGuiAnimatedStat> otherStats = ((AbstractPneumaticCraftContainerScreen)this.gui).getStatWidgets();
            otherStats.stream().filter(stat -> this != stat && stat.isLeftSided() == this.isLeftSided()).forEach(IGuiAnimatedStat::closeStat);
            this.subWidgets.stream().filter(w -> w instanceof EditBox).findFirst().ifPresent(w -> w.setFocused(true));
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.active && this.visible && this.getBounds().contains((int)mouseX, (int)mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isHovered()) {
            for (AbstractWidget widget : this.subWidgets) {
                if (widget.mouseClicked(mouseX - (double)this.getX(), mouseY - (double)this.effectiveY, button)) {
                    this.gui.setFocused((GuiEventListener)widget);
                    return false;
                }
                widget.setFocused(false);
            }
            this.toggle();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isHovered()) {
            for (AbstractWidget widget : this.subWidgets) {
                if (!widget.mouseReleased(mouseX - (double)this.getX(), mouseY - (double)this.effectiveY, button)) continue;
                return true;
            }
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isHovered()) {
            Rect2i bounds = this.getBounds();
            for (AbstractWidget widget : this.subWidgets) {
                if (!widget.mouseDragged(mouseX - (double)bounds.getX(), mouseY - (double)bounds.getY(), button, dragX, dragY)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double x, double y, double dirX, double dirY) {
        Rect2i bounds = this.getBounds();
        for (AbstractWidget widget : this.subWidgets) {
            if (!widget.isFocused() || !widget.mouseScrolled(x - (double)bounds.getX(), y - (double)bounds.getY(), dirX, dirY)) continue;
            return true;
        }
        return this.scrollBar != null && this.scrollBar.mouseScrolled(x, y, dirX, dirY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (AbstractWidget widget : this.subWidgets) {
            if (!widget.keyPressed(keyCode, scanCode, modifiers) && (!(widget instanceof EditBox) || !widget.isFocused() || keyCode == 256)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        for (AbstractWidget widget : this.subWidgets) {
            if (!widget.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void closeStat() {
        this.isClicked = false;
    }

    @Override
    public void openStat() {
        this.isClicked = true;
    }

    @Override
    public boolean isStatOpen() {
        return this.isClicked;
    }

    @Override
    public int getEffectiveY() {
        return this.effectiveY;
    }

    @Override
    public int getBaseX() {
        return this.getX();
    }

    @Override
    public int getBaseY() {
        return this.getY();
    }

    @Override
    public int getStatHeight() {
        return this.getHeight();
    }

    @Override
    public int getStatWidth() {
        return this.getWidth();
    }

    @Override
    public void setBaseY(int y) {
        this.setY(y);
    }

    @Override
    public void setBaseX(int x) {
        this.setX(x);
    }

    @Override
    public boolean isDoneExpanding() {
        return this.doneExpanding;
    }

    @Override
    public Rect2i getBounds() {
        return new Rect2i(this.getX() - (this.leftSided ? this.width : 0), this.effectiveY, this.width, this.height);
    }

    public void setExtraTooltipText(List<Component> extraTooltipText) {
        this.extraTooltipText = extraTooltipText;
    }

    private List<Component> getExtraTooltipText() {
        return this.extraTooltipText;
    }

    private boolean mouseIsHoveringOverIcon(double x, double y) {
        if (this.leftSided) {
            return x <= (double)this.getX() && x >= (double)(this.getX() - 16) && y >= (double)this.effectiveY && y <= (double)(this.effectiveY + 16);
        }
        return x >= (double)this.getX() && x <= (double)(this.getX() + 16) && y >= (double)this.effectiveY && y <= (double)(this.effectiveY + 16);
    }

    @Override
    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    @Override
    public void setTexture(ResourceLocation texture) {
        this.statIcon = StatIcon.of(texture);
    }

    @Override
    public void setTexture(ItemStack itemStack) {
        this.statIcon = StatIcon.of(itemStack);
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public static class StatIcon {
        public static final StatIcon NONE = StatIcon.of(ItemStack.EMPTY);
        private final Either<ItemStack, ResourceLocation> texture;

        private StatIcon(Either<ItemStack, ResourceLocation> texture) {
            this.texture = texture;
        }

        public static StatIcon of(ItemStack stack) {
            return new StatIcon((Either<ItemStack, ResourceLocation>)Either.left((Object)stack));
        }

        public static StatIcon of(ItemLike item) {
            return new StatIcon((Either<ItemStack, ResourceLocation>)Either.left((Object)new ItemStack(item, 1)));
        }

        public static StatIcon of(ResourceLocation texture) {
            return new StatIcon((Either<ItemStack, ResourceLocation>)Either.right((Object)texture));
        }

        void render(GuiGraphics graphics, int x, int y, boolean leftSided) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            this.texture.ifLeft(stack -> graphics.renderItem(stack, x - (leftSided ? 16 : 0), y)).ifRight(resLoc -> graphics.blit(resLoc, x - (leftSided ? 16 : 0), y, 0.0f, 0.0f, 16, 16, 16, 16));
            RenderSystem.disableBlend();
        }

        public void render3d(PoseStack matrixStack, MultiBufferSource buffer, int x, int y) {
            this.texture.ifLeft(stack -> {
                matrixStack.pushPose();
                matrixStack.translate((float)(x + 8), (float)(y + 8), 0.0f);
                matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                matrixStack.scale(15.0f, 15.0f, 1.0f);
                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                BakedModel ibakedmodel = itemRenderer.getModel(stack, ClientUtils.getClientLevel(), null, 0);
                itemRenderer.render(stack, ItemDisplayContext.GUI, true, matrixStack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, ibakedmodel);
                matrixStack.popPose();
            }).ifRight(resLoc -> RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(resLoc), (posMat, builder) -> RenderUtils.drawTexture(matrixStack, builder, x, y, 0xF000F0)));
        }
    }

    private static class StyleChecker
    implements FormattedCharSink {
        private static final int THRESHOLD = 129;
        Style style = Style.EMPTY;
        private final int defColor;

        private StyleChecker(int defColor) {
            this.defColor = defColor;
        }

        public boolean accept(int p_accept_1_, Style p_accept_2_, int p_accept_3_) {
            if (this.style == Style.EMPTY) {
                this.style = p_accept_2_;
            }
            return true;
        }

        public boolean isLightColor() {
            int c = this.style == null || this.style.isEmpty() || this.style.getColor() == null ? this.defColor : this.style.getColor().getValue();
            return this.isLightColor(new TintColor(c));
        }

        private boolean isLightColor(TintColor bg) {
            int luminance = (int)Math.sqrt((double)(bg.getRed() * bg.getRed()) * 0.241 + (double)(bg.getGreen() * bg.getGreen()) * 0.691 + (double)(bg.getBlue() * bg.getBlue()) * 0.068);
            return luminance > 129;
        }
    }
}

