/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.client.gui.widget.ITaggedWidget;
import me.desht.pneumaticcraft.client.gui.widget.PNCWidget;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class WidgetCheckBox
extends PNCWidget<WidgetCheckBox>
implements ICheckboxWidget,
ITaggedWidget {
    public boolean checked;
    private final int color;
    private List<Component> tooltip = new ArrayList<Component>();
    private final Consumer<? super WidgetCheckBox> pressable;
    private static final int CHECKBOX_WIDTH = 10;
    private static final int CHECKBOX_HEIGHT = 10;
    private String tag = null;

    public WidgetCheckBox(int x, int y, int color, Component text, Consumer<? super WidgetCheckBox> pressable) {
        super(x, y, 10, 10, text);
        this.width = 13 + Minecraft.getInstance().font.width((FormattedText)text);
        this.color = color;
        this.pressable = pressable;
    }

    public WidgetCheckBox(int x, int y, int color, Component text) {
        this(x, y, color, text, null);
    }

    public WidgetCheckBox withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            int x = this.getX();
            int y = this.getY();
            graphics.fill(x, y, x + 10, y + 10, this.active ? -6250336 : -6710887);
            graphics.fill(x + 1, y + 1, x + 10 - 1, y + 10 - 1, this.active ? -14671840 : -5592406);
            Font fr = Minecraft.getInstance().font;
            if (this.checked) {
                graphics.drawString(fr, "\u2714", x + 2, y + 2, -16728064, false);
            }
            Component component = this.getMessage();
            Objects.requireNonNull(fr);
            graphics.drawString(fr, component, x + 3 + 10, y + 5 - 9 / 2, this.active ? this.color : -7829368, false);
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.active) {
            boolean bl = this.checked = !this.checked;
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
            if (this.tag != null) {
                NetworkHandler.sendToServer(new PacketGuiButton(this.tag));
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public WidgetCheckBox setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }
}

