/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;

public class WidgetColorSelector
extends WidgetButtonExtended
implements IDrawAfterRender {
    private boolean expanded = false;
    private DyeColor color = DyeColor.WHITE;
    private final Rect2i mainArea;
    private final Rect2i expandedArea;
    private final Consumer<WidgetColorSelector> callback;

    public WidgetColorSelector(int xIn, int yIn) {
        this(xIn, yIn, null);
    }

    public WidgetColorSelector(int xIn, int yIn, Consumer<WidgetColorSelector> callback) {
        super(xIn, yIn, 16, 16, (Component)Component.empty());
        this.mainArea = new Rect2i(xIn, yIn, this.width, this.height);
        this.expandedArea = new Rect2i(xIn, yIn + this.height, this.width * 4, this.height * 4);
        this.callback = callback;
    }

    public WidgetColorSelector withInitialColor(DyeColor color) {
        this.color = color;
        return this;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        int x = this.getX();
        int y = this.getY();
        graphics.fill(x + 3, y + 3, x + this.width - 4, y + this.height - 4, 0xFF000000 | PneumaticCraftUtils.getDyeColorAsRGB(this.color));
        graphics.hLine(x + 3, x + this.width - 3, y + this.height - 4, -10461088);
        graphics.vLine(x + this.width - 4, y + 3, y + this.height - 3, -10461088);
    }

    @Override
    public void renderAfterEverythingElse(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.expanded) {
            int x = this.getX();
            int y = this.getY();
            graphics.fill(x, y - 1 + this.height, x + this.width * 4, y - 1 + this.height * 5, -16777216);
            graphics.fill(x + 1, y + this.height, x + this.width * 4 - 1, y - 2 + this.height * 5, -8355712);
            for (DyeColor color : DyeColor.values()) {
                int dx = x + color.getId() % 4 * 16;
                int dy = y - 1 + this.height + color.getId() / 4 * 16;
                graphics.fill(dx + 3, dy + 3, dx + 13, dy + 13, 0xFF000000 | PneumaticCraftUtils.getDyeColorAsRGB(color));
                graphics.hLine(dx + 3, dx + 13, dy + 13, -10461088);
                graphics.vLine(dx + 13, dy + 3, dy + 13, -10461088);
            }
        }
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return super.clicked(mouseX, mouseY) || this.expanded && this.expandedArea.contains((int)mouseX, (int)mouseY);
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.mainArea.contains((int)mouseX, (int)mouseY)) {
            this.expanded = !this.expanded;
        } else if (this.expandedArea.contains((int)mouseX, (int)mouseY)) {
            int dx = (int)mouseX - this.expandedArea.getX();
            int dy = (int)mouseY - this.expandedArea.getY();
            int id = dx / 16 + dy / 16 * 4;
            this.color = DyeColor.byId((int)id);
            boolean bl = this.expanded = !this.expanded;
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }
    }
}

