/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class WidgetFluidFilter
extends AbstractWidget {
    final Consumer<WidgetFluidFilter> pressable;
    protected FluidStack fluidStack;

    public WidgetFluidFilter(int x, int y, Fluid fluid) {
        this(x, y, fluid, null);
    }

    public WidgetFluidFilter(int x, int y, Fluid fluid, Consumer<WidgetFluidFilter> pressable) {
        this(x, y, new FluidStack(fluid, 1000), pressable);
    }

    WidgetFluidFilter(int x, int y, FluidStack fluidStack, Consumer<WidgetFluidFilter> pressable) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.pressable = pressable;
        this.fluidStack = fluidStack;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.fluidStack.isEmpty()) {
            GuiUtils.drawFluid(graphics, new Rect2i(this.getX(), this.getY(), 16, 16), new FluidStack(this.fluidStack, 1000), null);
            List<MutableComponent> tooltip = List.of(this.fluidStack.getDisplayName(), Component.literal((String)ModNameCache.getModName(this.fluidStack.getFluid())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
            if (this.isHovered) {
                graphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public Fluid getFluid() {
        return this.fluidStack.getFluid();
    }

    public WidgetFluidFilter setFluid(Fluid fluid) {
        this.fluidStack = new FluidStack(fluid, 1000);
        return this;
    }

    public void onClick(double x, double y) {
        super.onClick(x, y);
        if (this.pressable != null) {
            this.pressable.accept(this);
        }
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

