/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.neoforge.fluids.FluidStack;

public class WidgetFluidStack
extends WidgetFluidFilter {
    private static final float TEXT_SCALE = 0.5f;
    private boolean adjustable = false;

    public WidgetFluidStack(int x, int y, FluidStack stack, Consumer<WidgetFluidFilter> pressable) {
        super(x, y, stack, pressable);
    }

    public WidgetFluidStack setAdjustable() {
        this.adjustable = true;
        return this;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public WidgetFluidStack setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        if (!this.fluidStack.isEmpty()) {
            int fluidAmount = this.fluidStack.getAmount() / 1000;
            if (fluidAmount > 1 || this.adjustable) {
                Font font = Minecraft.getInstance().font;
                MutableComponent str = Component.literal((String)(fluidAmount + "B"));
                int n = (int)((float)this.getX() - (float)font.width((FormattedText)str) * 0.5f + 16.0f);
                float f = this.getY() + 16;
                Objects.requireNonNull(font);
                GuiUtils.drawScaledText(graphics, font, (Component)str, n, (int)(f - 9.0f * 0.5f), 0xFFFFFF, 0.5f, true);
            }
            MutableComponent c = new FluidStack(this.fluidStack, 1).getDisplayName().copy();
            if (this.adjustable) {
                c.append("\n").append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.fluidmB", this.fluidStack.getAmount()).withStyle(ChatFormatting.GRAY));
            }
            c.append("\n").append((Component)Component.literal((String)ModNameCache.getModName(this.fluidStack.getFluid())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
            this.setTooltip(Tooltip.create((Component)c));
        } else {
            this.setTooltip(null);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.clicked(mouseX, mouseY)) {
            if (!this.fluidStack.isEmpty() && this.adjustable) {
                boolean shift = Screen.hasShiftDown();
                switch (button) {
                    case 0: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() / 2 : Math.max(0, this.fluidStack.getAmount() - 1000));
                        if (this.fluidStack.getAmount() >= 1000) break;
                        this.fluidStack.setAmount(0);
                        break;
                    }
                    case 1: {
                        this.fluidStack.setAmount(shift ? this.fluidStack.getAmount() * 2 : this.fluidStack.getAmount() + 1000);
                        break;
                    }
                    case 2: {
                        this.fluidStack.setAmount(0);
                    }
                }
            }
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
            return true;
        }
        return false;
    }
}

