/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.widget.PNCWidget;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class WidgetLabel
extends PNCWidget<WidgetLabel> {
    private float scale = 1.0f;
    private int color;
    private Alignment alignment = Alignment.LEFT;
    private boolean dropShadow = false;

    public WidgetLabel(int x, int y, Component text) {
        this(x, y, text, -12566464);
    }

    public WidgetLabel(int x, int y, Component text, int color) {
        super(x, y, 0, 0, text);
        this.color = color;
        this.width = Minecraft.getInstance().font.width((FormattedText)this.getMessage());
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.height = 9;
    }

    public WidgetLabel setAlignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public WidgetLabel setScale(float scale) {
        this.scale = scale;
        return this;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return switch (this.alignment) {
            default -> throw new IncompatibleClassChangeError();
            case Alignment.LEFT -> super.clicked(mouseX, mouseY);
            case Alignment.CENTRE -> super.clicked(mouseX + (double)this.width / 2.0, mouseY);
            case Alignment.RIGHT -> super.clicked(mouseX + (double)this.width, mouseY);
        };
    }

    public WidgetLabel setColor(int color) {
        this.color = color;
        return this;
    }

    public WidgetLabel setDropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public void setMessage(Component pMessage) {
        super.setMessage(pMessage);
        this.width = Minecraft.getInstance().font.width((FormattedText)this.getMessage());
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Font fr = Minecraft.getInstance().font;
            int drawX = switch (this.alignment) {
                default -> throw new IncompatibleClassChangeError();
                case Alignment.LEFT -> this.getX();
                case Alignment.CENTRE -> this.getX() - (int)((float)(this.width / 2) * this.scale);
                case Alignment.RIGHT -> this.getX() - (int)((float)this.width * this.scale);
            };
            GuiUtils.drawScaledText(graphics, fr, this.getMessage(), drawX, this.getY(), this.color, this.scale, this.dropShadow);
        }
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public static enum Alignment {
        LEFT,
        CENTRE,
        RIGHT;

    }
}

