/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class WidgetList<T>
extends AbstractWidget {
    @Nonnull
    private final Consumer<WidgetList<T>> pressable;
    private final List<T> items = new ArrayList<T>();
    private int selected = -1;
    private long lastClick = 0L;
    private boolean doubleClicked;
    private int fgColor = 0x404040;
    private int selectedFg = 0xFFFFFF;
    private int selectedBg = 0;
    private boolean inverseSelected = true;
    private ToolTipType toolTipType = ToolTipType.AUTO;

    public WidgetList(int xIn, int yIn, int width, int height) {
        this(xIn, yIn, width, height, c -> {});
    }

    public WidgetList(int xIn, int yIn, int width, int height, @Nonnull Consumer<WidgetList<T>> pressable) {
        super(xIn, yIn, width, height, (Component)Component.empty());
        this.pressable = pressable;
    }

    public WidgetList<T> setColor(int color) {
        this.fgColor = color;
        return this;
    }

    public WidgetList<T> setToolTipType(ToolTipType toolTipType) {
        this.toolTipType = toolTipType;
        return this;
    }

    public WidgetList<T> setSelectedColors(int selectedFg, int selectedBg) {
        this.selectedFg = selectedFg;
        this.selectedBg = selectedBg;
        return this;
    }

    public WidgetList<T> inverseSelected(boolean inverse) {
        this.inverseSelected = inverse;
        return this;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.drawList(graphics);
            this.setTooltip(null);
            if (this.toolTipType != ToolTipType.NONE) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                int h = 9;
                int idx = Math.max(0, (mouseY - this.getY()) / h);
                if (idx < this.items.size()) {
                    String s = this.items.get(idx).toString();
                    if (this.toolTipType == ToolTipType.ALWAYS || Minecraft.getInstance().font.width(s) * 3 / 4 > this.width) {
                        this.setTooltip(Tooltip.create((Component)Component.literal((String)s)));
                    }
                }
            }
        }
    }

    public boolean isDoubleClicked() {
        return this.doubleClicked;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public void unselectAll() {
        this.selected = -1;
    }

    public List<T> getLines() {
        return ImmutableList.copyOf(this.items);
    }

    public T getSelectedLine() {
        return this.selected >= 0 && this.selected < this.items.size() ? (T)this.items.get(this.selected) : null;
    }

    public boolean contains(T s) {
        return this.items.contains(s);
    }

    public void add(T s) {
        this.items.add(s);
    }

    public void removeSelected() {
        if (this.selected >= 0 && this.selected < this.items.size()) {
            this.items.remove(this.selected);
            this.updateSelection();
        }
    }

    public void clear() {
        this.items.clear();
        this.setSelected(-1);
    }

    private void updateSelection() {
        if (this.items.isEmpty()) {
            this.selected = -1;
        } else if (this.selected >= this.items.size()) {
            this.selected = this.items.size() - 1;
        }
    }

    public int size() {
        return this.items.size();
    }

    private void drawList(GuiGraphics graphics) {
        Minecraft mc = Minecraft.getInstance();
        Objects.requireNonNull(mc.font);
        int lineHeight = 9;
        int lines = this.height / lineHeight;
        int x = this.getX();
        int y = this.getY();
        graphics.pose().pushPose();
        graphics.enableScissor(x, y, x + this.width, y + this.height);
        if (this.inverseSelected && this.selected >= 0) {
            graphics.fill(x, y + lineHeight * this.selected, x + this.width, y + lineHeight * (this.selected + 1), 0xFF000000 | this.selectedBg);
        }
        graphics.pose().translate((float)x, (float)y, 0.0f);
        graphics.pose().scale(0.75f, 1.0f, 1.0f);
        for (int i = 0; i < this.items.size() && i < lines; ++i) {
            graphics.drawString(mc.font, this.items.get(i).toString(), 0, i * lineHeight, i == this.selected ? this.selectedFg : this.fgColor, false);
        }
        graphics.disableScissor();
        graphics.pose().popPose();
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.active) {
            long now = System.currentTimeMillis();
            Objects.requireNonNull(Minecraft.getInstance().font);
            int h = 9;
            int newSel = Mth.clamp((int)((int)(mouseY - (double)this.getY()) / h), (int)0, (int)(this.items.size() - 1));
            this.doubleClicked = now - this.lastClick < 250L && newSel == this.selected;
            this.setSelected(newSel);
            this.lastClick = now;
            this.pressable.accept(this);
        }
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public static enum ToolTipType {
        NONE,
        AUTO,
        ALWAYS;

    }
}

