/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class WidgetTank
extends AbstractWidget {
    private final IFluidTank tank;

    public WidgetTank(int x, int y, IFluidTank tank) {
        super(x, y, 16, 64, (Component)Component.empty());
        this.tank = tank;
    }

    public WidgetTank(int x, int y, FluidStack stack) {
        this(x, y, (IFluidTank)WidgetTank.makeTank(stack, 160000));
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack) {
        super(x, y, width, height, (Component)Component.empty());
        this.tank = WidgetTank.makeTank(stack, stack.getAmount());
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack, int capacity) {
        super(x, y, width, height, (Component)Component.empty());
        this.tank = WidgetTank.makeTank(stack, capacity);
    }

    private static FluidTank makeTank(FluidStack stack, int capacity) {
        return (FluidTank)Util.make((Object)new FluidTank(capacity), tank -> tank.fill(stack, IFluidHandler.FluidAction.EXECUTE));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int x = this.getX();
        int y = this.getY();
        GuiUtils.drawFluid(graphics, new Rect2i(x, y, this.width, this.height), this.getFluid(), this.getTank());
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 300.0f);
        for (int i = 3; i < this.height - 1; i += 4) {
            int width = (i - 3) % 20 == 0 ? 16 : 2;
            graphics.fill(x, y + i, x + width, y + i + 1, -13684945);
        }
        graphics.pose().popPose();
        if (this.isHovered) {
            graphics.renderTooltip(Minecraft.getInstance().font, this.makeTooltip(), Optional.empty(), mouseX, mouseY);
        }
    }

    public List<Component> makeTooltip() {
        Fluid fluid = this.tank.getFluid().getFluid();
        String amt = NumberFormat.getNumberInstance(Locale.getDefault()).format(this.tank.getFluidAmount());
        String capacity = NumberFormat.getNumberInstance(Locale.getDefault()).format(this.tank.getCapacity());
        ArrayList<Component> l = new ArrayList<Component>();
        l.add((Component)Component.literal((String)(amt + " / " + capacity + " mB")));
        if (fluid == Fluids.EMPTY || this.tank.getCapacity() == 0 || this.tank.getFluidAmount() == 0) {
            l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).withStyle(ChatFormatting.GRAY));
        } else {
            l.add((Component)new FluidStack(fluid, this.tank.getFluidAmount()).getDisplayName().copy().withStyle(ChatFormatting.GRAY));
            l.add((Component)Component.literal((String)ModNameCache.getModName(fluid)).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        return l;
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public void setFluid(FluidStack fluidStack) {
        if (fluidStack.getFluid() != this.tank.getFluid().getFluid()) {
            this.tank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            this.tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        } else if (fluidStack.getAmount() > this.tank.getFluidAmount()) {
            this.tank.fill(new FluidStack(fluidStack.getFluid(), fluidStack.getAmount() - this.tank.getFluidAmount()), IFluidHandler.FluidAction.EXECUTE);
        } else if (fluidStack.getAmount() < this.tank.getFluidAmount()) {
            this.tank.drain(this.tank.getFluidAmount() - fluidStack.getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

