/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.text.NumberFormat;
import java.text.ParseException;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.math.NumberUtils;

public class WidgetTextFieldNumber
extends WidgetTextField {
    public int minValue = Integer.MIN_VALUE;
    public int maxValue = Integer.MAX_VALUE;
    private int decimals;
    private double fineAdjust = 1.0;
    private double coarseAdjust = 1000.0;

    public WidgetTextFieldNumber(Font fontRenderer, int x, int y, int width, int height) {
        super(fontRenderer, x, y, width, height);
        this.setValue(0);
        this.setFilter(input -> this.decimals == 0 ? PneumaticCraftUtils.isInteger(input) : PneumaticCraftUtils.isNumber(input));
    }

    public WidgetTextFieldNumber setRange(int min, int max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    public WidgetTextFieldNumber setDecimals(int decimals) {
        this.decimals = decimals;
        return this;
    }

    public WidgetTextFieldNumber setValue(int value) {
        this.setValue(Integer.toString(Mth.clamp((int)value, (int)this.minValue, (int)this.maxValue)));
        return this;
    }

    public WidgetTextFieldNumber setValue(double value) {
        this.setValue(PneumaticCraftUtils.roundNumberTo(Mth.clamp((double)value, (double)this.minValue, (double)this.maxValue), this.decimals));
        return this;
    }

    public int getIntValue() {
        return Mth.clamp((int)NumberUtils.toInt((String)this.getValue()), (int)this.minValue, (int)this.maxValue);
    }

    public double getDoubleValue() {
        try {
            Number n = NumberFormat.getNumberInstance().parse(this.getValue());
            return PneumaticCraftUtils.roundNumberToDouble(Mth.clamp((double)n.doubleValue(), (double)this.minValue, (double)this.maxValue), this.decimals);
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public WidgetTextFieldNumber setAdjustments(double fineAdjust, double coarseAdjust) {
        this.fineAdjust = fineAdjust;
        this.coarseAdjust = coarseAdjust;
        return this;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double adj;
        double d = adj = ClientUtils.hasShiftDown() ? this.coarseAdjust : this.fineAdjust;
        if (this.decimals > 0) {
            this.setValue(this.getDoubleValue() + (deltaY > 0.0 ? adj : -adj));
        } else {
            int curVal = this.getIntValue();
            if (curVal == 1 && adj % 10.0 == 0.0) {
                adj -= 1.0;
            }
            this.setValue((double)curVal + (deltaY > 0.0 ? adj : -adj));
        }
        return true;
    }
}

