/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.gui.widget.ICanRender3d;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.Validate;
import org.joml.Matrix4f;

public class WidgetVerticalScrollbar
extends AbstractWidget
implements ICanRender3d {
    public float currentScroll;
    private int states;
    private boolean listening;
    private boolean dragging;

    public WidgetVerticalScrollbar(int x, int y, int height) {
        super(x, y, 14, height, (Component)Component.empty());
    }

    public WidgetVerticalScrollbar setStates(int states) {
        this.states = states;
        return this;
    }

    public WidgetVerticalScrollbar setCurrentState(int state) {
        Validate.isTrue((state >= 0 && state <= this.states ? 1 : 0) != 0, (String)("State " + state + " out of range! Valid range [1 - " + this.states + "] inclusive"), (Object[])new Object[0]);
        this.currentScroll = (float)state / (float)this.states;
        return this;
    }

    public boolean mouseScrolled(double x, double y, double dirX, double dirY) {
        if (this.active && this.listening) {
            double wheel = Mth.clamp((double)(-dirY), (double)-1.0, (double)1.0);
            this.currentScroll = Mth.clamp((float)(this.currentScroll + (float)wheel / (float)this.states), (float)0.0f, (float)1.0f);
            return true;
        }
        return false;
    }

    public void onClick(double x, double y) {
        this.currentScroll = (float)(y - 7.0 - (double)this.getY()) / (float)(this.height - 17);
        this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
        this.dragging = true;
    }

    public void onRelease(double x, double y) {
        this.dragging = false;
    }

    protected void onDrag(double x, double y, double dx, double dy) {
        this.dragging = true;
        this.currentScroll = (float)(y - 7.0 - (double)this.getY()) / (float)(this.height - 17);
        this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
    }

    public WidgetVerticalScrollbar setListening(boolean listening) {
        this.listening = listening;
        return this;
    }

    public int getState() {
        float scroll = this.currentScroll;
        return Mth.clamp((int)((int)((scroll += 0.5f / (float)this.states) * (float)this.states)), (int)0, (int)this.states);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            int x = this.getX();
            int y = this.getY();
            graphics.blit(Textures.WIDGET_VERTICAL_SCROLLBAR, x, y, 12.0f, 0.0f, this.width, 1, 26, 15);
            for (int i = 0; i < this.height - 2; ++i) {
                graphics.blit(Textures.WIDGET_VERTICAL_SCROLLBAR, x, y + 1 + i, 12.0f, 1.0f, this.width, 1, 26, 15);
            }
            graphics.blit(Textures.WIDGET_VERTICAL_SCROLLBAR, x, y + this.height - 1, 12.0f, 14.0f, this.width, 1, 26, 15);
            if (!this.active) {
                graphics.setColor(0.6f, 0.6f, 0.6f, 1.0f);
            }
            graphics.blit(Textures.WIDGET_VERTICAL_SCROLLBAR, x + 1, y + 1 + (int)((float)(this.height - 17) * this.currentScroll), 0.0f, 0.0f, 12, 15, 26, 15);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void render3d(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        if (this.visible) {
            int x = this.getX();
            int y = this.getY();
            RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(Textures.WIDGET_VERTICAL_SCROLLBAR, true), (posMat, builder) -> {
                this.blit3d((VertexConsumer)builder, (Matrix4f)posMat, x, y, 12, 0, this.width, 1, 26, 15);
                for (int i = 0; i < this.height - 2; ++i) {
                    this.blit3d((VertexConsumer)builder, (Matrix4f)posMat, x, y + 1 + i, 12, 1, this.width, 1, 26, 15);
                }
                this.blit3d((VertexConsumer)builder, (Matrix4f)posMat, x, y + this.height - 1, 12, 14, this.width, 1, 26, 15);
                this.blit3d((VertexConsumer)builder, (Matrix4f)posMat, x + 1, y + 1 + (int)((float)(this.height - 17) * this.currentScroll), 0, 0, 12, 15, 26, 15);
            });
        }
    }

    private void blit3d(VertexConsumer builder, Matrix4f posMat, int x, int y, int textureX, int textureY, int width, int height, int textureWidth, int textureHeight) {
        float u1 = (float)textureX / (float)textureWidth;
        float u2 = (float)(textureX + width) / (float)textureWidth;
        float v1 = (float)textureY / (float)textureHeight;
        float v2 = (float)(textureY + height) / (float)textureHeight;
        RenderUtils.posF(builder, posMat, x, y + height, 0.0).color(255, 255, 255, 255).uv(u1, v2).uv2(0xF000F0).endVertex();
        RenderUtils.posF(builder, posMat, x + width, y + height, 0.0).color(255, 255, 255, 255).uv(u2, v2).uv2(0xF000F0).endVertex();
        RenderUtils.posF(builder, posMat, x + width, y, 0.0).color(255, 255, 255, 255).uv(u2, v1).uv2(0xF000F0).endVertex();
        RenderUtils.posF(builder, posMat, x, y, 0.0).color(255, 255, 255, 255).uv(u1, v1).uv2(0xF000F0).endVertex();
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

