/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ModelMinigun
extends Model {
    private final ModelPart barrel;
    private final ModelPart support1;
    private final ModelPart support2;
    private final ModelPart support3;
    private final ModelPart support4;
    private final ModelPart support5;
    private final ModelPart main;
    private final ModelPart magazine;
    private final ModelPart mount;
    private final ModelPart magazineColor;
    private static final String BARREL = "barrel";
    private static final String SUPPORT1 = "support1";
    private static final String SUPPORT2 = "support2";
    private static final String SUPPORT3 = "support3";
    private static final String SUPPORT4 = "support4";
    private static final String SUPPORT5 = "support5";
    private static final String MAIN = "main";
    private static final String MAGAZINE = "magazine";
    private static final String MOUNT = "mount";
    private static final String MOUNT_R1 = "mount_r1";
    private static final String MOUNT_R2 = "mount_r2";
    private static final String MAGAZINECOLOR = "magazineColor";

    public ModelMinigun(ModelPart root) {
        super(RenderType::entityCutoutNoCull);
        this.barrel = root.getChild(BARREL);
        this.support1 = root.getChild(SUPPORT1);
        this.support2 = root.getChild(SUPPORT2);
        this.support3 = root.getChild(SUPPORT3);
        this.support4 = root.getChild(SUPPORT4);
        this.support5 = root.getChild(SUPPORT5);
        this.main = root.getChild(MAIN);
        this.magazine = root.getChild(MAGAZINE);
        this.mount = root.getChild(MOUNT);
        this.magazineColor = root.getChild(MAGAZINECOLOR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BARREL, CubeListBuilder.create().texOffs(30, 15).addBox("barrel_0", -0.5f, 1.4333f, -4.0f, 1, 1, 20, 0, 3), PartPose.offset((float)0.0f, (float)20.9667f, (float)-8.0f));
        partdefinition.addOrReplaceChild(SUPPORT1, CubeListBuilder.create().texOffs(0, 0).addBox("support1_0", -1.5f, -1.5f, -5.0f, 3, 3, 4, 22, 16).addBox("support1_1", -1.5f, -1.5f, 0.0f, 3, 3, 1, 0, 13).addBox("support1_2", -1.5f, -1.5f, 5.0f, 3, 3, 1, 0, 13).addBox("support1_3", -1.5f, -1.5f, 7.0f, 3, 3, 1, 0, 13).addBox("support1_4", -1.5f, -1.5f, 13.0f, 3, 3, 1, 0, 13), PartPose.offset((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild(SUPPORT2, CubeListBuilder.create().texOffs(0, 4).addBox("support2_0", -1.5f, 1.5f, -5.0f, 3, 1, 4, 22, 8).addBox("support2_1", -1.5f, 1.5f, 0.0f, 3, 1, 1, 0, 11).addBox("support2_2", -1.5f, 1.5f, 5.0f, 3, 1, 1, 0, 21).addBox("support2_3", -1.5f, 1.5f, 7.0f, 3, 1, 1, 0, 21).addBox("support2_4", -1.5f, 1.5f, 13.0f, 3, 1, 1, 0, 21), PartPose.offset((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild(SUPPORT3, CubeListBuilder.create().texOffs(0, 6).addBox("support3_0", -1.5f, -2.5f, -5.0f, 3, 1, 4, 22, 8).addBox("support3_1", -1.5f, -2.5f, 0.0f, 3, 1, 1, 0, 11).addBox("support3_2", -1.5f, -2.5f, 5.0f, 3, 1, 1, 0, 11).addBox("support3_3", -1.5f, -2.5f, 7.0f, 3, 1, 1, 0, 11).addBox("support3_4", -1.5f, -2.5f, 13.0f, 3, 1, 1, 0, 11), PartPose.offset((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild(SUPPORT4, CubeListBuilder.create().texOffs(0, 8).addBox("support4_0", 1.5f, -1.5f, -5.0f, 1, 3, 4, 22, 1).addBox("support4_1", 1.5f, -1.5f, 0.0f, 1, 3, 1, 0, 17).addBox("support4_2", 1.5f, -1.5f, 5.0f, 1, 3, 1, 4, 17).addBox("support4_3", 1.5f, -1.5f, 7.0f, 1, 3, 1, 4, 17).addBox("support4_4", 1.5f, -1.5f, 13.0f, 1, 3, 1, 4, 17), PartPose.offset((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild(SUPPORT5, CubeListBuilder.create().texOffs(0, 11).addBox("support5_0", -2.5f, -1.5f, -5.0f, 1, 3, 4, 32, 1).addBox("support5_1", -2.5f, -1.5f, 0.0f, 1, 3, 1, 0, 17).addBox("support5_2", -2.5f, -1.5f, 5.0f, 1, 3, 1, 0, 17).addBox("support5_3", -2.5f, -1.5f, 7.0f, 1, 3, 1, 4, 17).addBox("support5_4", -2.5f, -1.5f, 13.0f, 1, 3, 1, 4, 17), PartPose.offset((float)0.0f, (float)21.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild(MAIN, CubeListBuilder.create().texOffs(36, 0).addBox("main_0", 0.0f, 0.0f, 1.0f, 6, 6, 8, 36, 18).addBox("main_1", 0.5f, 0.5f, 0.0f, 5, 5, 10, 34, 3), PartPose.offset((float)-3.0f, (float)18.0f, (float)8.0f));
        partdefinition.addOrReplaceChild(MAGAZINE, CubeListBuilder.create().texOffs(0, 14).addBox("magazine_0", -8.0f, -2.0f, 2.5f, 5, 6, 5, 0, 0).mirror(), PartPose.offset((float)3.0f, (float)22.0f, (float)9.0f));
        PartDefinition mount = partdefinition.addOrReplaceChild(MOUNT, CubeListBuilder.create().texOffs(0, 23), PartPose.offset((float)-1.0f, (float)15.0f, (float)11.0f));
        mount.addOrReplaceChild(MOUNT_R1, CubeListBuilder.create().texOffs(0, 23).addBox("mount_r1_0", -0.5f, -3.0f, -0.75f, 1, 2, 1, 60, 0), PartPose.offsetAndRotation((float)1.0f, (float)2.0f, (float)2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        mount.addOrReplaceChild(MOUNT_R2, CubeListBuilder.create().texOffs(0, 23).addBox("mount_r2_0", -1.0f, -5.0f, -1.0f, 2, 1, 3, 54, 3).addBox("mount_r2_1", -1.0f, -4.0f, 0.0f, 2, 6, 2, 56, 18), PartPose.offsetAndRotation((float)1.0f, (float)2.0f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(MAGAZINECOLOR, CubeListBuilder.create().texOffs(8, 0).addBox("magazineColor_0", -9.6f, -2.0f, 2.0f, 1, 2, 4, 54, 7).mirror(), PartPose.offset((float)4.3f, (float)22.5f, (float)10.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderMinigun(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Minigun minigun, float partialTick, boolean renderMount) {
        VertexConsumer builder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_DRONE_MINIGUN));
        matrixStack.pushPose();
        if (renderMount) {
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.3125, -0.75);
            this.mount.render(matrixStack, builder, combinedLight, combinedOverlay);
            matrixStack.popPose();
        }
        float barrelRotation = 0.0f;
        if (minigun != null) {
            barrelRotation = minigun.getOldMinigunRotation() + partialTick * (minigun.getMinigunRotation() - minigun.getOldMinigunRotation());
            float yaw = minigun.oldMinigunYaw + partialTick * Minigun.clampYaw(minigun.minigunYaw - minigun.oldMinigunYaw);
            float pitch = minigun.oldMinigunPitch + partialTick * (minigun.minigunPitch - minigun.oldMinigunPitch);
            matrixStack.translate(0.0, 1.4375, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(yaw));
            matrixStack.mulPose(Axis.XP.rotationDegrees(pitch));
            matrixStack.translate(0.0, -1.125, -0.75);
        }
        this.barrel.yRot = 0.0f;
        this.barrel.xRot = 0.0f;
        for (int i = 0; i < 6; ++i) {
            this.barrel.zRot = (float)(1.0471975511965976 * (double)i) + barrelRotation;
            this.barrel.render(matrixStack, builder, combinedLight, combinedOverlay);
        }
        this.support1.zRot = barrelRotation;
        this.support2.zRot = barrelRotation;
        this.support3.zRot = barrelRotation;
        this.support4.zRot = barrelRotation;
        this.support5.zRot = barrelRotation;
        this.support1.render(matrixStack, builder, combinedLight, combinedOverlay);
        this.support2.render(matrixStack, builder, combinedLight, combinedOverlay);
        this.support3.render(matrixStack, builder, combinedLight, combinedOverlay);
        this.support4.render(matrixStack, builder, combinedLight, combinedOverlay);
        this.support5.render(matrixStack, builder, combinedLight, combinedOverlay);
        this.magazine.render(matrixStack, builder, combinedLight, combinedOverlay);
        this.main.render(matrixStack, builder, combinedLight, combinedOverlay);
        float[] cols = RenderUtils.decomposeColorF(minigun != null ? 0xFF000000 | minigun.getAmmoColor() : -13553359);
        this.magazineColor.render(matrixStack, builder, combinedLight, combinedOverlay, cols[1], cols[2], cols[3], cols[0]);
        matrixStack.popPose();
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
    }
}

