/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker.TrackerBlacklistManager;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;

public class BlockTrackEntryEnergy
implements IBlockTrackEntry {
    public static final ResourceLocation ID = PneumaticRegistry.RL("block_tracker.module.energy");

    @Override
    public boolean shouldTrackWithThisEntry(BlockGetter world, BlockPos pos, BlockState state, BlockEntity te) {
        return te != null && !TrackerBlacklistManager.isEnergyBlacklisted(te) && IBlockTrackEntry.hasCapabilityOnAnyFace(te, Capabilities.EnergyStorage.BLOCK);
    }

    @Override
    public List<BlockPos> getServerUpdatePositions(BlockEntity te) {
        return te == null ? Collections.emptyList() : Collections.singletonList(te.getBlockPos());
    }

    @Override
    public int spamThreshold() {
        return 8;
    }

    @Override
    public void addInformation(Level world, BlockPos pos, BlockEntity te, Direction face, List<Component> infoList) {
        try {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.rf", new Object[0]));
            IOHelper.getEnergyStorageForBlock(te, face).ifPresent(storage -> infoList.add((Component)Component.literal((String)(storage.getEnergyStored() + " / " + storage.getMaxEnergyStored() + " RF"))));
        }
        catch (Throwable e) {
            TrackerBlacklistManager.addEnergyTEToBlacklist(te, e);
        }
    }

    @Override
    public ResourceLocation getEntryID() {
        return ID;
    }
}

