/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.BlockTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.BlockTrackOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker.BlockTrackHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.SearchClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.BlockTrackerHandler;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForge;

public class BlockTrackerClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<BlockTrackerHandler> {
    static final int BLOCK_TRACKING_RANGE = 30;
    private static final int HARD_MAX_BLOCKS_PER_TICK = 50000;
    private static final StatPanelLayout DEFAULT_STAT_LAYOUT = StatPanelLayout.expandsLeft(0.995f, 0.1f);
    private final Map<BlockPos, RenderBlockTarget> blockTargets = new Object2ObjectOpenHashMap();
    private IGuiAnimatedStat blockTrackInfo;
    private final Object2IntMap<ResourceLocation> blockTypeCount = new Object2IntOpenHashMap();
    private final Object2IntMap<ResourceLocation> blockTypeCountPartial = new Object2IntOpenHashMap();
    private int xOff = 0;
    private int yOff = 0;
    private int zOff = 0;
    private RenderBlockTarget focusedTarget = null;
    private Direction focusedFace = null;

    public BlockTrackerClientHandler() {
        super(CommonUpgradeHandlers.blockTrackerHandler);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        if (!isEnabled) {
            return;
        }
        int blockTrackRange = 30 + Math.min(armorHandler.getUpgradeCount(EquipmentSlot.HEAD, ModUpgrades.RANGE.get()), 5) * 5;
        int blockTrackRangeSq = blockTrackRange * blockTrackRange;
        long now = System.nanoTime();
        Player player = armorHandler.getPlayer();
        Level world = armorHandler.getPlayer().level();
        SearchClientHandler searcher = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.searchHandler, SearchClientHandler.class);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 50000 && ((i & 0xFF) != 0 || System.nanoTime() - now <= (long)((Integer)ConfigHelper.client().armor.blockTrackerMaxTimePerTick.get()).intValue() * 500000L); ++i) {
            List<IBlockTrackEntry> entries;
            BlockEntity te;
            BlockTrackEvent event;
            this.nextScanPos(pos, player, blockTrackRange);
            if (!world.isLoaded((BlockPos)pos)) break;
            if (world.isEmptyBlock((BlockPos)pos) || (event = (BlockTrackEvent)NeoForge.EVENT_BUS.post((Event)new BlockTrackEvent(world, (BlockPos)pos, te = world.getBlockEntity((BlockPos)pos)))).isCanceled()) continue;
            if (te != null && IOHelper.getInventoryForBlock(te).isPresent()) {
                searcher.onBlockTrackStart(te);
            }
            if ((entries = BlockTrackHandler.getInstance().getEntriesForCoordinate((BlockGetter)world, (BlockPos)pos, te)).isEmpty()) continue;
            entries.forEach(entry -> this.blockTypeCountPartial.mergeInt((Object)entry.getEntryID(), 1, Integer::sum));
            RenderBlockTarget blockTarget = this.blockTargets.get(pos);
            if (blockTarget != null) {
                blockTarget.markValid();
                blockTarget.setTileEntity(te);
                continue;
            }
            if (!(pos.distSqr((Vec3i)player.blockPosition()) < (double)blockTrackRangeSq)) continue;
            this.addBlockTarget(new RenderBlockTarget(world, player, pos.immutable(), te, this));
        }
        this.checkBlockFocus(player, blockTrackRange);
        this.processTrackerEntries(blockTrackRange);
        this.updateTrackerText();
    }

    private void checkBlockFocus(Player player, int blockTrackRange) {
        Vec3 eyes;
        this.focusedTarget = null;
        this.focusedFace = null;
        Vec3 v = eyes = player.getEyePosition(1.0f);
        Vec3 lookVec = player.getLookAngle().scale(0.25);
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < blockTrackRange * 4; ++i) {
            BlockState state;
            BlockHitResult brtr;
            v = v.add(lookVec);
            checkPos.set(v.x, v.y, v.z);
            if (!this.blockTargets.containsKey(checkPos) || (brtr = (state = player.level().getBlockState((BlockPos)checkPos)).getShape((BlockGetter)player.level(), (BlockPos)checkPos).clip(eyes, v, (BlockPos)checkPos)) == null || brtr.getType() != HitResult.Type.BLOCK) continue;
            this.focusedTarget = this.blockTargets.get(checkPos);
            this.focusedFace = brtr.getDirection();
            break;
        }
    }

    public BlockPos getFocusedPos() {
        return this.focusedTarget == null ? null : this.focusedTarget.getPos();
    }

    public Direction getFocusedFace() {
        return this.focusedFace;
    }

    private void nextScanPos(BlockPos.MutableBlockPos pos, Player player, int range) {
        Vec3 look = player.getLookAngle();
        Direction dir = Direction.getNearest((double)look.x(), (double)look.y(), (double)look.z());
        switch (dir) {
            case UP: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = 0;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case DOWN: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (--this.yOff >= -range) break;
                this.yOff = 0;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case EAST: {
                if (++this.xOff <= range) break;
                this.xOff = 0;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case WEST: {
                if (--this.xOff >= -range) break;
                this.xOff = 0;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = -range;
                this.updateBlockTypeCounts();
                break;
            }
            case NORTH: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (--this.zOff >= -range) break;
                this.zOff = 0;
                this.updateBlockTypeCounts();
                break;
            }
            case SOUTH: {
                if (++this.xOff <= range) break;
                this.xOff = -range;
                if (++this.yOff <= range) break;
                this.yOff = -range;
                if (++this.zOff <= range) break;
                this.zOff = 0;
                this.updateBlockTypeCounts();
            }
        }
        int minY = player.level().getMinBuildHeight();
        int maxY = player.level().getMaxBuildHeight();
        pos.set(player.getX() + (double)this.xOff, Mth.clamp((double)(player.getY() + (double)this.yOff), (double)minY, (double)maxY), player.getZ() + (double)this.zOff);
    }

    private void updateBlockTypeCounts() {
        this.blockTypeCount.clear();
        this.blockTypeCount.putAll(this.blockTypeCountPartial);
        this.blockTypeCountPartial.clear();
    }

    private void processTrackerEntries(int blockTrackRange) {
        int rangeSq = (blockTrackRange + 5) * (blockTrackRange + 5);
        for (RenderBlockTarget blockTarget : this.blockTargets.values()) {
            blockTarget.tick();
            blockTarget.checkValidity(rangeSq);
        }
        this.blockTargets.values().removeIf(RenderBlockTarget::shouldRemoveNow);
    }

    private void updateTrackerText() {
        if (this.focusedTarget != null) {
            this.blockTrackInfo.setTitle((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.block_tracker", new Object[0]));
            this.blockTrackInfo.setText(this.focusedTarget.getTitle());
        } else {
            this.blockTrackInfo.setTitle((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.trackedBlocks", new Object[0]));
            ArrayList<Component> textList = new ArrayList<Component>();
            this.blockTypeCount.forEach((upgradeId, count) -> {
                if (count > 0 && WidgetKeybindCheckBox.get((ResourceLocation)upgradeId).checked) {
                    textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.countedItem", count, PneumaticCraftUtils.xlate(IArmorUpgradeHandler.getStringKey(upgradeId), new Object[0])));
                }
            });
            if (textList.isEmpty()) {
                textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.noTrackedBlocks", new Object[0]));
            }
            this.blockTrackInfo.setText(textList);
        }
    }

    private void addBlockTarget(RenderBlockTarget blockTarget) {
        this.blockTargets.put(blockTarget.getPos(), blockTarget);
    }

    public int countBlockTrackersOfType(IBlockTrackEntry type) {
        return this.blockTypeCount.getOrDefault((Object)type.getEntryID(), 0);
    }

    @Override
    public void render3D(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        this.blockTargets.values().forEach(t -> t.render(matrixStack, buffer, partialTicks));
    }

    @Override
    public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
    }

    @Override
    public void reset() {
        this.blockTypeCountPartial.clear();
        this.blockTypeCount.clear();
        this.blockTargets.clear();
        this.blockTrackInfo = null;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new BlockTrackOptions(screen, this);
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.blockTrackInfo == null) {
            ItemStack icon = ModUpgrades.BLOCK_TRACKER.get().getItemStack();
            this.blockTrackInfo = ClientArmorRegistry.getInstance().makeHUDStatPanel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.blockTracker.info.trackedBlocks", new Object[0]), icon, this);
            this.blockTrackInfo.setMinimumContractedDimensions(0, 0);
            this.blockTrackInfo.setAutoLineWrap(false);
        }
        return this.blockTrackInfo;
    }

    @Override
    public StatPanelLayout getDefaultStatLayout() {
        return DEFAULT_STAT_LAYOUT;
    }

    public void hack() {
        if (this.focusedTarget != null) {
            this.focusedTarget.hack();
        }
    }

    public RenderBlockTarget getTargetForCoord(BlockPos pos) {
        return this.blockTargets.get(pos);
    }

    public boolean scroll(InputEvent.MouseScrollingEvent event) {
        for (RenderBlockTarget target : this.blockTargets.values()) {
            if (!target.scroll(event)) continue;
            this.getAnimatedStat().mouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDeltaX(), event.getScrollDeltaY());
            return true;
        }
        return false;
    }

    @Override
    public void onResolutionChanged() {
        this.blockTrackInfo = null;
    }

    @Override
    public Collection<ResourceLocation> getSubKeybinds() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(BlockTrackHandler.getInstance().getIDs());
        return builder.build();
    }

    @Override
    public String getSubKeybindCategory() {
        return "key.pneumaticcraft.category.block_tracker";
    }

    @Override
    public void setOverlayColor(int color) {
        super.setOverlayColor(color);
        this.blockTargets.values().forEach(target -> target.updateColor(color));
    }
}

